/*
 * Global Information System API Client
 * Genesys API client to the Global Information System (GLIS) for PGRFA  [https://glis.planttreaty.org](https://glis.planttreaty.org).
 *
 * OpenAPI spec version: 1.1-SNAPSHOT
 * Contact: helpdesk@genesys-pgr.org
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.genesys.glis.v1.api;

import org.genesys.glis.v1.invoker.ApiCallback;
import org.genesys.glis.v1.invoker.ApiClient;
import org.genesys.glis.v1.invoker.ApiException;
import org.genesys.glis.v1.invoker.ApiResponse;
import org.genesys.glis.v1.invoker.Configuration;
import org.genesys.glis.v1.invoker.Pair;
import org.genesys.glis.v1.invoker.ProgressRequestBody;
import org.genesys.glis.v1.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.genesys.glis.v1.model.DOIArray;
import org.genesys.glis.v1.model.DOIHolder;
import org.genesys.glis.v1.model.PGRFA;
import org.genesys.glis.v1.model.RateLimitError;
import org.genesys.glis.v1.model.Relationship;
import org.genesys.glis.v1.model.Term;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryApi {
    private ApiClient apiClient;

    public QueryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public QueryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for listHolders
     * @param dois  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call listHoldersCall(DOIArray dois, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = dois;

        // create path and map variables
        String localVarPath = "/glisapi/v1/holders";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "easySmta" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call listHoldersValidateBeforeCall(DOIArray dois, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = listHoldersCall(dois, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Query for holder of PGRFA by DOIs
     * Query GLIS for WIEWS code of the holder for each submitted DOI. At this time, the call has a limit of 1,000 DOIs.
     * @param dois  (optional)
     * @return List&lt;DOIHolder&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<DOIHolder> listHolders(DOIArray dois) throws ApiException {
        ApiResponse<List<DOIHolder>> resp = listHoldersWithHttpInfo(dois);
        return resp.getData();
    }

    /**
     * Query for holder of PGRFA by DOIs
     * Query GLIS for WIEWS code of the holder for each submitted DOI. At this time, the call has a limit of 1,000 DOIs.
     * @param dois  (optional)
     * @return ApiResponse&lt;List&lt;DOIHolder&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<DOIHolder>> listHoldersWithHttpInfo(DOIArray dois) throws ApiException {
        com.squareup.okhttp.Call call = listHoldersValidateBeforeCall(dois, null, null);
        Type localVarReturnType = new TypeToken<List<DOIHolder>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Query for holder of PGRFA by DOIs (asynchronously)
     * Query GLIS for WIEWS code of the holder for each submitted DOI. At this time, the call has a limit of 1,000 DOIs.
     * @param dois  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call listHoldersAsync(DOIArray dois, final ApiCallback<List<DOIHolder>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = listHoldersValidateBeforeCall(dois, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<DOIHolder>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for listRelationships
     * @param doi Digital Object Identifier (DOI) associated to the PGRFA for which relations are requested. Mandatory (required)
     * @param role Role of doi in the relationships. Optional, defaults to &#39;any&#39;. Role in the relationship * any - Any role, default. * subject - DOI provided is the subject in the relationship. * object - DOI provided is the object in the relationship. (optional)
     * @param oper Relational operator code to filter the relations. Optional; if specified, only the relations with the given operator will be returned. Relational code * acfr - Acquired from. The PGRFA was received from a Provider. The related DOI identifies the Provider&#39;s sample * crfr - Created from. The PGRFA was obtained through crossing parent PGRFAs. The related DOIs identify the parent samples * defr - Derived from. The PGRFA was obtained from another sample. The related DOI identifies such original sample (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call listRelationshipsCall(String doi, String role, String oper, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/glisapi/v1/rels";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (doi != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("doi", doi));
        if (role != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("role", role));
        if (oper != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("oper", oper));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/xml"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "easySmta" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call listRelationshipsValidateBeforeCall(String doi, String role, String oper, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'doi' is set
        if (doi == null) {
            throw new ApiException("Missing the required parameter 'doi' when calling listRelationships(Async)");
        }
        

        com.squareup.okhttp.Call call = listRelationshipsCall(doi, role, oper, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get PGRFA relationships
     * Multiple status values can be provided with comma separated strings
     * @param doi Digital Object Identifier (DOI) associated to the PGRFA for which relations are requested. Mandatory (required)
     * @param role Role of doi in the relationships. Optional, defaults to &#39;any&#39;. Role in the relationship * any - Any role, default. * subject - DOI provided is the subject in the relationship. * object - DOI provided is the object in the relationship. (optional)
     * @param oper Relational operator code to filter the relations. Optional; if specified, only the relations with the given operator will be returned. Relational code * acfr - Acquired from. The PGRFA was received from a Provider. The related DOI identifies the Provider&#39;s sample * crfr - Created from. The PGRFA was obtained through crossing parent PGRFAs. The related DOIs identify the parent samples * defr - Derived from. The PGRFA was obtained from another sample. The related DOI identifies such original sample (optional)
     * @return List&lt;Relationship&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Relationship> listRelationships(String doi, String role, String oper) throws ApiException {
        ApiResponse<List<Relationship>> resp = listRelationshipsWithHttpInfo(doi, role, oper);
        return resp.getData();
    }

    /**
     * Get PGRFA relationships
     * Multiple status values can be provided with comma separated strings
     * @param doi Digital Object Identifier (DOI) associated to the PGRFA for which relations are requested. Mandatory (required)
     * @param role Role of doi in the relationships. Optional, defaults to &#39;any&#39;. Role in the relationship * any - Any role, default. * subject - DOI provided is the subject in the relationship. * object - DOI provided is the object in the relationship. (optional)
     * @param oper Relational operator code to filter the relations. Optional; if specified, only the relations with the given operator will be returned. Relational code * acfr - Acquired from. The PGRFA was received from a Provider. The related DOI identifies the Provider&#39;s sample * crfr - Created from. The PGRFA was obtained through crossing parent PGRFAs. The related DOIs identify the parent samples * defr - Derived from. The PGRFA was obtained from another sample. The related DOI identifies such original sample (optional)
     * @return ApiResponse&lt;List&lt;Relationship&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Relationship>> listRelationshipsWithHttpInfo(String doi, String role, String oper) throws ApiException {
        com.squareup.okhttp.Call call = listRelationshipsValidateBeforeCall(doi, role, oper, null, null);
        Type localVarReturnType = new TypeToken<List<Relationship>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get PGRFA relationships (asynchronously)
     * Multiple status values can be provided with comma separated strings
     * @param doi Digital Object Identifier (DOI) associated to the PGRFA for which relations are requested. Mandatory (required)
     * @param role Role of doi in the relationships. Optional, defaults to &#39;any&#39;. Role in the relationship * any - Any role, default. * subject - DOI provided is the subject in the relationship. * object - DOI provided is the object in the relationship. (optional)
     * @param oper Relational operator code to filter the relations. Optional; if specified, only the relations with the given operator will be returned. Relational code * acfr - Acquired from. The PGRFA was received from a Provider. The related DOI identifies the Provider&#39;s sample * crfr - Created from. The PGRFA was obtained through crossing parent PGRFAs. The related DOIs identify the parent samples * defr - Derived from. The PGRFA was obtained from another sample. The related DOI identifies such original sample (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call listRelationshipsAsync(String doi, String role, String oper, final ApiCallback<List<Relationship>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = listRelationshipsValidateBeforeCall(doi, role, oper, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Relationship>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for listTerms
     * @param acceptLanguage Tags to filter by (optional, default to en)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call listTermsCall(List<String> acceptLanguage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/glisapi/v1/terms";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null)
        localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/xml"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "easySmta" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call listTermsValidateBeforeCall(List<String> acceptLanguage, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = listTermsCall(acceptLanguage, progressListener, progressRequestListener);
        return call;

    }

    /**
     * GLIS vocabularies
     * To describe the kind of information that will be found in the targets, GLIS adopts a simple controlled vocabulary.
     * @param acceptLanguage Tags to filter by (optional, default to en)
     * @return List&lt;Term&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Term> listTerms(List<String> acceptLanguage) throws ApiException {
        ApiResponse<List<Term>> resp = listTermsWithHttpInfo(acceptLanguage);
        return resp.getData();
    }

    /**
     * GLIS vocabularies
     * To describe the kind of information that will be found in the targets, GLIS adopts a simple controlled vocabulary.
     * @param acceptLanguage Tags to filter by (optional, default to en)
     * @return ApiResponse&lt;List&lt;Term&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Term>> listTermsWithHttpInfo(List<String> acceptLanguage) throws ApiException {
        com.squareup.okhttp.Call call = listTermsValidateBeforeCall(acceptLanguage, null, null);
        Type localVarReturnType = new TypeToken<List<Term>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * GLIS vocabularies (asynchronously)
     * To describe the kind of information that will be found in the targets, GLIS adopts a simple controlled vocabulary.
     * @param acceptLanguage Tags to filter by (optional, default to en)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call listTermsAsync(List<String> acceptLanguage, final ApiCallback<List<Term>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = listTermsValidateBeforeCall(acceptLanguage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Term>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for search
     * @param page Request a particular page (optional, default to 1)
     * @param perPage The number of items returned in a single page (optional, default to 10)
     * @param acceptLanguage Tags to filter by (optional, default to en)
     * @param doi Digital Object Identifier (DOI) associated to the PGRFA (optional)
     * @param identifier Any identifier associated with the PGRFA, excluding the DOI (optional)
     * @param genus Genus of the PGRFA (optional)
     * @param species Species and other taxonomic elements (optional)
     * @param name Any name associated with the PGRFA (optional)
     * @param holdwiews FAO/WIEWS Institute code of the holding institution (optional)
     * @param holdpid Easy-SMTA PID of the holding institution or person (optional)
     * @param holdname Name and surname for persons or Organization name of the holding institution or person (optional)
     * @param holdcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the holding institution or person (optional)
     * @param methodcode Code of the method through which the PGRFA has been acquired. See Table 1 for the codes accepted by this element. TODO enum (optional)
     * @param provwiews FAO/WIEWS Institute code of the providing institution (optional)
     * @param provpid Easy-SMTA PID of the providing institution or person (optional)
     * @param provname Name and surname for persons or Organization name of the providing institution (optional)
     * @param provcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the providing institution or person (optional)
     * @param provenance ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the providing institution or person (optional)
     * @param collwiews FAO/WIEWS Institute code of the collecting institution (optional)
     * @param collpid Easy-SMTA PID of the collecting institution or person (optional)
     * @param collname Name and surname for persons or Organization name of the collecting institution or person (optional)
     * @param collcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the collecting institution or person (optional)
     * @param bredwiews FAO/WIEWS Institute code of the breeding institution (optional)
     * @param bredpid Easy-SMTA PID of the breeding institution or person (optional)
     * @param bredname Name and surname for persons or Organization name of the breeding institution or person (optional)
     * @param bredcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the breeding institution or person (optional)
     * @param biostatus Code of the biological status of sample (MCPD SAMPSTAT). (optional)
     * @param mlsstatus Code for the inclusion into the Multilateral System. (optional)
     * @param targetkw Code for the keyword for a target associated to the PGRFA. To obtain the list of keyword codes, please see \&quot;Controlled vocabulary query\&quot;. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call searchCall(Integer page, Integer perPage, List<String> acceptLanguage, String doi, String identifier, String genus, String species, String name, String holdwiews, String holdpid, String holdname, String holdcountry, String methodcode, String provwiews, String provpid, String provname, String provcountry, String provenance, String collwiews, String collpid, String collname, String collcountry, String bredwiews, String bredpid, String bredname, String bredcountry, String biostatus, String mlsstatus, String targetkw, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/glisapi/v1/pgrfas";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (perPage != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("per-page", perPage));
        if (doi != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("doi", doi));
        if (identifier != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("identifier", identifier));
        if (genus != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("genus", genus));
        if (species != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("species", species));
        if (name != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("name", name));
        if (holdwiews != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("holdwiews", holdwiews));
        if (holdpid != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("holdpid", holdpid));
        if (holdname != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("holdname", holdname));
        if (holdcountry != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("holdcountry", holdcountry));
        if (methodcode != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("methodcode", methodcode));
        if (provwiews != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("provwiews", provwiews));
        if (provpid != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("provpid", provpid));
        if (provname != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("provname", provname));
        if (provcountry != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("provcountry", provcountry));
        if (provenance != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("provenance", provenance));
        if (collwiews != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("collwiews", collwiews));
        if (collpid != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("collpid", collpid));
        if (collname != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("collname", collname));
        if (collcountry != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("collcountry", collcountry));
        if (bredwiews != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("bredwiews", bredwiews));
        if (bredpid != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("bredpid", bredpid));
        if (bredname != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("bredname", bredname));
        if (bredcountry != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("bredcountry", bredcountry));
        if (biostatus != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("biostatus", biostatus));
        if (mlsstatus != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("mlsstatus", mlsstatus));
        if (targetkw != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("targetkw", targetkw));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null)
        localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/xml", "application/brapi", "application/zip", "application/ld+json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "easySmta" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call searchValidateBeforeCall(Integer page, Integer perPage, List<String> acceptLanguage, String doi, String identifier, String genus, String species, String name, String holdwiews, String holdpid, String holdname, String holdcountry, String methodcode, String provwiews, String provpid, String provname, String provcountry, String provenance, String collwiews, String collpid, String collname, String collcountry, String bredwiews, String bredpid, String bredname, String bredcountry, String biostatus, String mlsstatus, String targetkw, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = searchCall(page, perPage, acceptLanguage, doi, identifier, genus, species, name, holdwiews, holdpid, holdname, holdcountry, methodcode, provwiews, provpid, provname, provcountry, provenance, collwiews, collpid, collname, collcountry, bredwiews, bredpid, bredname, bredcountry, biostatus, mlsstatus, targetkw, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Find passport data on PGRFA in GLIS
     * 
     * @param page Request a particular page (optional, default to 1)
     * @param perPage The number of items returned in a single page (optional, default to 10)
     * @param acceptLanguage Tags to filter by (optional, default to en)
     * @param doi Digital Object Identifier (DOI) associated to the PGRFA (optional)
     * @param identifier Any identifier associated with the PGRFA, excluding the DOI (optional)
     * @param genus Genus of the PGRFA (optional)
     * @param species Species and other taxonomic elements (optional)
     * @param name Any name associated with the PGRFA (optional)
     * @param holdwiews FAO/WIEWS Institute code of the holding institution (optional)
     * @param holdpid Easy-SMTA PID of the holding institution or person (optional)
     * @param holdname Name and surname for persons or Organization name of the holding institution or person (optional)
     * @param holdcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the holding institution or person (optional)
     * @param methodcode Code of the method through which the PGRFA has been acquired. See Table 1 for the codes accepted by this element. TODO enum (optional)
     * @param provwiews FAO/WIEWS Institute code of the providing institution (optional)
     * @param provpid Easy-SMTA PID of the providing institution or person (optional)
     * @param provname Name and surname for persons or Organization name of the providing institution (optional)
     * @param provcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the providing institution or person (optional)
     * @param provenance ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the providing institution or person (optional)
     * @param collwiews FAO/WIEWS Institute code of the collecting institution (optional)
     * @param collpid Easy-SMTA PID of the collecting institution or person (optional)
     * @param collname Name and surname for persons or Organization name of the collecting institution or person (optional)
     * @param collcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the collecting institution or person (optional)
     * @param bredwiews FAO/WIEWS Institute code of the breeding institution (optional)
     * @param bredpid Easy-SMTA PID of the breeding institution or person (optional)
     * @param bredname Name and surname for persons or Organization name of the breeding institution or person (optional)
     * @param bredcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the breeding institution or person (optional)
     * @param biostatus Code of the biological status of sample (MCPD SAMPSTAT). (optional)
     * @param mlsstatus Code for the inclusion into the Multilateral System. (optional)
     * @param targetkw Code for the keyword for a target associated to the PGRFA. To obtain the list of keyword codes, please see \&quot;Controlled vocabulary query\&quot;. (optional)
     * @return List&lt;PGRFA&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<PGRFA> search(Integer page, Integer perPage, List<String> acceptLanguage, String doi, String identifier, String genus, String species, String name, String holdwiews, String holdpid, String holdname, String holdcountry, String methodcode, String provwiews, String provpid, String provname, String provcountry, String provenance, String collwiews, String collpid, String collname, String collcountry, String bredwiews, String bredpid, String bredname, String bredcountry, String biostatus, String mlsstatus, String targetkw) throws ApiException {
        ApiResponse<List<PGRFA>> resp = searchWithHttpInfo(page, perPage, acceptLanguage, doi, identifier, genus, species, name, holdwiews, holdpid, holdname, holdcountry, methodcode, provwiews, provpid, provname, provcountry, provenance, collwiews, collpid, collname, collcountry, bredwiews, bredpid, bredname, bredcountry, biostatus, mlsstatus, targetkw);
        return resp.getData();
    }

    /**
     * Find passport data on PGRFA in GLIS
     * 
     * @param page Request a particular page (optional, default to 1)
     * @param perPage The number of items returned in a single page (optional, default to 10)
     * @param acceptLanguage Tags to filter by (optional, default to en)
     * @param doi Digital Object Identifier (DOI) associated to the PGRFA (optional)
     * @param identifier Any identifier associated with the PGRFA, excluding the DOI (optional)
     * @param genus Genus of the PGRFA (optional)
     * @param species Species and other taxonomic elements (optional)
     * @param name Any name associated with the PGRFA (optional)
     * @param holdwiews FAO/WIEWS Institute code of the holding institution (optional)
     * @param holdpid Easy-SMTA PID of the holding institution or person (optional)
     * @param holdname Name and surname for persons or Organization name of the holding institution or person (optional)
     * @param holdcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the holding institution or person (optional)
     * @param methodcode Code of the method through which the PGRFA has been acquired. See Table 1 for the codes accepted by this element. TODO enum (optional)
     * @param provwiews FAO/WIEWS Institute code of the providing institution (optional)
     * @param provpid Easy-SMTA PID of the providing institution or person (optional)
     * @param provname Name and surname for persons or Organization name of the providing institution (optional)
     * @param provcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the providing institution or person (optional)
     * @param provenance ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the providing institution or person (optional)
     * @param collwiews FAO/WIEWS Institute code of the collecting institution (optional)
     * @param collpid Easy-SMTA PID of the collecting institution or person (optional)
     * @param collname Name and surname for persons or Organization name of the collecting institution or person (optional)
     * @param collcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the collecting institution or person (optional)
     * @param bredwiews FAO/WIEWS Institute code of the breeding institution (optional)
     * @param bredpid Easy-SMTA PID of the breeding institution or person (optional)
     * @param bredname Name and surname for persons or Organization name of the breeding institution or person (optional)
     * @param bredcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the breeding institution or person (optional)
     * @param biostatus Code of the biological status of sample (MCPD SAMPSTAT). (optional)
     * @param mlsstatus Code for the inclusion into the Multilateral System. (optional)
     * @param targetkw Code for the keyword for a target associated to the PGRFA. To obtain the list of keyword codes, please see \&quot;Controlled vocabulary query\&quot;. (optional)
     * @return ApiResponse&lt;List&lt;PGRFA&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<PGRFA>> searchWithHttpInfo(Integer page, Integer perPage, List<String> acceptLanguage, String doi, String identifier, String genus, String species, String name, String holdwiews, String holdpid, String holdname, String holdcountry, String methodcode, String provwiews, String provpid, String provname, String provcountry, String provenance, String collwiews, String collpid, String collname, String collcountry, String bredwiews, String bredpid, String bredname, String bredcountry, String biostatus, String mlsstatus, String targetkw) throws ApiException {
        com.squareup.okhttp.Call call = searchValidateBeforeCall(page, perPage, acceptLanguage, doi, identifier, genus, species, name, holdwiews, holdpid, holdname, holdcountry, methodcode, provwiews, provpid, provname, provcountry, provenance, collwiews, collpid, collname, collcountry, bredwiews, bredpid, bredname, bredcountry, biostatus, mlsstatus, targetkw, null, null);
        Type localVarReturnType = new TypeToken<List<PGRFA>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Find passport data on PGRFA in GLIS (asynchronously)
     * 
     * @param page Request a particular page (optional, default to 1)
     * @param perPage The number of items returned in a single page (optional, default to 10)
     * @param acceptLanguage Tags to filter by (optional, default to en)
     * @param doi Digital Object Identifier (DOI) associated to the PGRFA (optional)
     * @param identifier Any identifier associated with the PGRFA, excluding the DOI (optional)
     * @param genus Genus of the PGRFA (optional)
     * @param species Species and other taxonomic elements (optional)
     * @param name Any name associated with the PGRFA (optional)
     * @param holdwiews FAO/WIEWS Institute code of the holding institution (optional)
     * @param holdpid Easy-SMTA PID of the holding institution or person (optional)
     * @param holdname Name and surname for persons or Organization name of the holding institution or person (optional)
     * @param holdcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the holding institution or person (optional)
     * @param methodcode Code of the method through which the PGRFA has been acquired. See Table 1 for the codes accepted by this element. TODO enum (optional)
     * @param provwiews FAO/WIEWS Institute code of the providing institution (optional)
     * @param provpid Easy-SMTA PID of the providing institution or person (optional)
     * @param provname Name and surname for persons or Organization name of the providing institution (optional)
     * @param provcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the providing institution or person (optional)
     * @param provenance ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the providing institution or person (optional)
     * @param collwiews FAO/WIEWS Institute code of the collecting institution (optional)
     * @param collpid Easy-SMTA PID of the collecting institution or person (optional)
     * @param collname Name and surname for persons or Organization name of the collecting institution or person (optional)
     * @param collcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the collecting institution or person (optional)
     * @param bredwiews FAO/WIEWS Institute code of the breeding institution (optional)
     * @param bredpid Easy-SMTA PID of the breeding institution or person (optional)
     * @param bredname Name and surname for persons or Organization name of the breeding institution or person (optional)
     * @param bredcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the breeding institution or person (optional)
     * @param biostatus Code of the biological status of sample (MCPD SAMPSTAT). (optional)
     * @param mlsstatus Code for the inclusion into the Multilateral System. (optional)
     * @param targetkw Code for the keyword for a target associated to the PGRFA. To obtain the list of keyword codes, please see \&quot;Controlled vocabulary query\&quot;. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call searchAsync(Integer page, Integer perPage, List<String> acceptLanguage, String doi, String identifier, String genus, String species, String name, String holdwiews, String holdpid, String holdname, String holdcountry, String methodcode, String provwiews, String provpid, String provname, String provcountry, String provenance, String collwiews, String collpid, String collname, String collcountry, String bredwiews, String bredpid, String bredname, String bredcountry, String biostatus, String mlsstatus, String targetkw, final ApiCallback<List<PGRFA>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = searchValidateBeforeCall(page, perPage, acceptLanguage, doi, identifier, genus, species, name, holdwiews, holdpid, holdname, holdcountry, methodcode, provwiews, provpid, provname, provcountry, provenance, collwiews, collpid, collname, collcountry, bredwiews, bredpid, bredname, bredcountry, biostatus, mlsstatus, targetkw, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<PGRFA>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
