/*
 * Global Information System API Client
 * Genesys API client to the Global Information System (GLIS) for PGRFA  [https://glis.planttreaty.org](https://glis.planttreaty.org).
 *
 * OpenAPI spec version: 1.1-SNAPSHOT
 * Contact: helpdesk@genesys-pgr.org
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.genesys.glis.v1.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.genesys.glis.v1.model.Collector;

/**
 * Collection
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-09-10T16:46:55.731Z")
public class Collection {
  @SerializedName("collectors")
  private List<Collector> collectors = null;

  @SerializedName("sampleid")
  private String sampleid = null;

  @SerializedName("missid")
  private String missid = null;

  @SerializedName("site")
  private String site = null;

  @SerializedName("lat")
  private String lat = null;

  @SerializedName("lon")
  private String lon = null;

  @SerializedName("uncert")
  private String uncert = null;

  @SerializedName("datum")
  private String datum = null;

  @SerializedName("georef")
  private String georef = null;

  @SerializedName("elevation")
  private Integer elevation = null;

  @SerializedName("date")
  private String date = null;

  @SerializedName("source")
  private String source = null;

  public Collection collectors(List<Collector> collectors) {
    this.collectors = collectors;
    return this;
  }

  public Collection addCollectorsItem(Collector collectorsItem) {
    if (this.collectors == null) {
      this.collectors = new ArrayList<>();
    }
    this.collectors.add(collectorsItem);
    return this;
  }

   /**
   * Get collectors
   * @return collectors
  **/
  @ApiModelProperty(value = "")
  public List<Collector> getCollectors() {
    return collectors;
  }

  public void setCollectors(List<Collector> collectors) {
    this.collectors = collectors;
  }

  public Collection sampleid(String sampleid) {
    this.sampleid = sampleid;
    return this;
  }

   /**
   * Get sampleid
   * @return sampleid
  **/
  @ApiModelProperty(value = "")
  public String getSampleid() {
    return sampleid;
  }

  public void setSampleid(String sampleid) {
    this.sampleid = sampleid;
  }

  public Collection missid(String missid) {
    this.missid = missid;
    return this;
  }

   /**
   * Get missid
   * @return missid
  **/
  @ApiModelProperty(value = "")
  public String getMissid() {
    return missid;
  }

  public void setMissid(String missid) {
    this.missid = missid;
  }

  public Collection site(String site) {
    this.site = site;
    return this;
  }

   /**
   * Get site
   * @return site
  **/
  @ApiModelProperty(value = "")
  public String getSite() {
    return site;
  }

  public void setSite(String site) {
    this.site = site;
  }

  public Collection lat(String lat) {
    this.lat = lat;
    return this;
  }

   /**
   * Get lat
   * @return lat
  **/
  @ApiModelProperty(value = "")
  public String getLat() {
    return lat;
  }

  public void setLat(String lat) {
    this.lat = lat;
  }

  public Collection lon(String lon) {
    this.lon = lon;
    return this;
  }

   /**
   * Get lon
   * @return lon
  **/
  @ApiModelProperty(value = "")
  public String getLon() {
    return lon;
  }

  public void setLon(String lon) {
    this.lon = lon;
  }

  public Collection uncert(String uncert) {
    this.uncert = uncert;
    return this;
  }

   /**
   * Get uncert
   * @return uncert
  **/
  @ApiModelProperty(value = "")
  public String getUncert() {
    return uncert;
  }

  public void setUncert(String uncert) {
    this.uncert = uncert;
  }

  public Collection datum(String datum) {
    this.datum = datum;
    return this;
  }

   /**
   * Get datum
   * @return datum
  **/
  @ApiModelProperty(value = "")
  public String getDatum() {
    return datum;
  }

  public void setDatum(String datum) {
    this.datum = datum;
  }

  public Collection georef(String georef) {
    this.georef = georef;
    return this;
  }

   /**
   * Get georef
   * @return georef
  **/
  @ApiModelProperty(value = "")
  public String getGeoref() {
    return georef;
  }

  public void setGeoref(String georef) {
    this.georef = georef;
  }

  public Collection elevation(Integer elevation) {
    this.elevation = elevation;
    return this;
  }

   /**
   * Elevation of collecting site in metres above sea level.
   * @return elevation
  **/
  @ApiModelProperty(value = "Elevation of collecting site in metres above sea level.")
  public Integer getElevation() {
    return elevation;
  }

  public void setElevation(Integer elevation) {
    this.elevation = elevation;
  }

  public Collection date(String date) {
    this.date = date;
    return this;
  }

   /**
   * Date on which the PGRFA was collected. Date fragments (YYYY-MM and YYYY) are also accepted.
   * @return date
  **/
  @ApiModelProperty(value = "Date on which the PGRFA was collected. Date fragments (YYYY-MM and YYYY) are also accepted.")
  public String getDate() {
    return date;
  }

  public void setDate(String date) {
    this.date = date;
  }

  public Collection source(String source) {
    this.source = source;
    return this;
  }

   /**
   * Code of the nature of the location where the PGRFA was collected.
   * @return source
  **/
  @ApiModelProperty(value = "Code of the nature of the location where the PGRFA was collected.")
  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Collection collection = (Collection) o;
    return Objects.equals(this.collectors, collection.collectors) &&
        Objects.equals(this.sampleid, collection.sampleid) &&
        Objects.equals(this.missid, collection.missid) &&
        Objects.equals(this.site, collection.site) &&
        Objects.equals(this.lat, collection.lat) &&
        Objects.equals(this.lon, collection.lon) &&
        Objects.equals(this.uncert, collection.uncert) &&
        Objects.equals(this.datum, collection.datum) &&
        Objects.equals(this.georef, collection.georef) &&
        Objects.equals(this.elevation, collection.elevation) &&
        Objects.equals(this.date, collection.date) &&
        Objects.equals(this.source, collection.source);
  }

  @Override
  public int hashCode() {
    return Objects.hash(collectors, sampleid, missid, site, lat, lon, uncert, datum, georef, elevation, date, source);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Collection {\n");
    
    sb.append("    collectors: ").append(toIndentedString(collectors)).append("\n");
    sb.append("    sampleid: ").append(toIndentedString(sampleid)).append("\n");
    sb.append("    missid: ").append(toIndentedString(missid)).append("\n");
    sb.append("    site: ").append(toIndentedString(site)).append("\n");
    sb.append("    lat: ").append(toIndentedString(lat)).append("\n");
    sb.append("    lon: ").append(toIndentedString(lon)).append("\n");
    sb.append("    uncert: ").append(toIndentedString(uncert)).append("\n");
    sb.append("    datum: ").append(toIndentedString(datum)).append("\n");
    sb.append("    georef: ").append(toIndentedString(georef)).append("\n");
    sb.append("    elevation: ").append(toIndentedString(elevation)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

