/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.glis.v1.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.genesys.glis.v1.invoker.ApiCallback;
import org.genesys.glis.v1.invoker.ApiClient;
import org.genesys.glis.v1.invoker.ApiException;
import org.genesys.glis.v1.invoker.ApiResponse;
import org.genesys.glis.v1.invoker.Configuration;
import org.genesys.glis.v1.invoker.Pair;
import org.genesys.glis.v1.invoker.ProgressRequestBody;
import org.genesys.glis.v1.invoker.ProgressResponseBody;
import org.genesys.glis.v1.model.DOIArray;
import org.genesys.glis.v1.model.DOIHolder;
import org.genesys.glis.v1.model.PGRFA;
import org.genesys.glis.v1.model.Relationship;
import org.genesys.glis.v1.model.Term;

public class QueryApi {
    private ApiClient apiClient;

    public QueryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public QueryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call listHoldersCall(DOIArray dois, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DOIArray localVarPostBody = dois;
        String localVarPath = "/glisapi/v1/holders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"easySmta"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listHoldersValidateBeforeCall(DOIArray dois, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.listHoldersCall(dois, progressListener, progressRequestListener);
        return call;
    }

    public List<DOIHolder> listHolders(DOIArray dois) throws ApiException {
        ApiResponse<List<DOIHolder>> resp = this.listHoldersWithHttpInfo(dois);
        return resp.getData();
    }

    public ApiResponse<List<DOIHolder>> listHoldersWithHttpInfo(DOIArray dois) throws ApiException {
        Call call = this.listHoldersValidateBeforeCall(dois, null, null);
        Type localVarReturnType = new TypeToken<List<DOIHolder>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listHoldersAsync(DOIArray dois, final ApiCallback<List<DOIHolder>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listHoldersValidateBeforeCall(dois, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<DOIHolder>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listRelationshipsCall(String doi, String role, String oper, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/glisapi/v1/rels";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (doi != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("doi", doi));
        }
        if (role != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("role", role));
        }
        if (oper != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("oper", oper));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"easySmta"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listRelationshipsValidateBeforeCall(String doi, String role, String oper, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (doi == null) {
            throw new ApiException("Missing the required parameter 'doi' when calling listRelationships(Async)");
        }
        Call call = this.listRelationshipsCall(doi, role, oper, progressListener, progressRequestListener);
        return call;
    }

    public List<Relationship> listRelationships(String doi, String role, String oper) throws ApiException {
        ApiResponse<List<Relationship>> resp = this.listRelationshipsWithHttpInfo(doi, role, oper);
        return resp.getData();
    }

    public ApiResponse<List<Relationship>> listRelationshipsWithHttpInfo(String doi, String role, String oper) throws ApiException {
        Call call = this.listRelationshipsValidateBeforeCall(doi, role, oper, null, null);
        Type localVarReturnType = new TypeToken<List<Relationship>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listRelationshipsAsync(String doi, String role, String oper, final ApiCallback<List<Relationship>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listRelationshipsValidateBeforeCall(doi, role, oper, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Relationship>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listTermsCall(List<String> acceptLanguage, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/glisapi/v1/terms";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.apiClient.parameterToString(acceptLanguage));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"easySmta"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listTermsValidateBeforeCall(List<String> acceptLanguage, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.listTermsCall(acceptLanguage, progressListener, progressRequestListener);
        return call;
    }

    public List<Term> listTerms(List<String> acceptLanguage) throws ApiException {
        ApiResponse<List<Term>> resp = this.listTermsWithHttpInfo(acceptLanguage);
        return resp.getData();
    }

    public ApiResponse<List<Term>> listTermsWithHttpInfo(List<String> acceptLanguage) throws ApiException {
        Call call = this.listTermsValidateBeforeCall(acceptLanguage, null, null);
        Type localVarReturnType = new TypeToken<List<Term>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listTermsAsync(List<String> acceptLanguage, final ApiCallback<List<Term>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listTermsValidateBeforeCall(acceptLanguage, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Term>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call searchCall(Integer page, Integer perPage, List<String> acceptLanguage, String doi, String identifier, String genus, String species, String name, String holdwiews, String holdpid, String holdname, String holdcountry, String methodcode, String provwiews, String provpid, String provname, String provcountry, String provenance, String collwiews, String collpid, String collname, String collcountry, String bredwiews, String bredpid, String bredname, String bredcountry, String biostatus, String mlsstatus, String targetkw, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/glisapi/v1/pgrfas";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("per-page", perPage));
        }
        if (doi != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("doi", doi));
        }
        if (identifier != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("identifier", identifier));
        }
        if (genus != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("genus", genus));
        }
        if (species != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("species", species));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        if (holdwiews != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("holdwiews", holdwiews));
        }
        if (holdpid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("holdpid", holdpid));
        }
        if (holdname != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("holdname", holdname));
        }
        if (holdcountry != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("holdcountry", holdcountry));
        }
        if (methodcode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("methodcode", methodcode));
        }
        if (provwiews != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("provwiews", provwiews));
        }
        if (provpid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("provpid", provpid));
        }
        if (provname != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("provname", provname));
        }
        if (provcountry != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("provcountry", provcountry));
        }
        if (provenance != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("provenance", provenance));
        }
        if (collwiews != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("collwiews", collwiews));
        }
        if (collpid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("collpid", collpid));
        }
        if (collname != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("collname", collname));
        }
        if (collcountry != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("collcountry", collcountry));
        }
        if (bredwiews != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("bredwiews", bredwiews));
        }
        if (bredpid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("bredpid", bredpid));
        }
        if (bredname != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("bredname", bredname));
        }
        if (bredcountry != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("bredcountry", bredcountry));
        }
        if (biostatus != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("biostatus", biostatus));
        }
        if (mlsstatus != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("mlsstatus", mlsstatus));
        }
        if (targetkw != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("targetkw", targetkw));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.apiClient.parameterToString(acceptLanguage));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "application/brapi", "application/zip", "application/ld+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"easySmta"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call searchValidateBeforeCall(Integer page, Integer perPage, List<String> acceptLanguage, String doi, String identifier, String genus, String species, String name, String holdwiews, String holdpid, String holdname, String holdcountry, String methodcode, String provwiews, String provpid, String provname, String provcountry, String provenance, String collwiews, String collpid, String collname, String collcountry, String bredwiews, String bredpid, String bredname, String bredcountry, String biostatus, String mlsstatus, String targetkw, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.searchCall(page, perPage, acceptLanguage, doi, identifier, genus, species, name, holdwiews, holdpid, holdname, holdcountry, methodcode, provwiews, provpid, provname, provcountry, provenance, collwiews, collpid, collname, collcountry, bredwiews, bredpid, bredname, bredcountry, biostatus, mlsstatus, targetkw, progressListener, progressRequestListener);
        return call;
    }

    public List<PGRFA> search(Integer page, Integer perPage, List<String> acceptLanguage, String doi, String identifier, String genus, String species, String name, String holdwiews, String holdpid, String holdname, String holdcountry, String methodcode, String provwiews, String provpid, String provname, String provcountry, String provenance, String collwiews, String collpid, String collname, String collcountry, String bredwiews, String bredpid, String bredname, String bredcountry, String biostatus, String mlsstatus, String targetkw) throws ApiException {
        ApiResponse<List<PGRFA>> resp = this.searchWithHttpInfo(page, perPage, acceptLanguage, doi, identifier, genus, species, name, holdwiews, holdpid, holdname, holdcountry, methodcode, provwiews, provpid, provname, provcountry, provenance, collwiews, collpid, collname, collcountry, bredwiews, bredpid, bredname, bredcountry, biostatus, mlsstatus, targetkw);
        return resp.getData();
    }

    public ApiResponse<List<PGRFA>> searchWithHttpInfo(Integer page, Integer perPage, List<String> acceptLanguage, String doi, String identifier, String genus, String species, String name, String holdwiews, String holdpid, String holdname, String holdcountry, String methodcode, String provwiews, String provpid, String provname, String provcountry, String provenance, String collwiews, String collpid, String collname, String collcountry, String bredwiews, String bredpid, String bredname, String bredcountry, String biostatus, String mlsstatus, String targetkw) throws ApiException {
        Call call = this.searchValidateBeforeCall(page, perPage, acceptLanguage, doi, identifier, genus, species, name, holdwiews, holdpid, holdname, holdcountry, methodcode, provwiews, provpid, provname, provcountry, provenance, collwiews, collpid, collname, collcountry, bredwiews, bredpid, bredname, bredcountry, biostatus, mlsstatus, targetkw, null, null);
        Type localVarReturnType = new TypeToken<List<PGRFA>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call searchAsync(Integer page, Integer perPage, List<String> acceptLanguage, String doi, String identifier, String genus, String species, String name, String holdwiews, String holdpid, String holdname, String holdcountry, String methodcode, String provwiews, String provpid, String provname, String provcountry, String provenance, String collwiews, String collpid, String collname, String collcountry, String bredwiews, String bredpid, String bredname, String bredcountry, String biostatus, String mlsstatus, String targetkw, final ApiCallback<List<PGRFA>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.searchValidateBeforeCall(page, perPage, acceptLanguage, doi, identifier, genus, species, name, holdwiews, holdpid, holdname, holdcountry, methodcode, provwiews, provpid, provname, provcountry, provenance, collwiews, collpid, collname, collcountry, bredwiews, bredpid, bredname, bredcountry, biostatus, mlsstatus, targetkw, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<PGRFA>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

