package org.genesys.glis.v1.api;

import org.genesys.glis.v1.invoker.ApiClient;

import org.genesys.glis.v1.model.UpdateTargets;
import org.genesys.glis.v1.model.UpdatedTarget;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-10-26T22:59:27.549Z")
@Component("org.genesys.glis.v1.api.GenesysApi")
public class GenesysApi {
    private ApiClient apiClient;

    public GenesysApi() {
        this(new ApiClient());
    }

    @Autowired
    public GenesysApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Add Genesys as target URL to specified DOIs
     * We&#39;ll have fun!
     * <p><b>200</b> - Successful operation
     * @param targets Registers Genesys as a target URL for specified DOIs
     * @return List&lt;UpdatedTarget&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<UpdatedTarget> registerGenesysAsTarget(UpdateTargets targets) throws RestClientException {
        Object postBody = targets;
        
        String path = UriComponentsBuilder.fromPath("/glis/genesys/addtarget").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "easySmta" };

        ParameterizedTypeReference<List<UpdatedTarget>> returnType = new ParameterizedTypeReference<List<UpdatedTarget>>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
}
