/*
 * Global Information System API Client
 * Genesys API client to the Global Information System (GLIS) for PGRFA  [https://glis.planttreaty.org](https://glis.planttreaty.org).
 *
 * OpenAPI spec version: 1.0
 * Contact: helpdesk@genesys-pgr.org
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.genesys.glis.v1.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

/**
 * The website where additional information on the PGRFA can be found.
 */
@ApiModel(description = "The website where additional information on the PGRFA can be found.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-10-26T22:59:27.549Z")
public class Target {
  @JsonProperty("url")
  private String url = null;

  @JsonProperty("kws")
  private List<String> kws = null;

  public Target url(String url) {
    this.url = url;
    return this;
  }

   /**
   * URL to PGRFA information
   * @return url
  **/
  @ApiModelProperty(value = "URL to PGRFA information")
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public Target kws(List<String> kws) {
    this.kws = kws;
    return this;
  }

  public Target addKwsItem(String kwsItem) {
    if (this.kws == null) {
      this.kws = new ArrayList<>();
    }
    this.kws.add(kwsItem);
    return this;
  }

   /**
   * Keywords?
   * @return kws
  **/
  @ApiModelProperty(value = "Keywords?")
  public List<String> getKws() {
    return kws;
  }

  public void setKws(List<String> kws) {
    this.kws = kws;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Target target = (Target) o;
    return Objects.equals(this.url, target.url) &&
        Objects.equals(this.kws, target.kws);
  }

  @Override
  public int hashCode() {
    return Objects.hash(url, kws);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Target {\n");
    
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    kws: ").append(toIndentedString(kws)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

