/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.glis.v1.api;

import java.util.List;
import org.genesys.glis.v1.invoker.ApiClient;
import org.genesys.glis.v1.model.DOIArray;
import org.genesys.glis.v1.model.DOIHolder;
import org.genesys.glis.v1.model.PGRFA;
import org.genesys.glis.v1.model.Relationship;
import org.genesys.glis.v1.model.Term;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="org.genesys.glis.v1.api.QueryApi")
public class QueryApi {
    private ApiClient apiClient;

    public QueryApi() {
        this(new ApiClient());
    }

    @Autowired
    public QueryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public List<DOIHolder> listHolders(DOIArray dois) throws RestClientException {
        DOIArray postBody = dois;
        String path = UriComponentsBuilder.fromPath((String)"/glisapi/v1/holders").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"easySmta"};
        ParameterizedTypeReference<List<DOIHolder>> returnType = new ParameterizedTypeReference<List<DOIHolder>>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public List<Relationship> listRelationships(String doi, String role, String oper) throws RestClientException {
        Object postBody = null;
        if (doi == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'doi' when calling listRelationships");
        }
        String path = UriComponentsBuilder.fromPath((String)"/glisapi/v1/rels").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "doi", doi));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "role", role));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "oper", oper));
        String[] accepts = new String[]{"application/json", "application/xml"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"easySmta"};
        ParameterizedTypeReference<List<Relationship>> returnType = new ParameterizedTypeReference<List<Relationship>>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public List<Term> listTerms(List<String> acceptLanguage) throws RestClientException {
        Object postBody = null;
        String path = UriComponentsBuilder.fromPath((String)"/glisapi/v1/terms").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (acceptLanguage != null) {
            headerParams.add("Accept-Language", this.apiClient.parameterToString(acceptLanguage));
        }
        String[] accepts = new String[]{"application/json", "application/xml"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"easySmta"};
        ParameterizedTypeReference<List<Term>> returnType = new ParameterizedTypeReference<List<Term>>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public List<PGRFA> search(Integer page, Integer perPage, List<String> acceptLanguage, String doi, String identifier, String genus, String species, String name, String holdwiews, String holdpid, String holdname, String holdcountry, String methodcode, String provwiews, String provpid, String provname, String provcountry, String provenance, String collwiews, String collpid, String collname, String collcountry, String bredwiews, String bredpid, String bredname, String bredcountry, String biostatus, String mlsstatus, String targetkw) throws RestClientException {
        Object postBody = null;
        String path = UriComponentsBuilder.fromPath((String)"/glisapi/v1/pgrfas").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "per-page", perPage));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "doi", doi));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "identifier", identifier));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "genus", genus));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "species", species));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "name", name));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "holdwiews", holdwiews));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "holdpid", holdpid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "holdname", holdname));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "holdcountry", holdcountry));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "methodcode", methodcode));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "provwiews", provwiews));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "provpid", provpid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "provname", provname));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "provcountry", provcountry));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "provenance", provenance));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "collwiews", collwiews));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "collpid", collpid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "collname", collname));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "collcountry", collcountry));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bredwiews", bredwiews));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bredpid", bredpid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bredname", bredname));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bredcountry", bredcountry));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "biostatus", biostatus));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "mlsstatus", mlsstatus));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "targetkw", targetkw));
        if (acceptLanguage != null) {
            headerParams.add("Accept-Language", this.apiClient.parameterToString(acceptLanguage));
        }
        String[] accepts = new String[]{"application/json", "application/xml", "application/brapi", "application/zip", "application/ld+json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"easySmta"};
        ParameterizedTypeReference<List<PGRFA>> returnType = new ParameterizedTypeReference<List<PGRFA>>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }
}

