package org.genesys.glis.v1.api;

import org.genesys.glis.v1.invoker.ApiClient;

import org.genesys.glis.v1.model.DOIArray;
import org.genesys.glis.v1.model.DOIHolder;
import org.genesys.glis.v1.model.PGRFA;
import org.genesys.glis.v1.model.RateLimitError;
import org.genesys.glis.v1.model.Relationship;
import org.genesys.glis.v1.model.Term;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-09-10T16:57:15.984Z")
@Component("org.genesys.glis.v1.api.QueryApi")
public class QueryApi {
    private ApiClient apiClient;

    public QueryApi() {
        this(new ApiClient());
    }

    @Autowired
    public QueryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Query for holder of PGRFA by DOIs
     * Query GLIS for WIEWS code of the holder for each submitted DOI. At this time, the call has a limit of 1,000 DOIs.
     * <p><b>200</b> - successful operation
     * @param dois The dois parameter
     * @return List&lt;DOIHolder&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<DOIHolder> listHolders(DOIArray dois) throws RestClientException {
        Object postBody = dois;
        
        String path = UriComponentsBuilder.fromPath("/glisapi/v1/holders").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] accepts = { 
            "application/json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "easySmta" };

        ParameterizedTypeReference<List<DOIHolder>> returnType = new ParameterizedTypeReference<List<DOIHolder>>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Get PGRFA relationships
     * Multiple status values can be provided with comma separated strings
     * <p><b>200</b> - successful operation
     * <p><b>400</b> - Invalid status value
     * @param doi Digital Object Identifier (DOI) associated to the PGRFA for which relations are requested. Mandatory
     * @param role Role of doi in the relationships. Optional, defaults to &#39;any&#39;. Role in the relationship * any - Any role, default. * subject - DOI provided is the subject in the relationship. * object - DOI provided is the object in the relationship.
     * @param oper Relational operator code to filter the relations. Optional; if specified, only the relations with the given operator will be returned. Relational code * acfr - Acquired from. The PGRFA was received from a Provider. The related DOI identifies the Provider&#39;s sample * crfr - Created from. The PGRFA was obtained through crossing parent PGRFAs. The related DOIs identify the parent samples * defr - Derived from. The PGRFA was obtained from another sample. The related DOI identifies such original sample
     * @return List&lt;Relationship&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<Relationship> listRelationships(String doi, String role, String oper) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'doi' is set
        if (doi == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'doi' when calling listRelationships");
        }
        
        String path = UriComponentsBuilder.fromPath("/glisapi/v1/rels").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "doi", doi));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "role", role));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "oper", oper));

        final String[] accepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "easySmta" };

        ParameterizedTypeReference<List<Relationship>> returnType = new ParameterizedTypeReference<List<Relationship>>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * GLIS vocabularies
     * To describe the kind of information that will be found in the targets, GLIS adopts a simple controlled vocabulary.
     * <p><b>200</b> - successful operation
     * @param acceptLanguage Tags to filter by
     * @return List&lt;Term&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<Term> listTerms(List<String> acceptLanguage) throws RestClientException {
        Object postBody = null;
        
        String path = UriComponentsBuilder.fromPath("/glisapi/v1/terms").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        if (acceptLanguage != null)
        headerParams.add("Accept-Language", apiClient.parameterToString(acceptLanguage));

        final String[] accepts = { 
            "application/json", "application/xml"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "easySmta" };

        ParameterizedTypeReference<List<Term>> returnType = new ParameterizedTypeReference<List<Term>>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * Find passport data on PGRFA in GLIS
     * 
     * <p><b>200</b> - Successful operation
     * <p><b>404</b> - PGRFA not found
     * <p><b>429</b> - Too Many Requests
     * @param page Request a particular page
     * @param perPage The number of items returned in a single page
     * @param acceptLanguage Tags to filter by
     * @param doi Digital Object Identifier (DOI) associated to the PGRFA
     * @param identifier Any identifier associated with the PGRFA, excluding the DOI
     * @param genus Genus of the PGRFA
     * @param species Species and other taxonomic elements
     * @param name Any name associated with the PGRFA
     * @param holdwiews FAO/WIEWS Institute code of the holding institution
     * @param holdpid Easy-SMTA PID of the holding institution or person
     * @param holdname Name and surname for persons or Organization name of the holding institution or person
     * @param holdcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the holding institution or person
     * @param methodcode Code of the method through which the PGRFA has been acquired. See Table 1 for the codes accepted by this element. TODO enum
     * @param provwiews FAO/WIEWS Institute code of the providing institution
     * @param provpid Easy-SMTA PID of the providing institution or person
     * @param provname Name and surname for persons or Organization name of the providing institution
     * @param provcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the providing institution or person
     * @param provenance ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the providing institution or person
     * @param collwiews FAO/WIEWS Institute code of the collecting institution
     * @param collpid Easy-SMTA PID of the collecting institution or person
     * @param collname Name and surname for persons or Organization name of the collecting institution or person
     * @param collcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the collecting institution or person
     * @param bredwiews FAO/WIEWS Institute code of the breeding institution
     * @param bredpid Easy-SMTA PID of the breeding institution or person
     * @param bredname Name and surname for persons or Organization name of the breeding institution or person
     * @param bredcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the breeding institution or person
     * @param biostatus Code of the biological status of sample (MCPD SAMPSTAT).
     * @param mlsstatus Code for the inclusion into the Multilateral System.
     * @param targetkw Code for the keyword for a target associated to the PGRFA. To obtain the list of keyword codes, please see \&quot;Controlled vocabulary query\&quot;.
     * @return List&lt;PGRFA&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<PGRFA> search(Integer page, Integer perPage, List<String> acceptLanguage, String doi, String identifier, String genus, String species, String name, String holdwiews, String holdpid, String holdname, String holdcountry, String methodcode, String provwiews, String provpid, String provname, String provcountry, String provenance, String collwiews, String collpid, String collname, String collcountry, String bredwiews, String bredpid, String bredname, String bredcountry, String biostatus, String mlsstatus, String targetkw) throws RestClientException {
        Object postBody = null;
        
        String path = UriComponentsBuilder.fromPath("/glisapi/v1/pgrfas").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "per-page", perPage));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "doi", doi));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "identifier", identifier));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "genus", genus));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "species", species));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "name", name));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "holdwiews", holdwiews));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "holdpid", holdpid));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "holdname", holdname));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "holdcountry", holdcountry));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "methodcode", methodcode));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "provwiews", provwiews));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "provpid", provpid));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "provname", provname));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "provcountry", provcountry));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "provenance", provenance));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "collwiews", collwiews));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "collpid", collpid));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "collname", collname));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "collcountry", collcountry));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "bredwiews", bredwiews));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "bredpid", bredpid));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "bredname", bredname));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "bredcountry", bredcountry));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "biostatus", biostatus));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "mlsstatus", mlsstatus));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "targetkw", targetkw));
        
        if (acceptLanguage != null)
        headerParams.add("Accept-Language", apiClient.parameterToString(acceptLanguage));

        final String[] accepts = { 
            "application/json", "application/xml", "application/brapi", "application/zip", "application/ld+json"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "easySmta" };

        ParameterizedTypeReference<List<PGRFA>> returnType = new ParameterizedTypeReference<List<PGRFA>>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
}
