/*
 * Global Information System API Client
 * Genesys API client to the Global Information System (GLIS) for PGRFA  [https://glis.planttreaty.org](https://glis.planttreaty.org).
 *
 * OpenAPI spec version: 1.1-SNAPSHOT
 * Contact: helpdesk@genesys-pgr.org
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.genesys.glis.v1.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.genesys.glis.v1.model.Acquisition;
import org.genesys.glis.v1.model.BasePGRFA;
import org.genesys.glis.v1.model.Breeding;
import org.genesys.glis.v1.model.Collection;
import org.genesys.glis.v1.model.Location;
import org.genesys.glis.v1.model.Target;

/**
 * Registration
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-09-10T16:57:15.984Z")
public class Registration {
  @JsonProperty("username")
  private String username = null;

  @JsonProperty("password")
  private String password = null;

  @JsonProperty("location")
  private Location location = null;

  @JsonProperty("sampledoi")
  private String sampledoi = null;

  @JsonProperty("sampleid")
  private String sampleid = null;

  @JsonProperty("date")
  private String date = null;

  @JsonProperty("method")
  private String method = null;

  @JsonProperty("genus")
  private String genus = null;

  @JsonProperty("cropnames")
  private List<String> cropnames = null;

  @JsonProperty("targets")
  private List<Target> targets = null;

  @JsonProperty("progdoi")
  private List<String> progdoi = null;

  @JsonProperty("biostatus")
  private Integer biostatus = null;

  @JsonProperty("species")
  private String species = null;

  @JsonProperty("spauth")
  private String spauth = null;

  @JsonProperty("subtaxa")
  private String subtaxa = null;

  @JsonProperty("stauth")
  private String stauth = null;

  @JsonProperty("names")
  private List<String> names = null;

  @JsonProperty("ids")
  private List<String> ids = null;

  @JsonProperty("mlsstatus")
  private Integer mlsstatus = null;

  @JsonProperty("historical")
  private String historical = null;

  @JsonProperty("acquisition")
  private Acquisition acquisition = null;

  @JsonProperty("collection")
  private Collection collection = null;

  @JsonProperty("breeding")
  private Breeding breeding = null;

  public Registration username(String username) {
    this.username = username;
    return this;
  }

   /**
   * Get username
   * @return username
  **/
  @ApiModelProperty(example = "cgn", value = "")
  public String getUsername() {
    return username;
  }

  public void setUsername(String username) {
    this.username = username;
  }

  public Registration password(String password) {
    this.password = password;
    return this;
  }

   /**
   * Get password
   * @return password
  **/
  @ApiModelProperty(example = "Passw0rd", value = "")
  public String getPassword() {
    return password;
  }

  public void setPassword(String password) {
    this.password = password;
  }

  public Registration location(Location location) {
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @ApiModelProperty(value = "")
  public Location getLocation() {
    return location;
  }

  public void setLocation(Location location) {
    this.location = location;
  }

  public Registration sampledoi(String sampledoi) {
    this.sampledoi = sampledoi;
    return this;
  }

   /**
   * A Digital Object Identifier (DOI) obtained from a service other than GLIS and that is already assigned to the PGRFA.
   * @return sampledoi
  **/
  @ApiModelProperty(value = "A Digital Object Identifier (DOI) obtained from a service other than GLIS and that is already assigned to the PGRFA.")
  public String getSampledoi() {
    return sampledoi;
  }

  public void setSampledoi(String sampledoi) {
    this.sampledoi = sampledoi;
  }

  public Registration sampleid(String sampleid) {
    this.sampleid = sampleid;
    return this;
  }

   /**
   * A string that identifies the PGRFA that is being registered. This value will be returned by GLIS in the response message and is assumed to be used to associate the DOI to the corresponding material in the local database. You must provide &lt;sampleid&gt; even if &lt;sampledoi&gt; is provided. In case you use the DOI as unique identifier in your local database, you can repeat it in &lt;sampleid&gt;. Mandatory. Please read more details in the “HTTPS reply” chapter.
   * @return sampleid
  **/
  @ApiModelProperty(example = "CGN00001", value = "A string that identifies the PGRFA that is being registered. This value will be returned by GLIS in the response message and is assumed to be used to associate the DOI to the corresponding material in the local database. You must provide <sampleid> even if <sampledoi> is provided. In case you use the DOI as unique identifier in your local database, you can repeat it in <sampleid>. Mandatory. Please read more details in the “HTTPS reply” chapter.")
  public String getSampleid() {
    return sampleid;
  }

  public void setSampleid(String sampleid) {
    this.sampleid = sampleid;
  }

  public Registration date(String date) {
    this.date = date;
    return this;
  }

   /**
   * Date in which PGRFA became part of the collection. Date fragments (YYYY-MM and YYYY) are also accepted.
   * @return date
  **/
  @ApiModelProperty(example = "1987-06-23", value = "Date in which PGRFA became part of the collection. Date fragments (YYYY-MM and YYYY) are also accepted.")
  public String getDate() {
    return date;
  }

  public void setDate(String date) {
    this.date = date;
  }

  public Registration method(String method) {
    this.method = method;
    return this;
  }

   /**
   * Method through which the PGRFA has been acquired. Mandatory.
   * @return method
  **/
  @ApiModelProperty(example = "acqu", value = "Method through which the PGRFA has been acquired. Mandatory.")
  public String getMethod() {
    return method;
  }

  public void setMethod(String method) {
    this.method = method;
  }

  public Registration genus(String genus) {
    this.genus = genus;
    return this;
  }

   /**
   * The taxon of the genus for the PGRFA. At least one between &lt;genus&gt; and &lt;cropname&gt; must be provided.
   * @return genus
  **/
  @ApiModelProperty(example = "Hordeum", value = "The taxon of the genus for the PGRFA. At least one between <genus> and <cropname> must be provided.")
  public String getGenus() {
    return genus;
  }

  public void setGenus(String genus) {
    this.genus = genus;
  }

  public Registration cropnames(List<String> cropnames) {
    this.cropnames = cropnames;
    return this;
  }

  public Registration addCropnamesItem(String cropnamesItem) {
    if (this.cropnames == null) {
      this.cropnames = new ArrayList<>();
    }
    this.cropnames.add(cropnamesItem);
    return this;
  }

   /**
   * Common name of the crop. At least one between &lt;genus&gt; and one cropname must be provided. Multiple names are allowed.
   * @return cropnames
  **/
  @ApiModelProperty(example = "[\"Barley\",\"Wheat\"]", value = "Common name of the crop. At least one between <genus> and one cropname must be provided. Multiple names are allowed.")
  public List<String> getCropnames() {
    return cropnames;
  }

  public void setCropnames(List<String> cropnames) {
    this.cropnames = cropnames;
  }

  public Registration targets(List<Target> targets) {
    this.targets = targets;
    return this;
  }

  public Registration addTargetsItem(Target targetsItem) {
    if (this.targets == null) {
      this.targets = new ArrayList<>();
    }
    this.targets.add(targetsItem);
    return this;
  }

   /**
   * Get targets
   * @return targets
  **/
  @ApiModelProperty(value = "")
  public List<Target> getTargets() {
    return targets;
  }

  public void setTargets(List<Target> targets) {
    this.targets = targets;
  }

  public Registration progdoi(List<String> progdoi) {
    this.progdoi = progdoi;
    return this;
  }

  public Registration addProgdoiItem(String progdoiItem) {
    if (this.progdoi == null) {
      this.progdoi = new ArrayList<>();
    }
    this.progdoi.add(progdoiItem);
    return this;
  }

   /**
   * DOI of the progenitor PGRFA as registered in GLIS. Please note that the number of allowed DOIs depends on the method as follows   * Acquisition - 1 DOI  * In-house copy - 1 DOI  * In-house variant - 1 DOI  * Novel distinct PGRFA - 1 or more DOIs  * Observation - Natural - 0 DOI  * Observation – Inherited - 0 DOI
   * @return progdoi
  **/
  @ApiModelProperty(example = "[\"10.0155/11\",\"10.0155/12\"]", value = "DOI of the progenitor PGRFA as registered in GLIS. Please note that the number of allowed DOIs depends on the method as follows   * Acquisition - 1 DOI  * In-house copy - 1 DOI  * In-house variant - 1 DOI  * Novel distinct PGRFA - 1 or more DOIs  * Observation - Natural - 0 DOI  * Observation – Inherited - 0 DOI")
  public List<String> getProgdoi() {
    return progdoi;
  }

  public void setProgdoi(List<String> progdoi) {
    this.progdoi = progdoi;
  }

  public Registration biostatus(Integer biostatus) {
    this.biostatus = biostatus;
    return this;
  }

   /**
   * Biological status of the PGRFA.
   * @return biostatus
  **/
  @ApiModelProperty(example = "300", value = "Biological status of the PGRFA.")
  public Integer getBiostatus() {
    return biostatus;
  }

  public void setBiostatus(Integer biostatus) {
    this.biostatus = biostatus;
  }

  public Registration species(String species) {
    this.species = species;
    return this;
  }

   /**
   * Specific epithet of the PGRFA scientific name. If not provided, \&quot;sp.\&quot; is assumed.
   * @return species
  **/
  @ApiModelProperty(example = "vulgare", value = "Specific epithet of the PGRFA scientific name. If not provided, \"sp.\" is assumed.")
  public String getSpecies() {
    return species;
  }

  public void setSpecies(String species) {
    this.species = species;
  }

  public Registration spauth(String spauth) {
    this.spauth = spauth;
    return this;
  }

   /**
   * Authority for the specific epithet.
   * @return spauth
  **/
  @ApiModelProperty(example = "L.", value = "Authority for the specific epithet.")
  public String getSpauth() {
    return spauth;
  }

  public void setSpauth(String spauth) {
    this.spauth = spauth;
  }

  public Registration subtaxa(String subtaxa) {
    this.subtaxa = subtaxa;
    return this;
  }

   /**
   * Any additional infra-specific taxon such as subspecies, variety, form, Group and so on.
   * @return subtaxa
  **/
  @ApiModelProperty(example = "subsp. vulgare", value = "Any additional infra-specific taxon such as subspecies, variety, form, Group and so on.")
  public String getSubtaxa() {
    return subtaxa;
  }

  public void setSubtaxa(String subtaxa) {
    this.subtaxa = subtaxa;
  }

  public Registration stauth(String stauth) {
    this.stauth = stauth;
    return this;
  }

   /**
   * Authority for the subtaxon at the most detailed level provided.
   * @return stauth
  **/
  @ApiModelProperty(example = "L.", value = "Authority for the subtaxon at the most detailed level provided.")
  public String getStauth() {
    return stauth;
  }

  public void setStauth(String stauth) {
    this.stauth = stauth;
  }

  public Registration names(List<String> names) {
    this.names = names;
    return this;
  }

  public Registration addNamesItem(String namesItem) {
    if (this.names == null) {
      this.names = new ArrayList<>();
    }
    this.names.add(namesItem);
    return this;
  }

   /**
   * Other name of the PGRFA. Any number of names can be provided.
   * @return names
  **/
  @ApiModelProperty(example = "[\"a\",\"b\"]", value = "Other name of the PGRFA. Any number of names can be provided.")
  public List<String> getNames() {
    return names;
  }

  public void setNames(List<String> names) {
    this.names = names;
  }

  public Registration ids(List<String> ids) {
    this.ids = ids;
    return this;
  }

  public Registration addIdsItem(String idsItem) {
    if (this.ids == null) {
      this.ids = new ArrayList<>();
    }
    this.ids.add(idsItem);
    return this;
  }

   /**
   * Get ids
   * @return ids
  **/
  @ApiModelProperty(example = "[\"a\",\"b\"]", value = "")
  public List<String> getIds() {
    return ids;
  }

  public void setIds(List<String> ids) {
    this.ids = ids;
  }

  public Registration mlsstatus(Integer mlsstatus) {
    this.mlsstatus = mlsstatus;
    return this;
  }

   /**
   * Code that identifies the status of the PGRFA with regard to the MLS.
   * @return mlsstatus
  **/
  @ApiModelProperty(example = "1", value = "Code that identifies the status of the PGRFA with regard to the MLS.")
  public Integer getMlsstatus() {
    return mlsstatus;
  }

  public void setMlsstatus(Integer mlsstatus) {
    this.mlsstatus = mlsstatus;
  }

  public Registration historical(String historical) {
    this.historical = historical;
    return this;
  }

   /**
   * Indicates whether the PGRFA currently exists. Allowed value is y/n
   * @return historical
  **/
  @ApiModelProperty(example = "n", value = "Indicates whether the PGRFA currently exists. Allowed value is y/n")
  public String getHistorical() {
    return historical;
  }

  public void setHistorical(String historical) {
    this.historical = historical;
  }

  public Registration acquisition(Acquisition acquisition) {
    this.acquisition = acquisition;
    return this;
  }

   /**
   * Get acquisition
   * @return acquisition
  **/
  @ApiModelProperty(value = "")
  public Acquisition getAcquisition() {
    return acquisition;
  }

  public void setAcquisition(Acquisition acquisition) {
    this.acquisition = acquisition;
  }

  public Registration collection(Collection collection) {
    this.collection = collection;
    return this;
  }

   /**
   * Get collection
   * @return collection
  **/
  @ApiModelProperty(value = "")
  public Collection getCollection() {
    return collection;
  }

  public void setCollection(Collection collection) {
    this.collection = collection;
  }

  public Registration breeding(Breeding breeding) {
    this.breeding = breeding;
    return this;
  }

   /**
   * Get breeding
   * @return breeding
  **/
  @ApiModelProperty(value = "")
  public Breeding getBreeding() {
    return breeding;
  }

  public void setBreeding(Breeding breeding) {
    this.breeding = breeding;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Registration registration = (Registration) o;
    return Objects.equals(this.username, registration.username) &&
        Objects.equals(this.password, registration.password) &&
        Objects.equals(this.location, registration.location) &&
        Objects.equals(this.sampledoi, registration.sampledoi) &&
        Objects.equals(this.sampleid, registration.sampleid) &&
        Objects.equals(this.date, registration.date) &&
        Objects.equals(this.method, registration.method) &&
        Objects.equals(this.genus, registration.genus) &&
        Objects.equals(this.cropnames, registration.cropnames) &&
        Objects.equals(this.targets, registration.targets) &&
        Objects.equals(this.progdoi, registration.progdoi) &&
        Objects.equals(this.biostatus, registration.biostatus) &&
        Objects.equals(this.species, registration.species) &&
        Objects.equals(this.spauth, registration.spauth) &&
        Objects.equals(this.subtaxa, registration.subtaxa) &&
        Objects.equals(this.stauth, registration.stauth) &&
        Objects.equals(this.names, registration.names) &&
        Objects.equals(this.ids, registration.ids) &&
        Objects.equals(this.mlsstatus, registration.mlsstatus) &&
        Objects.equals(this.historical, registration.historical) &&
        Objects.equals(this.acquisition, registration.acquisition) &&
        Objects.equals(this.collection, registration.collection) &&
        Objects.equals(this.breeding, registration.breeding);
  }

  @Override
  public int hashCode() {
    return Objects.hash(username, password, location, sampledoi, sampleid, date, method, genus, cropnames, targets, progdoi, biostatus, species, spauth, subtaxa, stauth, names, ids, mlsstatus, historical, acquisition, collection, breeding);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Registration {\n");
    
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    sampledoi: ").append(toIndentedString(sampledoi)).append("\n");
    sb.append("    sampleid: ").append(toIndentedString(sampleid)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    method: ").append(toIndentedString(method)).append("\n");
    sb.append("    genus: ").append(toIndentedString(genus)).append("\n");
    sb.append("    cropnames: ").append(toIndentedString(cropnames)).append("\n");
    sb.append("    targets: ").append(toIndentedString(targets)).append("\n");
    sb.append("    progdoi: ").append(toIndentedString(progdoi)).append("\n");
    sb.append("    biostatus: ").append(toIndentedString(biostatus)).append("\n");
    sb.append("    species: ").append(toIndentedString(species)).append("\n");
    sb.append("    spauth: ").append(toIndentedString(spauth)).append("\n");
    sb.append("    subtaxa: ").append(toIndentedString(subtaxa)).append("\n");
    sb.append("    stauth: ").append(toIndentedString(stauth)).append("\n");
    sb.append("    names: ").append(toIndentedString(names)).append("\n");
    sb.append("    ids: ").append(toIndentedString(ids)).append("\n");
    sb.append("    mlsstatus: ").append(toIndentedString(mlsstatus)).append("\n");
    sb.append("    historical: ").append(toIndentedString(historical)).append("\n");
    sb.append("    acquisition: ").append(toIndentedString(acquisition)).append("\n");
    sb.append("    collection: ").append(toIndentedString(collection)).append("\n");
    sb.append("    breeding: ").append(toIndentedString(breeding)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

