/*
 * Global Information System API Client
 * Genesys API client to the Global Information System (GLIS) for PGRFA  [https://glis.planttreaty.org](https://glis.planttreaty.org).
 *
 * OpenAPI spec version: 1.1-SNAPSHOT
 * Contact: helpdesk@genesys-pgr.org
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.genesys.glis.v1.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

/**
 * RegistrationResponse
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-09-10T16:57:15.984Z")
public class RegistrationResponse {
  @JsonProperty("sampleid")
  private String sampleid = null;

  @JsonProperty("genus")
  private String genus = null;

  @JsonProperty("doi")
  private String doi = null;

  @JsonProperty("error")
  private List<String> error = null;

  public RegistrationResponse sampleid(String sampleid) {
    this.sampleid = sampleid;
    return this;
  }

   /**
   * The local sample identifier sent in the request.
   * @return sampleid
  **/
  @ApiModelProperty(example = "CGN00001", required = true, value = "The local sample identifier sent in the request.")
  public String getSampleid() {
    return sampleid;
  }

  public void setSampleid(String sampleid) {
    this.sampleid = sampleid;
  }

  public RegistrationResponse genus(String genus) {
    this.genus = genus;
    return this;
  }

   /**
   * Genus of the PGRFA.
   * @return genus
  **/
  @ApiModelProperty(example = "Hordeum", value = "Genus of the PGRFA.")
  public String getGenus() {
    return genus;
  }

  public void setGenus(String genus) {
    this.genus = genus;
  }

  public RegistrationResponse doi(String doi) {
    this.doi = doi;
    return this;
  }

   /**
   * The DOI associated with the PGRFA upon registration.
   * @return doi
  **/
  @ApiModelProperty(example = "", value = "The DOI associated with the PGRFA upon registration.")
  public String getDoi() {
    return doi;
  }

  public void setDoi(String doi) {
    this.doi = doi;
  }

  public RegistrationResponse error(List<String> error) {
    this.error = error;
    return this;
  }

  public RegistrationResponse addErrorItem(String errorItem) {
    if (this.error == null) {
      this.error = new ArrayList<>();
    }
    this.error.add(errorItem);
    return this;
  }

   /**
   * Get error
   * @return error
  **/
  @ApiModelProperty(value = "")
  public List<String> getError() {
    return error;
  }

  public void setError(List<String> error) {
    this.error = error;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RegistrationResponse registrationResponse = (RegistrationResponse) o;
    return Objects.equals(this.sampleid, registrationResponse.sampleid) &&
        Objects.equals(this.genus, registrationResponse.genus) &&
        Objects.equals(this.doi, registrationResponse.doi) &&
        Objects.equals(this.error, registrationResponse.error);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sampleid, genus, doi, error);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RegistrationResponse {\n");
    
    sb.append("    sampleid: ").append(toIndentedString(sampleid)).append("\n");
    sb.append("    genus: ").append(toIndentedString(genus)).append("\n");
    sb.append("    doi: ").append(toIndentedString(doi)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

