package org.genesys.glis.v1.api;

import org.genesys.glis.v1.invoker.ApiClient;
import org.genesys.glis.v1.model.PGRFARegistration;
import org.genesys.glis.v1.model.PGRFARegistrationResponse;
import org.genesys.glis.v1.model.PGRFAUpdate;
import org.genesys.glis.v1.model.SMTAReportResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

import java.util.Collections;
import java.util.List;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
@Component("org.genesys.glis.v1.api.ManagerApi")
public class ManagerApi {
    private ApiClient apiClient;

    public ManagerApi() {
        this(new ApiClient());
    }

    @Autowired
    public ManagerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Register PGRFA in GLIS and (potentially) obtain GLIS-minted DOI
     * The purpose of this transaction is to obtain a DOI associated to the PGRFA by providing a set of descriptors in the registration request. However, if a DOI obtained through a service other than GLIS is already associated to the PGRFA, it must be provided in the request so that GLIS will not assign a new DOI but just adopt the one provided.
     * <p><b>200</b> - Successful operation
     * <p><b>400</b> - XML input invalid
     * <p><b>403</b> - Authentication failure
     * @param pgrfa Register PGRFA in GLIS and obtain GLIS DOI. (required)
     * @return PGRFARegistrationResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public PGRFARegistrationResponse registerPGRFA(PGRFARegistration pgrfa) throws RestClientException {
        return registerPGRFAWithHttpInfo(pgrfa).getBody();
    }

    /**
     * Register PGRFA in GLIS and (potentially) obtain GLIS-minted DOI
     * The purpose of this transaction is to obtain a DOI associated to the PGRFA by providing a set of descriptors in the registration request. However, if a DOI obtained through a service other than GLIS is already associated to the PGRFA, it must be provided in the request so that GLIS will not assign a new DOI but just adopt the one provided.
     * <p><b>200</b> - Successful operation
     * <p><b>400</b> - XML input invalid
     * <p><b>403</b> - Authentication failure
     * @param pgrfa Register PGRFA in GLIS and obtain GLIS DOI. (required)
     * @return ResponseEntity&lt;PGRFARegistrationResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<PGRFARegistrationResponse> registerPGRFAWithHttpInfo(PGRFARegistration pgrfa) throws RestClientException {
        Object localVarPostBody = pgrfa;
        
        // verify the required parameter 'pgrfa' is set
        if (pgrfa == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pgrfa' when calling registerPGRFA");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/xml", "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/xml"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "easySmta" };

        ParameterizedTypeReference<PGRFARegistrationResponse> localReturnType = new ParameterizedTypeReference<PGRFARegistrationResponse>() {};
        return apiClient.invokeAPI("/glis/xml/register", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Update PGRFA in GLIS
     * Update information on PGRFA already registered in GLIS.
     * <p><b>200</b> - Successful operation
     * @param pgrfa Update PGRFA in GLIS by DOI. (required)
     * @return PGRFARegistrationResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public PGRFARegistrationResponse updatePGRFA(PGRFAUpdate pgrfa) throws RestClientException {
        return updatePGRFAWithHttpInfo(pgrfa).getBody();
    }

    /**
     * Update PGRFA in GLIS
     * Update information on PGRFA already registered in GLIS.
     * <p><b>200</b> - Successful operation
     * @param pgrfa Update PGRFA in GLIS by DOI. (required)
     * @return ResponseEntity&lt;PGRFARegistrationResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<PGRFARegistrationResponse> updatePGRFAWithHttpInfo(PGRFAUpdate pgrfa) throws RestClientException {
        Object localVarPostBody = pgrfa;
        
        // verify the required parameter 'pgrfa' is set
        if (pgrfa == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pgrfa' when calling updatePGRFA");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/xml"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/xml"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "easySmta" };

        ParameterizedTypeReference<PGRFARegistrationResponse> localReturnType = new ParameterizedTypeReference<PGRFARegistrationResponse>() {};
        return apiClient.invokeAPI("/glis/xml/update", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Upload report
     * The purpose of this transaction is to report SMTAs to the Secretariat of the International Treaty on Plant Genetic Resources for Food and Agriculture (ITPGRFA) to fulfill their reporting obligations as set forth by the SMTA.
     * <p><b>200</b> - Successful operation
     * <p><b>400</b> - XML input invalid
     * <p><b>403</b> - Authentication failure
     * @param r  (required)
     * @param username  (required)
     * @param password  (required)
     * @param xml  (required)
     * @param compressed  (optional)
     * @return SMTAReportResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public SMTAReportResponse uploadReport(String r, String username, String password, byte[] xml, String compressed) throws RestClientException {
        return uploadReportWithHttpInfo(r, username, password, xml, compressed).getBody();
    }

    /**
     * Upload report
     * The purpose of this transaction is to report SMTAs to the Secretariat of the International Treaty on Plant Genetic Resources for Food and Agriculture (ITPGRFA) to fulfill their reporting obligations as set forth by the SMTA.
     * <p><b>200</b> - Successful operation
     * <p><b>400</b> - XML input invalid
     * <p><b>403</b> - Authentication failure
     * @param r  (required)
     * @param username  (required)
     * @param password  (required)
     * @param xml  (required)
     * @param compressed  (optional)
     * @return ResponseEntity&lt;SMTAReportResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<SMTAReportResponse> uploadReportWithHttpInfo(String r, String username, String password, byte[] xml, String compressed) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'r' is set
        if (r == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'r' when calling uploadReport");
        }
        
        // verify the required parameter 'username' is set
        if (username == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'username' when calling uploadReport");
        }
        
        // verify the required parameter 'password' is set
        if (password == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'password' when calling uploadReport");
        }
        
        // verify the required parameter 'xml' is set
        if (xml == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xml' when calling uploadReport");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "r", r));

        if (username != null)
            localVarFormParams.add("username", username);
        if (password != null)
            localVarFormParams.add("password", password);
        if (compressed != null)
            localVarFormParams.add("compressed", compressed);
        if (xml != null)
            localVarFormParams.add("xml", xml);

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "easySmta" };

        ParameterizedTypeReference<SMTAReportResponse> localReturnType = new ParameterizedTypeReference<SMTAReportResponse>() {};
        return apiClient.invokeAPI("/itt/index.php", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}
