/*
 * Global Information System API Client
 * Genesys API client to the Global Information System (GLIS) for PGRFA  [https://glis.planttreaty.org](https://glis.planttreaty.org).
 *
 * The version of the OpenAPI document: 1.1-SNAPSHOT
 * Contact: helpdesk@genesys-pgr.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.genesys.glis.v1.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Objects;

/**
 * The PGRFA DOI and the WIEWS code of its holder.
 */
@ApiModel(description = "The PGRFA DOI and the WIEWS code of its holder.")
@JsonPropertyOrder({
  DOIHolder.JSON_PROPERTY_DOI,
  DOIHolder.JSON_PROPERTY_HOLDWIEWS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
@XmlRootElement(name = "DOIHolder")
@XmlAccessorType(XmlAccessType.FIELD)
@JacksonXmlRootElement(localName = "DOIHolder")
public class DOIHolder {
  public static final String JSON_PROPERTY_DOI = "doi";
  @XmlElement(name = "doi")
  private String doi;

  public static final String JSON_PROPERTY_HOLDWIEWS = "holdwiews";
  @XmlElement(name = "holdwiews")
  private String holdwiews;

  public DOIHolder() { 
  }

  public DOIHolder doi(String doi) {
    
    this.doi = doi;
    return this;
  }

   /**
   * Get doi
   * @return doi
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10.18730/583E", value = "")
  @JsonProperty(JSON_PROPERTY_DOI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "doi")

  public String getDoi() {
    return doi;
  }


  @JsonProperty(JSON_PROPERTY_DOI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "doi")
  public void setDoi(String doi) {
    this.doi = doi;
  }


  public DOIHolder holdwiews(String holdwiews) {
    
    this.holdwiews = holdwiews;
    return this;
  }

   /**
   * Get holdwiews
   * @return holdwiews
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "PER001", value = "")
  @JsonProperty(JSON_PROPERTY_HOLDWIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "holdwiews")

  public String getHoldwiews() {
    return holdwiews;
  }


  @JsonProperty(JSON_PROPERTY_HOLDWIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "holdwiews")
  public void setHoldwiews(String holdwiews) {
    this.holdwiews = holdwiews;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DOIHolder doIHolder = (DOIHolder) o;
    return Objects.equals(this.doi, doIHolder.doi) &&
        Objects.equals(this.holdwiews, doIHolder.holdwiews);
  }

  @Override
  public int hashCode() {
    return Objects.hash(doi, holdwiews);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DOIHolder {\n");
    sb.append("    doi: ").append(toIndentedString(doi)).append("\n");
    sb.append("    holdwiews: ").append(toIndentedString(holdwiews)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

