/*
 * Global Information System API Client
 * Genesys API client to the Global Information System (GLIS) for PGRFA  [https://glis.planttreaty.org](https://glis.planttreaty.org).
 *
 * The version of the OpenAPI document: 1.1-SNAPSHOT
 * Contact: helpdesk@genesys-pgr.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.genesys.glis.v1.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.swagger.annotations.ApiModelProperty;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Objects;

/**
 * PGRFARegistrationResponse
 */
@JsonPropertyOrder({
  PGRFARegistrationResponse.JSON_PROPERTY_SAMPLEID,
  PGRFARegistrationResponse.JSON_PROPERTY_GENUS,
  PGRFARegistrationResponse.JSON_PROPERTY_DOI,
  PGRFARegistrationResponse.JSON_PROPERTY_ERROR
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
@XmlRootElement(name = "response")
@XmlAccessorType(XmlAccessType.FIELD)
@JacksonXmlRootElement(localName = "response")
public class PGRFARegistrationResponse {
  public static final String JSON_PROPERTY_SAMPLEID = "sampleid";
  @XmlElement(name = "sampleid")
  private String sampleid;

  public static final String JSON_PROPERTY_GENUS = "genus";
  @XmlElement(name = "genus")
  private String genus;

  public static final String JSON_PROPERTY_DOI = "doi";
  @XmlElement(name = "doi")
  private String doi;

  public static final String JSON_PROPERTY_ERROR = "error";
  @XmlElement(name = "error")
  private String error;

  public PGRFARegistrationResponse() { 
  }

  public PGRFARegistrationResponse sampleid(String sampleid) {
    
    this.sampleid = sampleid;
    return this;
  }

   /**
   * The local sample identifier sent in the request.
   * @return sampleid
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "CGN00001", required = true, value = "The local sample identifier sent in the request.")
  @JsonProperty(JSON_PROPERTY_SAMPLEID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  @JacksonXmlProperty(localName = "sampleid")

  public String getSampleid() {
    return sampleid;
  }


  @JsonProperty(JSON_PROPERTY_SAMPLEID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  @JacksonXmlProperty(localName = "sampleid")
  public void setSampleid(String sampleid) {
    this.sampleid = sampleid;
  }


  public PGRFARegistrationResponse genus(String genus) {
    
    this.genus = genus;
    return this;
  }

   /**
   * Genus of the PGRFA.
   * @return genus
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Hordeum", value = "Genus of the PGRFA.")
  @JsonProperty(JSON_PROPERTY_GENUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "genus")

  public String getGenus() {
    return genus;
  }


  @JsonProperty(JSON_PROPERTY_GENUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "genus")
  public void setGenus(String genus) {
    this.genus = genus;
  }


  public PGRFARegistrationResponse doi(String doi) {
    
    this.doi = doi;
    return this;
  }

   /**
   * The DOI associated with the PGRFA upon registration.
   * @return doi
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "", value = "The DOI associated with the PGRFA upon registration.")
  @JsonProperty(JSON_PROPERTY_DOI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "doi")

  public String getDoi() {
    return doi;
  }


  @JsonProperty(JSON_PROPERTY_DOI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "doi")
  public void setDoi(String doi) {
    this.doi = doi;
  }


  public PGRFARegistrationResponse error(String error) {
    
    this.error = error;
    return this;
  }

   /**
   * Get error
   * @return error
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ERROR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "error")

  public String getError() {
    return error;
  }


  @JsonProperty(JSON_PROPERTY_ERROR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "error")
  public void setError(String error) {
    this.error = error;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PGRFARegistrationResponse pgRFARegistrationResponse = (PGRFARegistrationResponse) o;
    return Objects.equals(this.sampleid, pgRFARegistrationResponse.sampleid) &&
        Objects.equals(this.genus, pgRFARegistrationResponse.genus) &&
        Objects.equals(this.doi, pgRFARegistrationResponse.doi) &&
        Objects.equals(this.error, pgRFARegistrationResponse.error);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sampleid, genus, doi, error);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PGRFARegistrationResponse {\n");
    sb.append("    sampleid: ").append(toIndentedString(sampleid)).append("\n");
    sb.append("    genus: ").append(toIndentedString(genus)).append("\n");
    sb.append("    doi: ").append(toIndentedString(doi)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

