/*
 * Global Information System API Client
 * Genesys API client to the Global Information System (GLIS) for PGRFA  [https://glis.planttreaty.org](https://glis.planttreaty.org).
 *
 * The version of the OpenAPI document: 1.1-SNAPSHOT
 * Contact: helpdesk@genesys-pgr.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.genesys.glis.v1.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.swagger.annotations.ApiModelProperty;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Objects;

/**
 * SMTAMaterial
 */
@JsonPropertyOrder({
  SMTAMaterial.JSON_PROPERTY_CROP,
  SMTAMaterial.JSON_PROPERTY_SAMPLE_I_D,
  SMTAMaterial.JSON_PROPERTY_PUD,
  SMTAMaterial.JSON_PROPERTY_ANCESTRY
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
@XmlRootElement(name = "material")
@XmlAccessorType(XmlAccessType.FIELD)
@JacksonXmlRootElement(localName = "material")
public class SMTAMaterial {
  public static final String JSON_PROPERTY_CROP = "crop";
  @XmlElement(name = "crop")
  private String crop;

  public static final String JSON_PROPERTY_SAMPLE_I_D = "sampleID";
  @XmlElement(name = "sampleID")
  private String sampleID;

  public static final String JSON_PROPERTY_PUD = "pud";
  @XmlElement(name = "pud")
  private SMTAMaterialUnderDevelopment pud;

  public static final String JSON_PROPERTY_ANCESTRY = "ancestry";
  @XmlElement(name = "ancestry")
  private String ancestry;

  public SMTAMaterial() { 
  }

  public SMTAMaterial crop(String crop) {
    
    this.crop = crop;
    return this;
  }

   /**
   * Crop code as per table in General notes below.
   * @return crop
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Crop code as per table in General notes below.")
  @JsonProperty(JSON_PROPERTY_CROP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "crop")

  public String getCrop() {
    return crop;
  }


  @JsonProperty(JSON_PROPERTY_CROP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "crop")
  public void setCrop(String crop) {
    this.crop = crop;
  }


  public SMTAMaterial sampleID(String sampleID) {
    
    this.sampleID = sampleID;
    return this;
  }

   /**
   * Sample ID, must be unique within the same SMTA. If available, please make sure to use the DOI assigned to the material using the prefix \&quot;doi:\&quot;. For example \&quot;doi:10.18730/34ER6\&quot;. Do not put any space.
   * @return sampleID
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Sample ID, must be unique within the same SMTA. If available, please make sure to use the DOI assigned to the material using the prefix \"doi:\". For example \"doi:10.18730/34ER6\". Do not put any space.")
  @JsonProperty(JSON_PROPERTY_SAMPLE_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "sampleID")

  public String getSampleID() {
    return sampleID;
  }


  @JsonProperty(JSON_PROPERTY_SAMPLE_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "sampleID")
  public void setSampleID(String sampleID) {
    this.sampleID = sampleID;
  }


  public SMTAMaterial pud(SMTAMaterialUnderDevelopment pud) {
    
    this.pud = pud;
    return this;
  }

   /**
   * Get pud
   * @return pud
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PUD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "pud")

  public SMTAMaterialUnderDevelopment getPud() {
    return pud;
  }


  @JsonProperty(JSON_PROPERTY_PUD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "pud")
  public void setPud(SMTAMaterialUnderDevelopment pud) {
    this.pud = pud;
  }


  public SMTAMaterial ancestry(String ancestry) {
    
    this.ancestry = ancestry;
    return this;
  }

   /**
   * Ancestry information as crop: sampleID1,sampleID2... where crop is the crop English name. Required only if PUD&#x3D;y.
   * @return ancestry
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Ancestry information as crop: sampleID1,sampleID2... where crop is the crop English name. Required only if PUD=y.")
  @JsonProperty(JSON_PROPERTY_ANCESTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "ancestry")

  public String getAncestry() {
    return ancestry;
  }


  @JsonProperty(JSON_PROPERTY_ANCESTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "ancestry")
  public void setAncestry(String ancestry) {
    this.ancestry = ancestry;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SMTAMaterial smTAMaterial = (SMTAMaterial) o;
    return Objects.equals(this.crop, smTAMaterial.crop) &&
        Objects.equals(this.sampleID, smTAMaterial.sampleID) &&
        Objects.equals(this.pud, smTAMaterial.pud) &&
        Objects.equals(this.ancestry, smTAMaterial.ancestry);
  }

  @Override
  public int hashCode() {
    return Objects.hash(crop, sampleID, pud, ancestry);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SMTAMaterial {\n");
    sb.append("    crop: ").append(toIndentedString(crop)).append("\n");
    sb.append("    sampleID: ").append(toIndentedString(sampleID)).append("\n");
    sb.append("    pud: ").append(toIndentedString(pud)).append("\n");
    sb.append("    ancestry: ").append(toIndentedString(ancestry)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

