/*
 * Global Information System API Client
 * Genesys API client to the Global Information System (GLIS) for PGRFA  [https://glis.planttreaty.org](https://glis.planttreaty.org).
 *
 * The version of the OpenAPI document: 1.1-SNAPSHOT
 * Contact: helpdesk@genesys-pgr.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.genesys.glis.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.swagger.annotations.ApiModelProperty;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import java.util.Objects;

/**
 * Term
 */
@JsonPropertyOrder({
  Term.JSON_PROPERTY_CODE,
  Term.JSON_PROPERTY_LANGUAGE,
  Term.JSON_PROPERTY_TERM
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
@XmlRootElement(name = "Term")
@XmlAccessorType(XmlAccessType.FIELD)
@JacksonXmlRootElement(localName = "Term")
public class Term {
  public static final String JSON_PROPERTY_CODE = "code";
  @XmlElement(name = "code")
  private String code;

  /**
   * ISO-639-1 two-letter language code
   */
  @XmlType(name="LanguageEnum")
  @XmlEnum(String.class)
  public enum LanguageEnum {
    @XmlEnumValue("en")
    EN("en"),
    
    @XmlEnumValue("fr")
    FR("fr"),
    
    @XmlEnumValue("es")
    ES("es"),
    
    @XmlEnumValue("ar")
    AR("ar"),
    
    @XmlEnumValue("ru")
    RU("ru"),
    
    @XmlEnumValue("zh")
    ZH("zh");

    private String value;

    LanguageEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LanguageEnum fromValue(String value) {
      for (LanguageEnum b : LanguageEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  @XmlElement(name = "language")
  private LanguageEnum language;

  public static final String JSON_PROPERTY_TERM = "term";
  @XmlElement(name = "term")
  private String term;

  public Term() { 
  }

  public Term code(String code) {
    
    this.code = code;
    return this;
  }

   /**
   * Unique term code
   * @return code
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Unique term code")
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  @JacksonXmlProperty(localName = "code")

  public String getCode() {
    return code;
  }


  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  @JacksonXmlProperty(localName = "code")
  public void setCode(String code) {
    this.code = code;
  }


  public Term language(LanguageEnum language) {
    
    this.language = language;
    return this;
  }

   /**
   * ISO-639-1 two-letter language code
   * @return language
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "ISO-639-1 two-letter language code")
  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  @JacksonXmlProperty(localName = "language")

  public LanguageEnum getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  @JacksonXmlProperty(localName = "language")
  public void setLanguage(LanguageEnum language) {
    this.language = language;
  }


  public Term term(String term) {
    
    this.term = term;
    return this;
  }

   /**
   * Term
   * @return term
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Term")
  @JsonProperty(JSON_PROPERTY_TERM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  @JacksonXmlProperty(localName = "term")

  public String getTerm() {
    return term;
  }


  @JsonProperty(JSON_PROPERTY_TERM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  @JacksonXmlProperty(localName = "term")
  public void setTerm(String term) {
    this.term = term;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Term term = (Term) o;
    return Objects.equals(this.code, term.code) &&
        Objects.equals(this.language, term.language) &&
        Objects.equals(this.term, term.term);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, language, term);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Term {\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    term: ").append(toIndentedString(term)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

