/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.glis.v1.api;

import java.util.Collections;
import java.util.List;
import org.genesys.glis.v1.invoker.ApiClient;
import org.genesys.glis.v1.model.DOIArray;
import org.genesys.glis.v1.model.DOIHolder;
import org.genesys.glis.v1.model.PGRFA;
import org.genesys.glis.v1.model.Relationship;
import org.genesys.glis.v1.model.Term;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="org.genesys.glis.v1.api.QueryApi")
public class QueryApi {
    private ApiClient apiClient;

    public QueryApi() {
        this(new ApiClient());
    }

    @Autowired
    public QueryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public List<DOIHolder> listHolders(DOIArray dois) throws RestClientException {
        return (List)this.listHoldersWithHttpInfo(dois).getBody();
    }

    public ResponseEntity<List<DOIHolder>> listHoldersWithHttpInfo(DOIArray dois) throws RestClientException {
        DOIArray localVarPostBody = dois;
        if (dois == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'dois' when calling listHolders");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application-json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"easySmta"};
        ParameterizedTypeReference<List<DOIHolder>> localReturnType = new ParameterizedTypeReference<List<DOIHolder>>(){};
        return this.apiClient.invokeAPI("/glisapi/v1/holders", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public List<Relationship> listRelationships(String doi, String role, String oper) throws RestClientException {
        return (List)this.listRelationshipsWithHttpInfo(doi, role, oper).getBody();
    }

    public ResponseEntity<List<Relationship>> listRelationshipsWithHttpInfo(String doi, String role, String oper) throws RestClientException {
        Object localVarPostBody = null;
        if (doi == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'doi' when calling listRelationships");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "doi", doi));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "role", role));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "oper", oper));
        String[] localVarAccepts = new String[]{"*/*", "application-json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"easySmta"};
        ParameterizedTypeReference<List<Relationship>> localReturnType = new ParameterizedTypeReference<List<Relationship>>(){};
        return this.apiClient.invokeAPI("/glisapi/v1/rels", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public List<Term> listTerms(List<String> acceptLanguage) throws RestClientException {
        return (List)this.listTermsWithHttpInfo(acceptLanguage).getBody();
    }

    public ResponseEntity<List<Term>> listTermsWithHttpInfo(List<String> acceptLanguage) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (acceptLanguage != null) {
            localVarHeaderParams.add("Accept-Language", this.apiClient.parameterToString(acceptLanguage));
        }
        String[] localVarAccepts = new String[]{"*/*", "application-json", "application-xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"easySmta"};
        ParameterizedTypeReference<List<Term>> localReturnType = new ParameterizedTypeReference<List<Term>>(){};
        return this.apiClient.invokeAPI("/glisapi/v1/terms", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public List<PGRFA> search(Integer page, Integer perPage, List<String> acceptLanguage, String doi, String identifier, String genus, String species, String name, String holdwiews, String holdpid, String holdname, String holdcountry, String methodcode, String provwiews, String provpid, String provname, String provcountry, String provenance, String collwiews, String collpid, String collname, String collcountry, String bredwiews, String bredpid, String bredname, String bredcountry, String biostatus, String mlsstatus, String targetkw) throws RestClientException {
        return (List)this.searchWithHttpInfo(page, perPage, acceptLanguage, doi, identifier, genus, species, name, holdwiews, holdpid, holdname, holdcountry, methodcode, provwiews, provpid, provname, provcountry, provenance, collwiews, collpid, collname, collcountry, bredwiews, bredpid, bredname, bredcountry, biostatus, mlsstatus, targetkw).getBody();
    }

    public ResponseEntity<List<PGRFA>> searchWithHttpInfo(Integer page, Integer perPage, List<String> acceptLanguage, String doi, String identifier, String genus, String species, String name, String holdwiews, String holdpid, String holdname, String holdcountry, String methodcode, String provwiews, String provpid, String provname, String provcountry, String provenance, String collwiews, String collpid, String collname, String collcountry, String bredwiews, String bredpid, String bredname, String bredcountry, String biostatus, String mlsstatus, String targetkw) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "per-page", perPage));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "doi", doi));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "identifier", identifier));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "genus", genus));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "species", species));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "name", name));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "holdwiews", holdwiews));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "holdpid", holdpid));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "holdname", holdname));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "holdcountry", holdcountry));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "methodcode", methodcode));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "provwiews", provwiews));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "provpid", provpid));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "provname", provname));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "provcountry", provcountry));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "provenance", provenance));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "collwiews", collwiews));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "collpid", collpid));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "collname", collname));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "collcountry", collcountry));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bredwiews", bredwiews));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bredpid", bredpid));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bredname", bredname));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bredcountry", bredcountry));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "biostatus", biostatus));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "mlsstatus", mlsstatus));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "targetkw", targetkw));
        if (acceptLanguage != null) {
            localVarHeaderParams.add("Accept-Language", this.apiClient.parameterToString(acceptLanguage));
        }
        String[] localVarAccepts = new String[]{"*/*", "application-json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"easySmta"};
        ParameterizedTypeReference<List<PGRFA>> localReturnType = new ParameterizedTypeReference<List<PGRFA>>(){};
        return this.apiClient.invokeAPI("/glisapi/v1/pgrfas", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}

