/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.glis.v1.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiModel(description="The location element is the same as the actor element with the addition of geographical coordinates: latitude and longitude.")
@JsonPropertyOrder(value={"wiews", "pid", "name", "address", "country"})
@XmlRootElement(name="Location")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="Location")
public class Location {
    public static final String JSON_PROPERTY_WIEWS = "wiews";
    @XmlElement(name="wiews")
    private String wiews;
    public static final String JSON_PROPERTY_PID = "pid";
    @XmlElement(name="pid")
    private String pid;
    public static final String JSON_PROPERTY_NAME = "name";
    @XmlElement(name="name")
    private String name;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    @XmlElement(name="address")
    private String address;
    public static final String JSON_PROPERTY_COUNTRY = "country";
    @XmlElement(name="country")
    private String country;

    public Location wiews(String wiews) {
        this.wiews = wiews;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="NLD037", value="FAO/WIEWS Institute code")
    @JsonProperty(value="wiews")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="wiews")
    public String getWiews() {
        return this.wiews;
    }

    @JsonProperty(value="wiews")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="wiews")
    public void setWiews(String wiews) {
        this.wiews = wiews;
    }

    public Location pid(String pid) {
        this.pid = pid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1337", value="Easy-SMTA PID")
    @JsonProperty(value="pid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="pid")
    public String getPid() {
        return this.pid;
    }

    @JsonProperty(value="pid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="pid")
    public void setPid(String pid) {
        this.pid = pid;
    }

    public Location name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Centre for Genetic Resources, Wageningen University and Research Centre", value="Name")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="name")
    public void setName(String name) {
        this.name = name;
    }

    public Location address(String address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="6700 AA Wageningen, The Netherlands", value="Address")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="address")
    public String getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="address")
    public void setAddress(String address) {
        this.address = address;
    }

    public Location country(String country) {
        this.country = country;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="NLD", value="ISO-3166 apha-3 country code")
    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="country")
    public String getCountry() {
        return this.country;
    }

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="country")
    public void setCountry(String country) {
        this.country = country;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        return Objects.equals(this.wiews, location.wiews) && Objects.equals(this.pid, location.pid) && Objects.equals(this.name, location.name) && Objects.equals(this.address, location.address) && Objects.equals(this.country, location.country);
    }

    public int hashCode() {
        return Objects.hash(this.wiews, this.pid, this.name, this.address, this.country);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Location {\n");
        sb.append("    wiews: ").append(this.toIndentedString(this.wiews)).append("\n");
        sb.append("    pid: ").append(this.toIndentedString(this.pid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

