/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.glis.v1.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.genesys.glis.v1.model.SMTAMaterialUnderDevelopment;

@JsonPropertyOrder(value={"crop", "sampleID", "pud", "ancestry"})
@XmlRootElement(name="material")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="material")
public class SMTAMaterial {
    public static final String JSON_PROPERTY_CROP = "crop";
    @XmlElement(name="crop")
    private String crop;
    public static final String JSON_PROPERTY_SAMPLE_I_D = "sampleID";
    @XmlElement(name="sampleID")
    private String sampleID;
    public static final String JSON_PROPERTY_PUD = "pud";
    @XmlElement(name="pud")
    private SMTAMaterialUnderDevelopment pud;
    public static final String JSON_PROPERTY_ANCESTRY = "ancestry";
    @XmlElement(name="ancestry")
    private String ancestry;

    public SMTAMaterial crop(String crop) {
        this.crop = crop;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Crop code as per table in General notes below.")
    @JsonProperty(value="crop")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="crop")
    public String getCrop() {
        return this.crop;
    }

    @JsonProperty(value="crop")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="crop")
    public void setCrop(String crop) {
        this.crop = crop;
    }

    public SMTAMaterial sampleID(String sampleID) {
        this.sampleID = sampleID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Sample ID, must be unique within the same SMTA. If available, please make sure to use the DOI assigned to the material using the prefix \"doi:\". For example \"doi:10.18730/34ER6\". Do not put any space.")
    @JsonProperty(value="sampleID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="sampleID")
    public String getSampleID() {
        return this.sampleID;
    }

    @JsonProperty(value="sampleID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="sampleID")
    public void setSampleID(String sampleID) {
        this.sampleID = sampleID;
    }

    public SMTAMaterial pud(SMTAMaterialUnderDevelopment pud) {
        this.pud = pud;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="pud")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="pud")
    public SMTAMaterialUnderDevelopment getPud() {
        return this.pud;
    }

    @JsonProperty(value="pud")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="pud")
    public void setPud(SMTAMaterialUnderDevelopment pud) {
        this.pud = pud;
    }

    public SMTAMaterial ancestry(String ancestry) {
        this.ancestry = ancestry;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Ancestry information as crop: sampleID1,sampleID2... where crop is the crop English name. Required only if PUD=y.")
    @JsonProperty(value="ancestry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="ancestry")
    public String getAncestry() {
        return this.ancestry;
    }

    @JsonProperty(value="ancestry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="ancestry")
    public void setAncestry(String ancestry) {
        this.ancestry = ancestry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SMTAMaterial smTAMaterial = (SMTAMaterial)o;
        return Objects.equals(this.crop, smTAMaterial.crop) && Objects.equals(this.sampleID, smTAMaterial.sampleID) && Objects.equals((Object)this.pud, (Object)smTAMaterial.pud) && Objects.equals(this.ancestry, smTAMaterial.ancestry);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.crop, this.sampleID, this.pud, this.ancestry});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SMTAMaterial {\n");
        sb.append("    crop: ").append(this.toIndentedString(this.crop)).append("\n");
        sb.append("    sampleID: ").append(this.toIndentedString(this.sampleID)).append("\n");
        sb.append("    pud: ").append(this.toIndentedString((Object)this.pud)).append("\n");
        sb.append("    ancestry: ").append(this.toIndentedString(this.ancestry)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

