/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.glis.v1.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.genesys.glis.v1.model.SMTAMaterial;
import org.genesys.glis.v1.model.SMTAReportDocument;
import org.genesys.glis.v1.model.SMTAReportProvider;
import org.genesys.glis.v1.model.SMTAReportRecipient;
import org.genesys.glis.v1.model.SMTASignatureType;

@JsonPropertyOrder(value={"symbol", "date", "type", "language", "provider", "recipient", "shipName", "annex1", "document"})
@XmlRootElement(name="smta")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="smta")
public class SMTAReport {
    public static final String JSON_PROPERTY_SYMBOL = "symbol";
    @XmlElement(name="symbol")
    private String symbol;
    public static final String JSON_PROPERTY_DATE = "date";
    @XmlElement(name="date")
    private String date;
    public static final String JSON_PROPERTY_TYPE = "type";
    @XmlElement(name="type")
    private SMTASignatureType type;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    @XmlElement(name="language")
    private String language;
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    @XmlElement(name="provider")
    private SMTAReportProvider provider;
    public static final String JSON_PROPERTY_RECIPIENT = "recipient";
    @XmlElement(name="recipient")
    private SMTAReportRecipient recipient;
    public static final String JSON_PROPERTY_SHIP_NAME = "shipName";
    @XmlElement(name="shipName")
    private String shipName;
    public static final String JSON_PROPERTY_ANNEX1 = "annex1";
    @XmlElement(name="material")
    @XmlElementWrapper(name="annex1")
    private List<SMTAMaterial> annex1 = null;
    public static final String JSON_PROPERTY_DOCUMENT = "document";
    @XmlElement(name="document")
    private SMTAReportDocument document;

    public SMTAReport symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SMTA symbol as assigned by the Provider. Two different SMTAs from the same Provider cannot have the same symbol.")
    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="symbol")
    public String getSymbol() {
        return this.symbol;
    }

    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="symbol")
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public SMTAReport date(String date) {
        this.date = date;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date of acceptance for shrink-wrap SMTAs, date of shipment for click-wrap SMTAs or date of final signature for signed SMTAs.")
    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="date")
    public String getDate() {
        return this.date;
    }

    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="date")
    public void setDate(String date) {
        this.date = date;
    }

    public SMTAReport type(SMTASignatureType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="type")
    public SMTASignatureType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="type")
    public void setType(SMTASignatureType type) {
        this.type = type;
    }

    public SMTAReport language(String language) {
        this.language = language;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO-2 code for the SMTA language as follows ar=arabic, en=english, es=spanish, fr=french, ru=russian, zh=chinese.")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="language")
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="language")
    public void setLanguage(String language) {
        this.language = language;
    }

    public SMTAReport provider(SMTAReportProvider provider) {
        this.provider = provider;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="provider")
    public SMTAReportProvider getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="provider")
    public void setProvider(SMTAReportProvider provider) {
        this.provider = provider;
    }

    public SMTAReport recipient(SMTAReportRecipient recipient) {
        this.recipient = recipient;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="recipient")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="recipient")
    public SMTAReportRecipient getRecipient() {
        return this.recipient;
    }

    @JsonProperty(value="recipient")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="recipient")
    public void setRecipient(SMTAReportRecipient recipient) {
        this.recipient = recipient;
    }

    public SMTAReport shipName(String shipName) {
        this.shipName = shipName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name and surname of the person to whom the shipment is made. Required only if type=sw.")
    @JsonProperty(value="shipName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="shipName")
    public String getShipName() {
        return this.shipName;
    }

    @JsonProperty(value="shipName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="shipName")
    public void setShipName(String shipName) {
        this.shipName = shipName;
    }

    public SMTAReport annex1(List<SMTAMaterial> annex1) {
        this.annex1 = annex1;
        return this;
    }

    public SMTAReport addAnnex1Item(SMTAMaterial annex1Item) {
        if (this.annex1 == null) {
            this.annex1 = new ArrayList<SMTAMaterial>();
        }
        this.annex1.add(annex1Item);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="annex1")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlElementWrapper(useWrapping=true, localName="annex1")
    public List<SMTAMaterial> getAnnex1() {
        return this.annex1;
    }

    @JsonProperty(value="annex1")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlElementWrapper(useWrapping=true, localName="annex1")
    public void setAnnex1(List<SMTAMaterial> annex1) {
        this.annex1 = annex1;
    }

    public SMTAReport document(SMTAReportDocument document) {
        this.document = document;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="document")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="document")
    public SMTAReportDocument getDocument() {
        return this.document;
    }

    @JsonProperty(value="document")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JacksonXmlProperty(localName="document")
    public void setDocument(SMTAReportDocument document) {
        this.document = document;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SMTAReport smTAReport = (SMTAReport)o;
        return Objects.equals(this.symbol, smTAReport.symbol) && Objects.equals(this.date, smTAReport.date) && Objects.equals((Object)this.type, (Object)smTAReport.type) && Objects.equals(this.language, smTAReport.language) && Objects.equals(this.provider, smTAReport.provider) && Objects.equals(this.recipient, smTAReport.recipient) && Objects.equals(this.shipName, smTAReport.shipName) && Objects.equals(this.annex1, smTAReport.annex1) && Objects.equals(this.document, smTAReport.document);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.symbol, this.date, this.type, this.language, this.provider, this.recipient, this.shipName, this.annex1, this.document});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SMTAReport {\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    shipName: ").append(this.toIndentedString(this.shipName)).append("\n");
        sb.append("    annex1: ").append(this.toIndentedString(this.annex1)).append("\n");
        sb.append("    document: ").append(this.toIndentedString(this.document)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

