package org.genesys.glis.v1.api;

import org.genesys.glis.v1.invoker.ApiClient;
import org.genesys.glis.v1.model.UpdateTargets;
import org.genesys.glis.v1.model.UpdatedTarget;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

import java.util.Collections;
import java.util.List;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
@Component("org.genesys.glis.v1.api.GenesysApi")
public class GenesysApi {
    private ApiClient apiClient;

    public GenesysApi() {
        this(new ApiClient());
    }

    @Autowired
    public GenesysApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Add Genesys as target URL to specified DOIs
     * We&#39;ll have fun!
     * <p><b>200</b> - Successful operation
     * @param targets Registers Genesys as a target URL for specified DOIs (required)
     * @return List&lt;UpdatedTarget&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<UpdatedTarget> registerGenesysAsTarget(UpdateTargets targets) throws RestClientException {
        return registerGenesysAsTargetWithHttpInfo(targets).getBody();
    }

    /**
     * Add Genesys as target URL to specified DOIs
     * We&#39;ll have fun!
     * <p><b>200</b> - Successful operation
     * @param targets Registers Genesys as a target URL for specified DOIs (required)
     * @return ResponseEntity&lt;List&lt;UpdatedTarget&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<UpdatedTarget>> registerGenesysAsTargetWithHttpInfo(UpdateTargets targets) throws RestClientException {
        Object localVarPostBody = targets;
        
        // verify the required parameter 'targets' is set
        if (targets == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'targets' when calling registerGenesysAsTarget");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application-json"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "easySmta" };

        ParameterizedTypeReference<List<UpdatedTarget>> localReturnType = new ParameterizedTypeReference<List<UpdatedTarget>>() {};
        return apiClient.invokeAPI("/glis/links/addtarget", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}
