package org.genesys.glis.v1.api;

import org.genesys.glis.v1.invoker.ApiClient;
import org.genesys.glis.v1.model.DOIArray;
import org.genesys.glis.v1.model.DOIHolder;
import org.genesys.glis.v1.model.PGRFA;
import org.genesys.glis.v1.model.Relationship;
import org.genesys.glis.v1.model.Term;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

import java.util.Collections;
import java.util.List;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
@Component("org.genesys.glis.v1.api.QueryApi")
public class QueryApi {
    private ApiClient apiClient;

    public QueryApi() {
        this(new ApiClient());
    }

    @Autowired
    public QueryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Query for holder of PGRFA by DOIs
     * Query GLIS for WIEWS code of the holder for each submitted DOI. At this time, the call has a limit of 1,000 DOIs.
     * <p><b>200</b> - successful operation
     * @param dois  (required)
     * @return List&lt;DOIHolder&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<DOIHolder> listHolders(DOIArray dois) throws RestClientException {
        return listHoldersWithHttpInfo(dois).getBody();
    }

    /**
     * Query for holder of PGRFA by DOIs
     * Query GLIS for WIEWS code of the holder for each submitted DOI. At this time, the call has a limit of 1,000 DOIs.
     * <p><b>200</b> - successful operation
     * @param dois  (required)
     * @return ResponseEntity&lt;List&lt;DOIHolder&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<DOIHolder>> listHoldersWithHttpInfo(DOIArray dois) throws RestClientException {
        Object localVarPostBody = dois;
        
        // verify the required parameter 'dois' is set
        if (dois == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'dois' when calling listHolders");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application-json"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "easySmta" };

        ParameterizedTypeReference<List<DOIHolder>> localReturnType = new ParameterizedTypeReference<List<DOIHolder>>() {};
        return apiClient.invokeAPI("/glisapi/v1/holders", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get PGRFA relationships
     * Multiple status values can be provided with comma separated strings
     * <p><b>200</b> - successful operation
     * <p><b>400</b> - Invalid status value
     * @param doi Digital Object Identifier (DOI) associated to the PGRFA for which relations are requested. Mandatory (required)
     * @param role Role of doi in the relationships. Optional, defaults to &#39;any&#39;. Role in the relationship * any - Any role, default. * subject - DOI provided is the subject in the relationship. * object - DOI provided is the object in the relationship. (optional)
     * @param oper Relational operator code to filter the relations. Optional; if specified, only the relations with the given operator will be returned. Relational code * acfr - Acquired from. The PGRFA was received from a Provider. The related DOI identifies the Provider&#39;s sample * crfr - Created from. The PGRFA was obtained through crossing parent PGRFAs. The related DOIs identify the parent samples * defr - Derived from. The PGRFA was obtained from another sample. The related DOI identifies such original sample (optional)
     * @return List&lt;Relationship&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<Relationship> listRelationships(String doi, String role, String oper) throws RestClientException {
        return listRelationshipsWithHttpInfo(doi, role, oper).getBody();
    }

    /**
     * Get PGRFA relationships
     * Multiple status values can be provided with comma separated strings
     * <p><b>200</b> - successful operation
     * <p><b>400</b> - Invalid status value
     * @param doi Digital Object Identifier (DOI) associated to the PGRFA for which relations are requested. Mandatory (required)
     * @param role Role of doi in the relationships. Optional, defaults to &#39;any&#39;. Role in the relationship * any - Any role, default. * subject - DOI provided is the subject in the relationship. * object - DOI provided is the object in the relationship. (optional)
     * @param oper Relational operator code to filter the relations. Optional; if specified, only the relations with the given operator will be returned. Relational code * acfr - Acquired from. The PGRFA was received from a Provider. The related DOI identifies the Provider&#39;s sample * crfr - Created from. The PGRFA was obtained through crossing parent PGRFAs. The related DOIs identify the parent samples * defr - Derived from. The PGRFA was obtained from another sample. The related DOI identifies such original sample (optional)
     * @return ResponseEntity&lt;List&lt;Relationship&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<Relationship>> listRelationshipsWithHttpInfo(String doi, String role, String oper) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'doi' is set
        if (doi == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'doi' when calling listRelationships");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "doi", doi));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "role", role));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "oper", oper));

        final String[] localVarAccepts = { 
            "*/*", "application-json"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "easySmta" };

        ParameterizedTypeReference<List<Relationship>> localReturnType = new ParameterizedTypeReference<List<Relationship>>() {};
        return apiClient.invokeAPI("/glisapi/v1/rels", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * GLIS vocabularies
     * To describe the kind of information that will be found in the targets, GLIS adopts a simple controlled vocabulary.
     * <p><b>200</b> - successful operation
     * @param acceptLanguage Tags to filter by (optional)
     * @return List&lt;Term&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<Term> listTerms(List<String> acceptLanguage) throws RestClientException {
        return listTermsWithHttpInfo(acceptLanguage).getBody();
    }

    /**
     * GLIS vocabularies
     * To describe the kind of information that will be found in the targets, GLIS adopts a simple controlled vocabulary.
     * <p><b>200</b> - successful operation
     * @param acceptLanguage Tags to filter by (optional)
     * @return ResponseEntity&lt;List&lt;Term&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<Term>> listTermsWithHttpInfo(List<String> acceptLanguage) throws RestClientException {
        Object localVarPostBody = null;
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        if (acceptLanguage != null)
        localVarHeaderParams.add("Accept-Language", apiClient.parameterToString(acceptLanguage));

        final String[] localVarAccepts = { 
            "*/*", "application-json", "application-xml"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "easySmta" };

        ParameterizedTypeReference<List<Term>> localReturnType = new ParameterizedTypeReference<List<Term>>() {};
        return apiClient.invokeAPI("/glisapi/v1/terms", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Find passport data on PGRFA in GLIS
     * 
     * <p><b>200</b> - Successful operation
     * <p><b>404</b> - PGRFA not found
     * <p><b>429</b> - Too Many Requests
     * @param page Request a particular page (optional, default to 1)
     * @param perPage The number of items returned in a single page (optional, default to 10)
     * @param acceptLanguage Tags to filter by (optional)
     * @param doi Digital Object Identifier (DOI) associated to the PGRFA (optional)
     * @param identifier Any identifier associated with the PGRFA, excluding the DOI (optional)
     * @param genus Genus of the PGRFA (optional)
     * @param species Species and other taxonomic elements (optional)
     * @param name Any name associated with the PGRFA (optional)
     * @param holdwiews FAO/WIEWS Institute code of the holding institution (optional)
     * @param holdpid Easy-SMTA PID of the holding institution or person (optional)
     * @param holdname Name and surname for persons or Organization name of the holding institution or person (optional)
     * @param holdcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the holding institution or person (optional)
     * @param methodcode Code of the method through which the PGRFA has been acquired. See Table 1 for the codes accepted by this element. TODO enum (optional)
     * @param provwiews FAO/WIEWS Institute code of the providing institution (optional)
     * @param provpid Easy-SMTA PID of the providing institution or person (optional)
     * @param provname Name and surname for persons or Organization name of the providing institution (optional)
     * @param provcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the providing institution or person (optional)
     * @param provenance ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the providing institution or person (optional)
     * @param collwiews FAO/WIEWS Institute code of the collecting institution (optional)
     * @param collpid Easy-SMTA PID of the collecting institution or person (optional)
     * @param collname Name and surname for persons or Organization name of the collecting institution or person (optional)
     * @param collcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the collecting institution or person (optional)
     * @param bredwiews FAO/WIEWS Institute code of the breeding institution (optional)
     * @param bredpid Easy-SMTA PID of the breeding institution or person (optional)
     * @param bredname Name and surname for persons or Organization name of the breeding institution or person (optional)
     * @param bredcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the breeding institution or person (optional)
     * @param biostatus Code of the biological status of sample (MCPD SAMPSTAT). (optional)
     * @param mlsstatus Code for the inclusion into the Multilateral System. (optional)
     * @param targetkw Code for the keyword for a target associated to the PGRFA. To obtain the list of keyword codes, please see \&quot;Controlled vocabulary query\&quot;. (optional)
     * @return List&lt;PGRFA&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<PGRFA> search(Integer page, Integer perPage, List<String> acceptLanguage, String doi, String identifier, String genus, String species, String name, String holdwiews, String holdpid, String holdname, String holdcountry, String methodcode, String provwiews, String provpid, String provname, String provcountry, String provenance, String collwiews, String collpid, String collname, String collcountry, String bredwiews, String bredpid, String bredname, String bredcountry, String biostatus, String mlsstatus, String targetkw) throws RestClientException {
        return searchWithHttpInfo(page, perPage, acceptLanguage, doi, identifier, genus, species, name, holdwiews, holdpid, holdname, holdcountry, methodcode, provwiews, provpid, provname, provcountry, provenance, collwiews, collpid, collname, collcountry, bredwiews, bredpid, bredname, bredcountry, biostatus, mlsstatus, targetkw).getBody();
    }

    /**
     * Find passport data on PGRFA in GLIS
     * 
     * <p><b>200</b> - Successful operation
     * <p><b>404</b> - PGRFA not found
     * <p><b>429</b> - Too Many Requests
     * @param page Request a particular page (optional, default to 1)
     * @param perPage The number of items returned in a single page (optional, default to 10)
     * @param acceptLanguage Tags to filter by (optional)
     * @param doi Digital Object Identifier (DOI) associated to the PGRFA (optional)
     * @param identifier Any identifier associated with the PGRFA, excluding the DOI (optional)
     * @param genus Genus of the PGRFA (optional)
     * @param species Species and other taxonomic elements (optional)
     * @param name Any name associated with the PGRFA (optional)
     * @param holdwiews FAO/WIEWS Institute code of the holding institution (optional)
     * @param holdpid Easy-SMTA PID of the holding institution or person (optional)
     * @param holdname Name and surname for persons or Organization name of the holding institution or person (optional)
     * @param holdcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the holding institution or person (optional)
     * @param methodcode Code of the method through which the PGRFA has been acquired. See Table 1 for the codes accepted by this element. TODO enum (optional)
     * @param provwiews FAO/WIEWS Institute code of the providing institution (optional)
     * @param provpid Easy-SMTA PID of the providing institution or person (optional)
     * @param provname Name and surname for persons or Organization name of the providing institution (optional)
     * @param provcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the providing institution or person (optional)
     * @param provenance ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the providing institution or person (optional)
     * @param collwiews FAO/WIEWS Institute code of the collecting institution (optional)
     * @param collpid Easy-SMTA PID of the collecting institution or person (optional)
     * @param collname Name and surname for persons or Organization name of the collecting institution or person (optional)
     * @param collcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the collecting institution or person (optional)
     * @param bredwiews FAO/WIEWS Institute code of the breeding institution (optional)
     * @param bredpid Easy-SMTA PID of the breeding institution or person (optional)
     * @param bredname Name and surname for persons or Organization name of the breeding institution or person (optional)
     * @param bredcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the breeding institution or person (optional)
     * @param biostatus Code of the biological status of sample (MCPD SAMPSTAT). (optional)
     * @param mlsstatus Code for the inclusion into the Multilateral System. (optional)
     * @param targetkw Code for the keyword for a target associated to the PGRFA. To obtain the list of keyword codes, please see \&quot;Controlled vocabulary query\&quot;. (optional)
     * @return ResponseEntity&lt;List&lt;PGRFA&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<PGRFA>> searchWithHttpInfo(Integer page, Integer perPage, List<String> acceptLanguage, String doi, String identifier, String genus, String species, String name, String holdwiews, String holdpid, String holdname, String holdcountry, String methodcode, String provwiews, String provpid, String provname, String provcountry, String provenance, String collwiews, String collpid, String collname, String collcountry, String bredwiews, String bredpid, String bredname, String bredcountry, String biostatus, String mlsstatus, String targetkw) throws RestClientException {
        Object localVarPostBody = null;
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "per-page", perPage));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "doi", doi));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "identifier", identifier));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "genus", genus));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "species", species));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "name", name));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "holdwiews", holdwiews));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "holdpid", holdpid));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "holdname", holdname));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "holdcountry", holdcountry));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "methodcode", methodcode));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "provwiews", provwiews));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "provpid", provpid));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "provname", provname));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "provcountry", provcountry));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "provenance", provenance));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "collwiews", collwiews));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "collpid", collpid));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "collname", collname));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "collcountry", collcountry));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "bredwiews", bredwiews));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "bredpid", bredpid));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "bredname", bredname));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "bredcountry", bredcountry));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "biostatus", biostatus));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "mlsstatus", mlsstatus));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "targetkw", targetkw));

        if (acceptLanguage != null)
        localVarHeaderParams.add("Accept-Language", apiClient.parameterToString(acceptLanguage));

        final String[] localVarAccepts = { 
            "*/*", "application-json"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "easySmta" };

        ParameterizedTypeReference<List<PGRFA>> localReturnType = new ParameterizedTypeReference<List<PGRFA>>() {};
        return apiClient.invokeAPI("/glisapi/v1/pgrfas", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}
