/*
 * Global Information System API Client
 * Genesys API client to the Global Information System (GLIS) for PGRFA  [https://glis.planttreaty.org](https://glis.planttreaty.org).
 *
 * The version of the OpenAPI document: 1.1-SNAPSHOT
 * Contact: helpdesk@genesys-pgr.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.genesys.glis.v1.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.swagger.annotations.ApiModelProperty;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Objects;

/**
 * Acquisition
 */
@JsonPropertyOrder({
  Acquisition.JSON_PROPERTY_PROVIDER,
  Acquisition.JSON_PROPERTY_SAMPLEID,
  Acquisition.JSON_PROPERTY_PROVENANCE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
@XmlRootElement(name = "Acquisition")
@XmlAccessorType(XmlAccessType.FIELD)
@JacksonXmlRootElement(localName = "Acquisition")
public class Acquisition {
  public static final String JSON_PROPERTY_PROVIDER = "provider";
  @XmlElement(name = "provider")
  private Actor provider;

  public static final String JSON_PROPERTY_SAMPLEID = "sampleid";
  @XmlElement(name = "sampleid")
  private String sampleid;

  public static final String JSON_PROPERTY_PROVENANCE = "provenance";
  @XmlElement(name = "provenance")
  private String provenance;

  public Acquisition() { 
  }

  public Acquisition provider(Actor provider) {
    
    this.provider = provider;
    return this;
  }

   /**
   * Get provider
   * @return provider
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  @JacksonXmlProperty(localName = "provider")

  public Actor getProvider() {
    return provider;
  }


  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  @JacksonXmlProperty(localName = "provider")
  public void setProvider(Actor provider) {
    this.provider = provider;
  }


  public Acquisition sampleid(String sampleid) {
    
    this.sampleid = sampleid;
    return this;
  }

   /**
   * Get sampleid
   * @return sampleid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SAMPLEID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "sampleid")

  public String getSampleid() {
    return sampleid;
  }


  @JsonProperty(JSON_PROPERTY_SAMPLEID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "sampleid")
  public void setSampleid(String sampleid) {
    this.sampleid = sampleid;
  }


  public Acquisition provenance(String provenance) {
    
    this.provenance = provenance;
    return this;
  }

   /**
   * ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the country of provenance.
   * @return provenance
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "DEU", value = "ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the country of provenance.")
  @JsonProperty(JSON_PROPERTY_PROVENANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "provenance")

  public String getProvenance() {
    return provenance;
  }


  @JsonProperty(JSON_PROPERTY_PROVENANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "provenance")
  public void setProvenance(String provenance) {
    this.provenance = provenance;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Acquisition acquisition = (Acquisition) o;
    return Objects.equals(this.provider, acquisition.provider) &&
        Objects.equals(this.sampleid, acquisition.sampleid) &&
        Objects.equals(this.provenance, acquisition.provenance);
  }

  @Override
  public int hashCode() {
    return Objects.hash(provider, sampleid, provenance);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Acquisition {\n");
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("    sampleid: ").append(toIndentedString(sampleid)).append("\n");
    sb.append("    provenance: ").append(toIndentedString(provenance)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

