/*
 * Global Information System API Client
 * Genesys API client to the Global Information System (GLIS) for PGRFA  [https://glis.planttreaty.org](https://glis.planttreaty.org).
 *
 * The version of the OpenAPI document: 1.1-SNAPSHOT
 * Contact: helpdesk@genesys-pgr.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.genesys.glis.v1.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.swagger.annotations.ApiModelProperty;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * BasePGRFA
 */
@JsonPropertyOrder({
  BasePGRFA.JSON_PROPERTY_USERNAME,
  BasePGRFA.JSON_PROPERTY_PASSWORD,
  BasePGRFA.JSON_PROPERTY_LOCATION,
  BasePGRFA.JSON_PROPERTY_SAMPLEDOI,
  BasePGRFA.JSON_PROPERTY_SAMPLEID,
  BasePGRFA.JSON_PROPERTY_DATE,
  BasePGRFA.JSON_PROPERTY_METHOD,
  BasePGRFA.JSON_PROPERTY_GENUS,
  BasePGRFA.JSON_PROPERTY_CROPNAMES,
  BasePGRFA.JSON_PROPERTY_TARGETS,
  BasePGRFA.JSON_PROPERTY_PROGDOI,
  BasePGRFA.JSON_PROPERTY_BIOSTATUS,
  BasePGRFA.JSON_PROPERTY_SPECIES,
  BasePGRFA.JSON_PROPERTY_SPAUTH,
  BasePGRFA.JSON_PROPERTY_SUBTAXA,
  BasePGRFA.JSON_PROPERTY_STAUTH,
  BasePGRFA.JSON_PROPERTY_NAMES,
  BasePGRFA.JSON_PROPERTY_IDS,
  BasePGRFA.JSON_PROPERTY_MLSSTATUS,
  BasePGRFA.JSON_PROPERTY_HISTORICAL,
  BasePGRFA.JSON_PROPERTY_ACQUISITION,
  BasePGRFA.JSON_PROPERTY_COLLECTION,
  BasePGRFA.JSON_PROPERTY_BREEDING
})
@JsonTypeName("basePGRFA")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
@JsonIgnoreProperties(
  value = "base", // ignore manually set base, it will be automatically generated by Jackson during serialization
  allowSetters = true // allows the base to be set during deserialization
)
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "base", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = PGRFARegistration.class, name = "PGRFARegistration"),
  @JsonSubTypes.Type(value = PGRFAUpdate.class, name = "PGRFAUpdate"),
})

@XmlRootElement(name = "BasePGRFA")
@XmlAccessorType(XmlAccessType.FIELD)
@JacksonXmlRootElement(localName = "BasePGRFA")
public class BasePGRFA {
  public static final String JSON_PROPERTY_USERNAME = "username";
  @XmlAttribute(name = "username")
  private String username;

  public static final String JSON_PROPERTY_PASSWORD = "password";
  @XmlAttribute(name = "password")
  private String password;

  public static final String JSON_PROPERTY_LOCATION = "location";
  @XmlElement(name = "location")
  private Location location;

  public static final String JSON_PROPERTY_SAMPLEDOI = "sampledoi";
  @XmlElement(name = "sampledoi")
  private String sampledoi;

  public static final String JSON_PROPERTY_SAMPLEID = "sampleid";
  @XmlElement(name = "sampleid")
  private String sampleid;

  public static final String JSON_PROPERTY_DATE = "date";
  @XmlElement(name = "date")
  private String date;

  public static final String JSON_PROPERTY_METHOD = "method";
  @XmlElement(name = "method")
  private String method;

  public static final String JSON_PROPERTY_GENUS = "genus";
  @XmlElement(name = "genus")
  private String genus;

  public static final String JSON_PROPERTY_CROPNAMES = "cropnames";
  // Is a container wrapped=true
  // items.name=cropnames items.baseName=cropnames items.xmlName=name items.xmlNamespace=
  // items.example=Barley items.type=String
  @XmlElement(name = "name")
  @XmlElementWrapper(name = "cropnames")
  private List<String> cropnames = null;

  public static final String JSON_PROPERTY_TARGETS = "targets";
  // Is a container wrapped=true
  // items.name=targets items.baseName=targets items.xmlName= items.xmlNamespace=
  // items.example= items.type=Target
  @XmlElement(name = "target")
  @XmlElementWrapper(name = "targets")
  private List<Target> targets = null;

  public static final String JSON_PROPERTY_PROGDOI = "progdoi";
  // Is a container wrapped=true
  // items.name=progdoi items.baseName=progdoi items.xmlName=doi items.xmlNamespace=
  // items.example=10.0155/134 items.type=String
  @XmlElement(name = "doi")
  @XmlElementWrapper(name = "progdoi")
  private List<String> progdoi = null;

  public static final String JSON_PROPERTY_BIOSTATUS = "biostatus";
  @XmlElement(name = "biostatus")
  private Integer biostatus;

  public static final String JSON_PROPERTY_SPECIES = "species";
  @XmlElement(name = "species")
  private String species;

  public static final String JSON_PROPERTY_SPAUTH = "spauth";
  @XmlElement(name = "spauth")
  private String spauth;

  public static final String JSON_PROPERTY_SUBTAXA = "subtaxa";
  @XmlElement(name = "subtaxa")
  private String subtaxa;

  public static final String JSON_PROPERTY_STAUTH = "stauth";
  @XmlElement(name = "stauth")
  private String stauth;

  public static final String JSON_PROPERTY_NAMES = "names";
  // Is a container wrapped=true
  // items.name=names items.baseName=names items.xmlName=name items.xmlNamespace=
  // items.example= items.type=String
  @XmlElement(name = "name")
  @XmlElementWrapper(name = "names")
  private List<String> names = null;

  public static final String JSON_PROPERTY_IDS = "ids";
  // Is a container wrapped=true
  // items.name=ids items.baseName=ids items.xmlName= items.xmlNamespace=
  // items.example= items.type=PGRFAIdentifier
  @XmlElement(name = "id")
  @XmlElementWrapper(name = "ids")
  private List<PGRFAIdentifier> ids = null;

  public static final String JSON_PROPERTY_MLSSTATUS = "mlsstatus";
  @XmlElement(name = "mlsstatus")
  private Integer mlsstatus;

  public static final String JSON_PROPERTY_HISTORICAL = "historical";
  @XmlElement(name = "historical")
  private String historical;

  public static final String JSON_PROPERTY_ACQUISITION = "acquisition";
  @XmlElement(name = "acquisition")
  private Acquisition acquisition;

  public static final String JSON_PROPERTY_COLLECTION = "collection";
  @XmlElement(name = "collection")
  private Collection collection;

  public static final String JSON_PROPERTY_BREEDING = "breeding";
  @XmlElement(name = "breeding")
  private Breeding breeding;

  public BasePGRFA() { 
  }

  public BasePGRFA username(String username) {
    
    this.username = username;
    return this;
  }

   /**
   * Get username
   * @return username
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "cgn", value = "")
  @JsonProperty(JSON_PROPERTY_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(isAttribute = true, localName = "username")

  public String getUsername() {
    return username;
  }


  @JsonProperty(JSON_PROPERTY_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(isAttribute = true, localName = "username")
  public void setUsername(String username) {
    this.username = username;
  }


  public BasePGRFA password(String password) {
    
    this.password = password;
    return this;
  }

   /**
   * Get password
   * @return password
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Passw0rd", value = "")
  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(isAttribute = true, localName = "password")

  public String getPassword() {
    return password;
  }


  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(isAttribute = true, localName = "password")
  public void setPassword(String password) {
    this.password = password;
  }


  public BasePGRFA location(Location location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "location")

  public Location getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "location")
  public void setLocation(Location location) {
    this.location = location;
  }


  public BasePGRFA sampledoi(String sampledoi) {
    
    this.sampledoi = sampledoi;
    return this;
  }

   /**
   * A Digital Object Identifier (DOI) obtained from a service other than GLIS and that is already assigned to the PGRFA.
   * @return sampledoi
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A Digital Object Identifier (DOI) obtained from a service other than GLIS and that is already assigned to the PGRFA.")
  @JsonProperty(JSON_PROPERTY_SAMPLEDOI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "sampledoi")

  public String getSampledoi() {
    return sampledoi;
  }


  @JsonProperty(JSON_PROPERTY_SAMPLEDOI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "sampledoi")
  public void setSampledoi(String sampledoi) {
    this.sampledoi = sampledoi;
  }


  public BasePGRFA sampleid(String sampleid) {
    
    this.sampleid = sampleid;
    return this;
  }

   /**
   * A string that identifies the PGRFA that is being registered. This value will be returned by GLIS in the response message and is assumed to be used to associate the DOI to the corresponding material in the local database. You must provide &lt;sampleid&gt; even if &lt;sampledoi&gt; is provided. In case you use the DOI as unique identifier in your local database, you can repeat it in &lt;sampleid&gt;. Mandatory. Please read more details in the “HTTPS reply” chapter.
   * @return sampleid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "CGN00001", value = "A string that identifies the PGRFA that is being registered. This value will be returned by GLIS in the response message and is assumed to be used to associate the DOI to the corresponding material in the local database. You must provide <sampleid> even if <sampledoi> is provided. In case you use the DOI as unique identifier in your local database, you can repeat it in <sampleid>. Mandatory. Please read more details in the “HTTPS reply” chapter.")
  @JsonProperty(JSON_PROPERTY_SAMPLEID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "sampleid")

  public String getSampleid() {
    return sampleid;
  }


  @JsonProperty(JSON_PROPERTY_SAMPLEID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "sampleid")
  public void setSampleid(String sampleid) {
    this.sampleid = sampleid;
  }


  public BasePGRFA date(String date) {
    
    this.date = date;
    return this;
  }

   /**
   * Date in which PGRFA became part of the collection. Date fragments (YYYY-MM and YYYY) are also accepted.
   * @return date
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1987-06-23", value = "Date in which PGRFA became part of the collection. Date fragments (YYYY-MM and YYYY) are also accepted.")
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "date")

  public String getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "date")
  public void setDate(String date) {
    this.date = date;
  }


  public BasePGRFA method(String method) {
    
    this.method = method;
    return this;
  }

   /**
   * Method through which the PGRFA has been acquired. Mandatory.
   * @return method
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "acqu", value = "Method through which the PGRFA has been acquired. Mandatory.")
  @JsonProperty(JSON_PROPERTY_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "method")

  public String getMethod() {
    return method;
  }


  @JsonProperty(JSON_PROPERTY_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "method")
  public void setMethod(String method) {
    this.method = method;
  }


  public BasePGRFA genus(String genus) {
    
    this.genus = genus;
    return this;
  }

   /**
   * The taxon of the genus for the PGRFA. At least one between &lt;genus&gt; and &lt;cropname&gt; must be provided.
   * @return genus
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Hordeum", value = "The taxon of the genus for the PGRFA. At least one between <genus> and <cropname> must be provided.")
  @JsonProperty(JSON_PROPERTY_GENUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "genus")

  public String getGenus() {
    return genus;
  }


  @JsonProperty(JSON_PROPERTY_GENUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "genus")
  public void setGenus(String genus) {
    this.genus = genus;
  }


  public BasePGRFA cropnames(List<String> cropnames) {
    
    this.cropnames = cropnames;
    return this;
  }

  public BasePGRFA addCropnamesItem(String cropnamesItem) {
    if (this.cropnames == null) {
      this.cropnames = new ArrayList<>();
    }
    this.cropnames.add(cropnamesItem);
    return this;
  }

   /**
   * Common name of the crop. At least one between &lt;genus&gt; and one cropname must be provided. Multiple names are allowed.
   * @return cropnames
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"Barley\",\"Wheat\"]", value = "Common name of the crop. At least one between <genus> and one cropname must be provided. Multiple names are allowed.")
  @JsonProperty(JSON_PROPERTY_CROPNAMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  // items.xmlName=name
  @JacksonXmlElementWrapper(useWrapping = true, localName = "name")

  public List<String> getCropnames() {
    return cropnames;
  }


  @JsonProperty(JSON_PROPERTY_CROPNAMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  // items.xmlName=name
  @JacksonXmlElementWrapper(useWrapping = true, localName = "name")
  public void setCropnames(List<String> cropnames) {
    this.cropnames = cropnames;
  }


  public BasePGRFA targets(List<Target> targets) {
    
    this.targets = targets;
    return this;
  }

  public BasePGRFA addTargetsItem(Target targetsItem) {
    if (this.targets == null) {
      this.targets = new ArrayList<>();
    }
    this.targets.add(targetsItem);
    return this;
  }

   /**
   * Get targets
   * @return targets
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TARGETS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  // items.xmlName=
  @JacksonXmlElementWrapper(useWrapping = true, localName = "targets")

  public List<Target> getTargets() {
    return targets;
  }


  @JsonProperty(JSON_PROPERTY_TARGETS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  // items.xmlName=
  @JacksonXmlElementWrapper(useWrapping = true, localName = "targets")
  public void setTargets(List<Target> targets) {
    this.targets = targets;
  }


  public BasePGRFA progdoi(List<String> progdoi) {
    
    this.progdoi = progdoi;
    return this;
  }

  public BasePGRFA addProgdoiItem(String progdoiItem) {
    if (this.progdoi == null) {
      this.progdoi = new ArrayList<>();
    }
    this.progdoi.add(progdoiItem);
    return this;
  }

   /**
   * DOI of the progenitor PGRFA as registered in GLIS. Please note that the number of allowed DOIs depends on the method as follows   * Acquisition - 1 DOI  * In-house copy - 1 DOI  * In-house variant - 1 DOI  * Novel distinct PGRFA - 1 or more DOIs  * Observation - Natural - 0 DOI  * Observation - Inherited - 0 DOI
   * @return progdoi
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"10.0155/11\",\"10.0155/12\"]", value = "DOI of the progenitor PGRFA as registered in GLIS. Please note that the number of allowed DOIs depends on the method as follows   * Acquisition - 1 DOI  * In-house copy - 1 DOI  * In-house variant - 1 DOI  * Novel distinct PGRFA - 1 or more DOIs  * Observation - Natural - 0 DOI  * Observation - Inherited - 0 DOI")
  @JsonProperty(JSON_PROPERTY_PROGDOI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  // items.xmlName=doi
  @JacksonXmlElementWrapper(useWrapping = true, localName = "doi")

  public List<String> getProgdoi() {
    return progdoi;
  }


  @JsonProperty(JSON_PROPERTY_PROGDOI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  // items.xmlName=doi
  @JacksonXmlElementWrapper(useWrapping = true, localName = "doi")
  public void setProgdoi(List<String> progdoi) {
    this.progdoi = progdoi;
  }


  public BasePGRFA biostatus(Integer biostatus) {
    
    this.biostatus = biostatus;
    return this;
  }

   /**
   * Biological status of the PGRFA.
   * @return biostatus
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "300", value = "Biological status of the PGRFA.")
  @JsonProperty(JSON_PROPERTY_BIOSTATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "biostatus")

  public Integer getBiostatus() {
    return biostatus;
  }


  @JsonProperty(JSON_PROPERTY_BIOSTATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "biostatus")
  public void setBiostatus(Integer biostatus) {
    this.biostatus = biostatus;
  }


  public BasePGRFA species(String species) {
    
    this.species = species;
    return this;
  }

   /**
   * Specific epithet of the PGRFA scientific name. If not provided, \&quot;sp.\&quot; is assumed.
   * @return species
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "vulgare", value = "Specific epithet of the PGRFA scientific name. If not provided, \"sp.\" is assumed.")
  @JsonProperty(JSON_PROPERTY_SPECIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "species")

  public String getSpecies() {
    return species;
  }


  @JsonProperty(JSON_PROPERTY_SPECIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "species")
  public void setSpecies(String species) {
    this.species = species;
  }


  public BasePGRFA spauth(String spauth) {
    
    this.spauth = spauth;
    return this;
  }

   /**
   * Authority for the specific epithet.
   * @return spauth
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "L.", value = "Authority for the specific epithet.")
  @JsonProperty(JSON_PROPERTY_SPAUTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "spauth")

  public String getSpauth() {
    return spauth;
  }


  @JsonProperty(JSON_PROPERTY_SPAUTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "spauth")
  public void setSpauth(String spauth) {
    this.spauth = spauth;
  }


  public BasePGRFA subtaxa(String subtaxa) {
    
    this.subtaxa = subtaxa;
    return this;
  }

   /**
   * Any additional infra-specific taxon such as subspecies, variety, form, Group and so on.
   * @return subtaxa
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "subsp. vulgare", value = "Any additional infra-specific taxon such as subspecies, variety, form, Group and so on.")
  @JsonProperty(JSON_PROPERTY_SUBTAXA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "subtaxa")

  public String getSubtaxa() {
    return subtaxa;
  }


  @JsonProperty(JSON_PROPERTY_SUBTAXA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "subtaxa")
  public void setSubtaxa(String subtaxa) {
    this.subtaxa = subtaxa;
  }


  public BasePGRFA stauth(String stauth) {
    
    this.stauth = stauth;
    return this;
  }

   /**
   * Authority for the subtaxon at the most detailed level provided.
   * @return stauth
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "L.", value = "Authority for the subtaxon at the most detailed level provided.")
  @JsonProperty(JSON_PROPERTY_STAUTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "stauth")

  public String getStauth() {
    return stauth;
  }


  @JsonProperty(JSON_PROPERTY_STAUTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "stauth")
  public void setStauth(String stauth) {
    this.stauth = stauth;
  }


  public BasePGRFA names(List<String> names) {
    
    this.names = names;
    return this;
  }

  public BasePGRFA addNamesItem(String namesItem) {
    if (this.names == null) {
      this.names = new ArrayList<>();
    }
    this.names.add(namesItem);
    return this;
  }

   /**
   * Other name of the PGRFA. Any number of names can be provided.
   * @return names
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"a\",\"b\"]", value = "Other name of the PGRFA. Any number of names can be provided.")
  @JsonProperty(JSON_PROPERTY_NAMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  // items.xmlName=name
  @JacksonXmlElementWrapper(useWrapping = true, localName = "name")

  public List<String> getNames() {
    return names;
  }


  @JsonProperty(JSON_PROPERTY_NAMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  // items.xmlName=name
  @JacksonXmlElementWrapper(useWrapping = true, localName = "name")
  public void setNames(List<String> names) {
    this.names = names;
  }


  public BasePGRFA ids(List<PGRFAIdentifier> ids) {
    
    this.ids = ids;
    return this;
  }

  public BasePGRFA addIdsItem(PGRFAIdentifier idsItem) {
    if (this.ids == null) {
      this.ids = new ArrayList<>();
    }
    this.ids.add(idsItem);
    return this;
  }

   /**
   * Get ids
   * @return ids
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"a\",\"b\"]", value = "")
  @JsonProperty(JSON_PROPERTY_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  // items.xmlName=
  @JacksonXmlElementWrapper(useWrapping = true, localName = "ids")

  public List<PGRFAIdentifier> getIds() {
    return ids;
  }


  @JsonProperty(JSON_PROPERTY_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  // items.xmlName=
  @JacksonXmlElementWrapper(useWrapping = true, localName = "ids")
  public void setIds(List<PGRFAIdentifier> ids) {
    this.ids = ids;
  }


  public BasePGRFA mlsstatus(Integer mlsstatus) {
    
    this.mlsstatus = mlsstatus;
    return this;
  }

   /**
   * Code that identifies the status of the PGRFA with regard to the MLS.
   * @return mlsstatus
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "Code that identifies the status of the PGRFA with regard to the MLS.")
  @JsonProperty(JSON_PROPERTY_MLSSTATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "mlsstatus")

  public Integer getMlsstatus() {
    return mlsstatus;
  }


  @JsonProperty(JSON_PROPERTY_MLSSTATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "mlsstatus")
  public void setMlsstatus(Integer mlsstatus) {
    this.mlsstatus = mlsstatus;
  }


  public BasePGRFA historical(String historical) {
    
    this.historical = historical;
    return this;
  }

   /**
   * Indicates whether the PGRFA currently exists. Allowed value is y/n
   * @return historical
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "n", value = "Indicates whether the PGRFA currently exists. Allowed value is y/n")
  @JsonProperty(JSON_PROPERTY_HISTORICAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "historical")

  public String getHistorical() {
    return historical;
  }


  @JsonProperty(JSON_PROPERTY_HISTORICAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "historical")
  public void setHistorical(String historical) {
    this.historical = historical;
  }


  public BasePGRFA acquisition(Acquisition acquisition) {
    
    this.acquisition = acquisition;
    return this;
  }

   /**
   * Get acquisition
   * @return acquisition
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACQUISITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "acquisition")

  public Acquisition getAcquisition() {
    return acquisition;
  }


  @JsonProperty(JSON_PROPERTY_ACQUISITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "acquisition")
  public void setAcquisition(Acquisition acquisition) {
    this.acquisition = acquisition;
  }


  public BasePGRFA collection(Collection collection) {
    
    this.collection = collection;
    return this;
  }

   /**
   * Get collection
   * @return collection
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COLLECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "collection")

  public Collection getCollection() {
    return collection;
  }


  @JsonProperty(JSON_PROPERTY_COLLECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "collection")
  public void setCollection(Collection collection) {
    this.collection = collection;
  }


  public BasePGRFA breeding(Breeding breeding) {
    
    this.breeding = breeding;
    return this;
  }

   /**
   * Get breeding
   * @return breeding
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BREEDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "breeding")

  public Breeding getBreeding() {
    return breeding;
  }


  @JsonProperty(JSON_PROPERTY_BREEDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "breeding")
  public void setBreeding(Breeding breeding) {
    this.breeding = breeding;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BasePGRFA basePGRFA = (BasePGRFA) o;
    return Objects.equals(this.username, basePGRFA.username) &&
        Objects.equals(this.password, basePGRFA.password) &&
        Objects.equals(this.location, basePGRFA.location) &&
        Objects.equals(this.sampledoi, basePGRFA.sampledoi) &&
        Objects.equals(this.sampleid, basePGRFA.sampleid) &&
        Objects.equals(this.date, basePGRFA.date) &&
        Objects.equals(this.method, basePGRFA.method) &&
        Objects.equals(this.genus, basePGRFA.genus) &&
        Objects.equals(this.cropnames, basePGRFA.cropnames) &&
        Objects.equals(this.targets, basePGRFA.targets) &&
        Objects.equals(this.progdoi, basePGRFA.progdoi) &&
        Objects.equals(this.biostatus, basePGRFA.biostatus) &&
        Objects.equals(this.species, basePGRFA.species) &&
        Objects.equals(this.spauth, basePGRFA.spauth) &&
        Objects.equals(this.subtaxa, basePGRFA.subtaxa) &&
        Objects.equals(this.stauth, basePGRFA.stauth) &&
        Objects.equals(this.names, basePGRFA.names) &&
        Objects.equals(this.ids, basePGRFA.ids) &&
        Objects.equals(this.mlsstatus, basePGRFA.mlsstatus) &&
        Objects.equals(this.historical, basePGRFA.historical) &&
        Objects.equals(this.acquisition, basePGRFA.acquisition) &&
        Objects.equals(this.collection, basePGRFA.collection) &&
        Objects.equals(this.breeding, basePGRFA.breeding);
  }

  @Override
  public int hashCode() {
    return Objects.hash(username, password, location, sampledoi, sampleid, date, method, genus, cropnames, targets, progdoi, biostatus, species, spauth, subtaxa, stauth, names, ids, mlsstatus, historical, acquisition, collection, breeding);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BasePGRFA {\n");
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    sampledoi: ").append(toIndentedString(sampledoi)).append("\n");
    sb.append("    sampleid: ").append(toIndentedString(sampleid)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    method: ").append(toIndentedString(method)).append("\n");
    sb.append("    genus: ").append(toIndentedString(genus)).append("\n");
    sb.append("    cropnames: ").append(toIndentedString(cropnames)).append("\n");
    sb.append("    targets: ").append(toIndentedString(targets)).append("\n");
    sb.append("    progdoi: ").append(toIndentedString(progdoi)).append("\n");
    sb.append("    biostatus: ").append(toIndentedString(biostatus)).append("\n");
    sb.append("    species: ").append(toIndentedString(species)).append("\n");
    sb.append("    spauth: ").append(toIndentedString(spauth)).append("\n");
    sb.append("    subtaxa: ").append(toIndentedString(subtaxa)).append("\n");
    sb.append("    stauth: ").append(toIndentedString(stauth)).append("\n");
    sb.append("    names: ").append(toIndentedString(names)).append("\n");
    sb.append("    ids: ").append(toIndentedString(ids)).append("\n");
    sb.append("    mlsstatus: ").append(toIndentedString(mlsstatus)).append("\n");
    sb.append("    historical: ").append(toIndentedString(historical)).append("\n");
    sb.append("    acquisition: ").append(toIndentedString(acquisition)).append("\n");
    sb.append("    collection: ").append(toIndentedString(collection)).append("\n");
    sb.append("    breeding: ").append(toIndentedString(breeding)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

