/*
 * Global Information System API Client
 * Genesys API client to the Global Information System (GLIS) for PGRFA  [https://glis.planttreaty.org](https://glis.planttreaty.org).
 *
 * The version of the OpenAPI document: 1.1-SNAPSHOT
 * Contact: helpdesk@genesys-pgr.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.genesys.glis.v1.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.swagger.annotations.ApiModelProperty;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Collection
 */
@JsonPropertyOrder({
  Collection.JSON_PROPERTY_COLLECTORS,
  Collection.JSON_PROPERTY_SAMPLEID,
  Collection.JSON_PROPERTY_MISSID,
  Collection.JSON_PROPERTY_SITE,
  Collection.JSON_PROPERTY_LAT,
  Collection.JSON_PROPERTY_LON,
  Collection.JSON_PROPERTY_UNCERT,
  Collection.JSON_PROPERTY_DATUM,
  Collection.JSON_PROPERTY_GEOREF,
  Collection.JSON_PROPERTY_ELEVATION,
  Collection.JSON_PROPERTY_DATE,
  Collection.JSON_PROPERTY_SOURCE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
@XmlRootElement(name = "Collection")
@XmlAccessorType(XmlAccessType.FIELD)
@JacksonXmlRootElement(localName = "Collection")
public class Collection {
  public static final String JSON_PROPERTY_COLLECTORS = "collectors";
  // Is a container wrapped=true
  // items.name=collectors items.baseName=collectors items.xmlName= items.xmlNamespace=
  // items.example= items.type=Collector
  @XmlElement(name = "collector")
  @XmlElementWrapper(name = "collectors")
  private List<Collector> collectors = null;

  public static final String JSON_PROPERTY_SAMPLEID = "sampleid";
  @XmlElement(name = "sampleid")
  private String sampleid;

  public static final String JSON_PROPERTY_MISSID = "missid";
  @XmlElement(name = "missid")
  private String missid;

  public static final String JSON_PROPERTY_SITE = "site";
  @XmlElement(name = "site")
  private String site;

  public static final String JSON_PROPERTY_LAT = "lat";
  @XmlElement(name = "lat")
  private String lat;

  public static final String JSON_PROPERTY_LON = "lon";
  @XmlElement(name = "lon")
  private String lon;

  public static final String JSON_PROPERTY_UNCERT = "uncert";
  @XmlElement(name = "uncert")
  private String uncert;

  public static final String JSON_PROPERTY_DATUM = "datum";
  @XmlElement(name = "datum")
  private String datum;

  public static final String JSON_PROPERTY_GEOREF = "georef";
  @XmlElement(name = "georef")
  private String georef;

  public static final String JSON_PROPERTY_ELEVATION = "elevation";
  @XmlElement(name = "elevation")
  private Integer elevation;

  public static final String JSON_PROPERTY_DATE = "date";
  @XmlElement(name = "date")
  private String date;

  public static final String JSON_PROPERTY_SOURCE = "source";
  @XmlElement(name = "source")
  private String source;

  public Collection() { 
  }

  public Collection collectors(List<Collector> collectors) {
    
    this.collectors = collectors;
    return this;
  }

  public Collection addCollectorsItem(Collector collectorsItem) {
    if (this.collectors == null) {
      this.collectors = new ArrayList<>();
    }
    this.collectors.add(collectorsItem);
    return this;
  }

   /**
   * Get collectors
   * @return collectors
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COLLECTORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  // items.xmlName=
  @JacksonXmlElementWrapper(useWrapping = true, localName = "collectors")

  public List<Collector> getCollectors() {
    return collectors;
  }


  @JsonProperty(JSON_PROPERTY_COLLECTORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  // items.xmlName=
  @JacksonXmlElementWrapper(useWrapping = true, localName = "collectors")
  public void setCollectors(List<Collector> collectors) {
    this.collectors = collectors;
  }


  public Collection sampleid(String sampleid) {
    
    this.sampleid = sampleid;
    return this;
  }

   /**
   * Get sampleid
   * @return sampleid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SAMPLEID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "sampleid")

  public String getSampleid() {
    return sampleid;
  }


  @JsonProperty(JSON_PROPERTY_SAMPLEID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "sampleid")
  public void setSampleid(String sampleid) {
    this.sampleid = sampleid;
  }


  public Collection missid(String missid) {
    
    this.missid = missid;
    return this;
  }

   /**
   * Get missid
   * @return missid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MISSID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "missid")

  public String getMissid() {
    return missid;
  }


  @JsonProperty(JSON_PROPERTY_MISSID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "missid")
  public void setMissid(String missid) {
    this.missid = missid;
  }


  public Collection site(String site) {
    
    this.site = site;
    return this;
  }

   /**
   * Get site
   * @return site
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "site")

  public String getSite() {
    return site;
  }


  @JsonProperty(JSON_PROPERTY_SITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "site")
  public void setSite(String site) {
    this.site = site;
  }


  public Collection lat(String lat) {
    
    this.lat = lat;
    return this;
  }

   /**
   * Get lat
   * @return lat
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "lat")

  public String getLat() {
    return lat;
  }


  @JsonProperty(JSON_PROPERTY_LAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "lat")
  public void setLat(String lat) {
    this.lat = lat;
  }


  public Collection lon(String lon) {
    
    this.lon = lon;
    return this;
  }

   /**
   * Get lon
   * @return lon
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "lon")

  public String getLon() {
    return lon;
  }


  @JsonProperty(JSON_PROPERTY_LON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "lon")
  public void setLon(String lon) {
    this.lon = lon;
  }


  public Collection uncert(String uncert) {
    
    this.uncert = uncert;
    return this;
  }

   /**
   * Get uncert
   * @return uncert
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UNCERT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "uncert")

  public String getUncert() {
    return uncert;
  }


  @JsonProperty(JSON_PROPERTY_UNCERT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "uncert")
  public void setUncert(String uncert) {
    this.uncert = uncert;
  }


  public Collection datum(String datum) {
    
    this.datum = datum;
    return this;
  }

   /**
   * Get datum
   * @return datum
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATUM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "datum")

  public String getDatum() {
    return datum;
  }


  @JsonProperty(JSON_PROPERTY_DATUM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "datum")
  public void setDatum(String datum) {
    this.datum = datum;
  }


  public Collection georef(String georef) {
    
    this.georef = georef;
    return this;
  }

   /**
   * Get georef
   * @return georef
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_GEOREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "georef")

  public String getGeoref() {
    return georef;
  }


  @JsonProperty(JSON_PROPERTY_GEOREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "georef")
  public void setGeoref(String georef) {
    this.georef = georef;
  }


  public Collection elevation(Integer elevation) {
    
    this.elevation = elevation;
    return this;
  }

   /**
   * Elevation of collecting site in metres above sea level.
   * @return elevation
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Elevation of collecting site in metres above sea level.")
  @JsonProperty(JSON_PROPERTY_ELEVATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "elevation")

  public Integer getElevation() {
    return elevation;
  }


  @JsonProperty(JSON_PROPERTY_ELEVATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "elevation")
  public void setElevation(Integer elevation) {
    this.elevation = elevation;
  }


  public Collection date(String date) {
    
    this.date = date;
    return this;
  }

   /**
   * Date on which the PGRFA was collected. Date fragments (YYYY-MM and YYYY) are also accepted.
   * @return date
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Date on which the PGRFA was collected. Date fragments (YYYY-MM and YYYY) are also accepted.")
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "date")

  public String getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "date")
  public void setDate(String date) {
    this.date = date;
  }


  public Collection source(String source) {
    
    this.source = source;
    return this;
  }

   /**
   * Code of the nature of the location where the PGRFA was collected.
   * @return source
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Code of the nature of the location where the PGRFA was collected.")
  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "source")

  public String getSource() {
    return source;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "source")
  public void setSource(String source) {
    this.source = source;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Collection collection = (Collection) o;
    return Objects.equals(this.collectors, collection.collectors) &&
        Objects.equals(this.sampleid, collection.sampleid) &&
        Objects.equals(this.missid, collection.missid) &&
        Objects.equals(this.site, collection.site) &&
        Objects.equals(this.lat, collection.lat) &&
        Objects.equals(this.lon, collection.lon) &&
        Objects.equals(this.uncert, collection.uncert) &&
        Objects.equals(this.datum, collection.datum) &&
        Objects.equals(this.georef, collection.georef) &&
        Objects.equals(this.elevation, collection.elevation) &&
        Objects.equals(this.date, collection.date) &&
        Objects.equals(this.source, collection.source);
  }

  @Override
  public int hashCode() {
    return Objects.hash(collectors, sampleid, missid, site, lat, lon, uncert, datum, georef, elevation, date, source);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Collection {\n");
    sb.append("    collectors: ").append(toIndentedString(collectors)).append("\n");
    sb.append("    sampleid: ").append(toIndentedString(sampleid)).append("\n");
    sb.append("    missid: ").append(toIndentedString(missid)).append("\n");
    sb.append("    site: ").append(toIndentedString(site)).append("\n");
    sb.append("    lat: ").append(toIndentedString(lat)).append("\n");
    sb.append("    lon: ").append(toIndentedString(lon)).append("\n");
    sb.append("    uncert: ").append(toIndentedString(uncert)).append("\n");
    sb.append("    datum: ").append(toIndentedString(datum)).append("\n");
    sb.append("    georef: ").append(toIndentedString(georef)).append("\n");
    sb.append("    elevation: ").append(toIndentedString(elevation)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

