/*
 * Global Information System API Client
 * Genesys API client to the Global Information System (GLIS) for PGRFA  [https://glis.planttreaty.org](https://glis.planttreaty.org).
 *
 * The version of the OpenAPI document: 1.1-SNAPSHOT
 * Contact: helpdesk@genesys-pgr.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.genesys.glis.v1.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.swagger.annotations.ApiModelProperty;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * SMTADocumentPDFRequest
 */
@JsonPropertyOrder({
  SMTADocumentPDFRequest.JSON_PROPERTY_SYMBOL,
  SMTADocumentPDFRequest.JSON_PROPERTY_DATE,
  SMTADocumentPDFRequest.JSON_PROPERTY_TYPE,
  SMTADocumentPDFRequest.JSON_PROPERTY_LANGUAGE,
  SMTADocumentPDFRequest.JSON_PROPERTY_PROVIDER_P_I_D,
  SMTADocumentPDFRequest.JSON_PROPERTY_RECIPIENT,
  SMTADocumentPDFRequest.JSON_PROPERTY_DATA_URL,
  SMTADocumentPDFRequest.JSON_PROPERTY_ANNEX1
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
@XmlRootElement(name = "smta")
@XmlAccessorType(XmlAccessType.FIELD)
@JacksonXmlRootElement(localName = "smta")
public class SMTADocumentPDFRequest {
  public static final String JSON_PROPERTY_SYMBOL = "symbol";
  @XmlElement(name = "symbol")
  private String symbol;

  public static final String JSON_PROPERTY_DATE = "date";
  @XmlElement(name = "date")
  private String date;

  public static final String JSON_PROPERTY_TYPE = "type";
  @XmlElement(name = "type")
  private SMTASignatureType type;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  @XmlElement(name = "language")
  private String language;

  public static final String JSON_PROPERTY_PROVIDER_P_I_D = "providerPID";
  @XmlElement(name = "providerPID")
  private String providerPID;

  public static final String JSON_PROPERTY_RECIPIENT = "recipient";
  @XmlElement(name = "recipient")
  private SMTADocumentPDFRequestRecipient recipient;

  public static final String JSON_PROPERTY_DATA_URL = "dataUrl";
  @XmlElement(name = "dataUrl")
  private URI dataUrl;

  public static final String JSON_PROPERTY_ANNEX1 = "annex1";
  // Is a container wrapped=true
  // items.name=annex1 items.baseName=annex1 items.xmlName= items.xmlNamespace=
  // items.example= items.type=SMTAMaterial
  @XmlElement(name = "material")
  @XmlElementWrapper(name = "annex1")
  private List<SMTAMaterial> annex1 = null;

  public SMTADocumentPDFRequest() { 
  }

  public SMTADocumentPDFRequest symbol(String symbol) {
    
    this.symbol = symbol;
    return this;
  }

   /**
   * SMTA symbol as assigned by the Provider. Two different SMTAs from the same Provider cannot have the same symbol.
   * @return symbol
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "SMTA symbol as assigned by the Provider. Two different SMTAs from the same Provider cannot have the same symbol.")
  @JsonProperty(JSON_PROPERTY_SYMBOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "symbol")

  public String getSymbol() {
    return symbol;
  }


  @JsonProperty(JSON_PROPERTY_SYMBOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "symbol")
  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public SMTADocumentPDFRequest date(String date) {
    
    this.date = date;
    return this;
  }

   /**
   * Date of acceptance for shrink-wrap SMTAs, date of shipment for click-wrap SMTAs or date of final signature for signed SMTAs.
   * @return date
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Date of acceptance for shrink-wrap SMTAs, date of shipment for click-wrap SMTAs or date of final signature for signed SMTAs.")
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "date")

  public String getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "date")
  public void setDate(String date) {
    this.date = date;
  }


  public SMTADocumentPDFRequest type(SMTASignatureType type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "type")

  public SMTASignatureType getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "type")
  public void setType(SMTASignatureType type) {
    this.type = type;
  }


  public SMTADocumentPDFRequest language(String language) {
    
    this.language = language;
    return this;
  }

   /**
   * ISO-2 code for the SMTA language as follows ar&#x3D;arabic, en&#x3D;english, es&#x3D;spanish, fr&#x3D;french, ru&#x3D;russian, zh&#x3D;chinese.
   * @return language
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ISO-2 code for the SMTA language as follows ar=arabic, en=english, es=spanish, fr=french, ru=russian, zh=chinese.")
  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "language")

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "language")
  public void setLanguage(String language) {
    this.language = language;
  }


  public SMTADocumentPDFRequest providerPID(String providerPID) {
    
    this.providerPID = providerPID;
    return this;
  }

   /**
   * Provider or Recipient PID. Recipient PID is optional, but should be provided if known. Provider PID is mandatory. Only new PIDs will be accepted (i.e. those of the form 00AA00).
   * @return providerPID
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Provider or Recipient PID. Recipient PID is optional, but should be provided if known. Provider PID is mandatory. Only new PIDs will be accepted (i.e. those of the form 00AA00).")
  @JsonProperty(JSON_PROPERTY_PROVIDER_P_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "providerPID")

  public String getProviderPID() {
    return providerPID;
  }


  @JsonProperty(JSON_PROPERTY_PROVIDER_P_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "providerPID")
  public void setProviderPID(String providerPID) {
    this.providerPID = providerPID;
  }


  public SMTADocumentPDFRequest recipient(SMTADocumentPDFRequestRecipient recipient) {
    
    this.recipient = recipient;
    return this;
  }

   /**
   * Get recipient
   * @return recipient
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RECIPIENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "recipient")

  public SMTADocumentPDFRequestRecipient getRecipient() {
    return recipient;
  }


  @JsonProperty(JSON_PROPERTY_RECIPIENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "recipient")
  public void setRecipient(SMTADocumentPDFRequestRecipient recipient) {
    this.recipient = recipient;
  }


  public SMTADocumentPDFRequest dataUrl(URI dataUrl) {
    
    this.dataUrl = dataUrl;
    return this;
  }

   /**
   * The URL where to access information about the material.
   * @return dataUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The URL where to access information about the material.")
  @JsonProperty(JSON_PROPERTY_DATA_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "dataUrl")

  public URI getDataUrl() {
    return dataUrl;
  }


  @JsonProperty(JSON_PROPERTY_DATA_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  @JacksonXmlProperty(localName = "dataUrl")
  public void setDataUrl(URI dataUrl) {
    this.dataUrl = dataUrl;
  }


  public SMTADocumentPDFRequest annex1(List<SMTAMaterial> annex1) {
    
    this.annex1 = annex1;
    return this;
  }

  public SMTADocumentPDFRequest addAnnex1Item(SMTAMaterial annex1Item) {
    if (this.annex1 == null) {
      this.annex1 = new ArrayList<>();
    }
    this.annex1.add(annex1Item);
    return this;
  }

   /**
   * Get annex1
   * @return annex1
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ANNEX1)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  // items.xmlName=
  @JacksonXmlElementWrapper(useWrapping = true, localName = "annex1")

  public List<SMTAMaterial> getAnnex1() {
    return annex1;
  }


  @JsonProperty(JSON_PROPERTY_ANNEX1)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  // items.xmlName=
  @JacksonXmlElementWrapper(useWrapping = true, localName = "annex1")
  public void setAnnex1(List<SMTAMaterial> annex1) {
    this.annex1 = annex1;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SMTADocumentPDFRequest smTADocumentPDFRequest = (SMTADocumentPDFRequest) o;
    return Objects.equals(this.symbol, smTADocumentPDFRequest.symbol) &&
        Objects.equals(this.date, smTADocumentPDFRequest.date) &&
        Objects.equals(this.type, smTADocumentPDFRequest.type) &&
        Objects.equals(this.language, smTADocumentPDFRequest.language) &&
        Objects.equals(this.providerPID, smTADocumentPDFRequest.providerPID) &&
        Objects.equals(this.recipient, smTADocumentPDFRequest.recipient) &&
        Objects.equals(this.dataUrl, smTADocumentPDFRequest.dataUrl) &&
        Objects.equals(this.annex1, smTADocumentPDFRequest.annex1);
  }

  @Override
  public int hashCode() {
    return Objects.hash(symbol, date, type, language, providerPID, recipient, dataUrl, annex1);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SMTADocumentPDFRequest {\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    providerPID: ").append(toIndentedString(providerPID)).append("\n");
    sb.append("    recipient: ").append(toIndentedString(recipient)).append("\n");
    sb.append("    dataUrl: ").append(toIndentedString(dataUrl)).append("\n");
    sb.append("    annex1: ").append(toIndentedString(annex1)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

