/*
 * Copyright 2015 Global Crop Diversity Trust
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys2.gringlobal.taxonomy.model;

import java.io.Serializable;
import java.util.Date;

import com.opencsv.bean.CsvBind;

/**
 * "TAXONOMY_GENUS_ID", "CURRENT_TAXONOMY_GENUS_ID", "TAXONOMY_FAMILY_ID", "QUALIFYING_CODE", "IS_HYBRID", "GENUS_NAME", "GENUS_AUTHORITY", "SUBGENUS_NAME", "SECTION_NAME",
 * "SUBSECTION_NAME", "SERIES_NAME", "SUBSERIES_NAME", "NOTE", "CREATED_DATE", "CREATED_BY", "MODIFIED_DATE", "MODIFIED_BY", "OWNED_DATE", "OWNED_BY"
 * 
 * TODO Upgrade to opencsv 3.8 with @CsvDate annotation when available
 */
public class GenusRow implements Serializable {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 4556535779370019537L;

	/** The genus id. */
	@CsvBind
	Long genusId;
	
	/** The current genus id. */
	@CsvBind
	Long currentGenusId;
	
	/** The family id. */
	@CsvBind
	Long familyId;
	
	/** The qualifying code. */
	@CsvBind
	String qualifyingCode;
	
	/** The hybrid. */
	@CsvBind
	private Boolean hybrid;

	/** The genus name. */
	@CsvBind
	private String genusName;
	
	/** The genus authority. */
	@CsvBind
	private String genusAuthority;
	
	/** The sub genus name. */
	@CsvBind
	private String subGenusName;
	
	/** The section name. */
	@CsvBind
	private String sectionName;
	
	/** The sub section name. */
	@CsvBind
	private String subSectionName;
	
	/** The series name. */
	@CsvBind
	private String seriesName;
	
	/** The sub series name. */
	@CsvBind
	private String subSeriesName;
	
	/** The note. */
	@CsvBind
	private String note;
	
	/** The created date. */
	@CsvBind
	private Date createdDate;
	
	/** The created by id. */
	@CsvBind
	private Long createdById;
	
	/** The modified date. */
	@CsvBind
	private Date modifiedDate;
	
	/** The modified by id. */
	@CsvBind
	private Long modifiedById;
	
	/** The owned date. */
	@CsvBind
	private Date ownedDate;
	
	/** The owned by id. */
	@CsvBind
	private Long ownedById;

	/**
	 * Gets the genus id.
	 *
	 * @return the genus id
	 */
	public Long getGenusId() {
		return genusId;
	}

	/**
	 * Sets the genus id.
	 *
	 * @param genusId the new genus id
	 */
	public void setGenusId(Long genusId) {
		this.genusId = genusId;
	}

	/**
	 * Gets the current genus id.
	 *
	 * @return the current genus id
	 */
	public Long getCurrentGenusId() {
		return currentGenusId;
	}

	/**
	 * Sets the current genus id.
	 *
	 * @param currentGenusId the new current genus id
	 */
	public void setCurrentGenusId(Long currentGenusId) {
		this.currentGenusId = currentGenusId;
	}

	/**
	 * Gets the family id.
	 *
	 * @return the family id
	 */
	public Long getFamilyId() {
		return familyId;
	}

	/**
	 * Sets the family id.
	 *
	 * @param familyId the new family id
	 */
	public void setFamilyId(Long familyId) {
		this.familyId = familyId;
	}

	/**
	 * Gets the qualifying code.
	 *
	 * @return the qualifying code
	 */
	public String getQualifyingCode() {
		return qualifyingCode;
	}

	/**
	 * Sets the qualifying code.
	 *
	 * @param qualifyingCode the new qualifying code
	 */
	public void setQualifyingCode(String qualifyingCode) {
		this.qualifyingCode = qualifyingCode;
	}

	/**
	 * Gets the hybrid.
	 *
	 * @return the hybrid
	 */
	public Boolean getHybrid() {
		return hybrid;
	}

	/**
	 * Sets the hybrid.
	 *
	 * @param hybrid the new hybrid
	 */
	public void setHybrid(Boolean hybrid) {
		this.hybrid = hybrid;
	}

	/**
	 * Gets the genus name.
	 *
	 * @return the genus name
	 */
	public String getGenusName() {
		return genusName;
	}

	/**
	 * Sets the genus name.
	 *
	 * @param genusName the new genus name
	 */
	public void setGenusName(String genusName) {
		this.genusName = genusName;
	}

	/**
	 * Gets the genus authority.
	 *
	 * @return the genus authority
	 */
	public String getGenusAuthority() {
		return genusAuthority;
	}

	/**
	 * Sets the genus authority.
	 *
	 * @param genusAuthority the new genus authority
	 */
	public void setGenusAuthority(String genusAuthority) {
		this.genusAuthority = genusAuthority;
	}

	/**
	 * Gets the sub genus name.
	 *
	 * @return the sub genus name
	 */
	public String getSubGenusName() {
		return subGenusName;
	}

	/**
	 * Sets the sub genus name.
	 *
	 * @param subGenusName the new sub genus name
	 */
	public void setSubGenusName(String subGenusName) {
		this.subGenusName = subGenusName;
	}

	/**
	 * Gets the section name.
	 *
	 * @return the section name
	 */
	public String getSectionName() {
		return sectionName;
	}

	/**
	 * Sets the section name.
	 *
	 * @param sectionName the new section name
	 */
	public void setSectionName(String sectionName) {
		this.sectionName = sectionName;
	}

	/**
	 * Gets the sub section name.
	 *
	 * @return the sub section name
	 */
	public String getSubSectionName() {
		return subSectionName;
	}

	/**
	 * Sets the sub section name.
	 *
	 * @param subSectionName the new sub section name
	 */
	public void setSubSectionName(String subSectionName) {
		this.subSectionName = subSectionName;
	}

	/**
	 * Gets the series name.
	 *
	 * @return the series name
	 */
	public String getSeriesName() {
		return seriesName;
	}

	/**
	 * Sets the series name.
	 *
	 * @param seriesName the new series name
	 */
	public void setSeriesName(String seriesName) {
		this.seriesName = seriesName;
	}

	/**
	 * Gets the sub series name.
	 *
	 * @return the sub series name
	 */
	public String getSubSeriesName() {
		return subSeriesName;
	}

	/**
	 * Sets the sub series name.
	 *
	 * @param subSeriesName the new sub series name
	 */
	public void setSubSeriesName(String subSeriesName) {
		this.subSeriesName = subSeriesName;
	}

	/**
	 * Gets the note.
	 *
	 * @return the note
	 */
	public String getNote() {
		return note;
	}

	/**
	 * Sets the note.
	 *
	 * @param note the new note
	 */
	public void setNote(String note) {
		this.note = note;
	}

	/**
	 * Gets the created date.
	 *
	 * @return the createdDate
	 */
	public Date getCreatedDate() {
		return createdDate;
	}

	/**
	 * Sets the created date.
	 *
	 * @param createdDate the createdDate to set
	 */
	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	/**
	 * Gets the created by id.
	 *
	 * @return the createdById
	 */
	public Long getCreatedById() {
		return createdById;
	}

	/**
	 * Sets the created by id.
	 *
	 * @param createdById the createdById to set
	 */
	public void setCreatedById(Long createdById) {
		this.createdById = createdById;
	}

	/**
	 * Gets the modified date.
	 *
	 * @return the modifiedDate
	 */
	public Date getModifiedDate() {
		return modifiedDate;
	}

	/**
	 * Sets the modified date.
	 *
	 * @param modifiedDate the modifiedDate to set
	 */
	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	/**
	 * Gets the modified by id.
	 *
	 * @return the modifiedById
	 */
	public Long getModifiedById() {
		return modifiedById;
	}

	/**
	 * Sets the modified by id.
	 *
	 * @param modifiedById the modifiedById to set
	 */
	public void setModifiedById(Long modifiedById) {
		this.modifiedById = modifiedById;
	}

	/**
	 * Gets the owned date.
	 *
	 * @return the ownedDate
	 */
	public Date getOwnedDate() {
		return ownedDate;
	}

	/**
	 * Sets the owned date.
	 *
	 * @param ownedDate the ownedDate to set
	 */
	public void setOwnedDate(Date ownedDate) {
		this.ownedDate = ownedDate;
	}

	/**
	 * Gets the owned by id.
	 *
	 * @return the ownedById
	 */
	public Long getOwnedById() {
		return ownedById;
	}

	/**
	 * Sets the owned by id.
	 *
	 * @param ownedById the ownedById to set
	 */
	public void setOwnedById(Long ownedById) {
		this.ownedById = ownedById;
	}

	/**
	 * Is this genus record still current?.
	 *
	 * @return <code>true</code> when {@link #currentGenusId} equals {@link #genusId}
	 */
	public boolean isCurrent() {
		return genusId.equals(currentGenusId);
	}
}
