/*
 * Decompiled with CFR 0.152.
 */
package org.genesys2.gringlobal.taxonomy.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.genesys2.gringlobal.taxonomy.component.BestScore;
import org.genesys2.gringlobal.taxonomy.component.Suggestion;
import org.genesys2.gringlobal.taxonomy.component.TaxonomyDatabase;
import org.genesys2.gringlobal.taxonomy.component.TaxonomyException;
import org.genesys2.gringlobal.taxonomy.model.SpeciesRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryTaxonomyDatabase
implements TaxonomyDatabase {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryTaxonomyDatabase.class);
    private Map<String, List<Long>> genusIdLookup = new HashMap<String, List<Long>>();
    private Map<Long, List<SpeciesRow>> speciesLookup = new HashMap<Long, List<SpeciesRow>>();
    private int speciesRows;

    public void registerGenus(Long genusId, String genus) {
        if (!this.genusIdLookup.containsKey(genus)) {
            this.genusIdLookup.put(genus, new ArrayList(1));
        }
        this.genusIdLookup.get(genus).add(genusId);
        this.speciesLookup.put(genusId, new ArrayList(1));
    }

    public void registerSpecies(SpeciesRow speciesRow) throws TaxonomyException {
        List<SpeciesRow> genusSpecies = this.speciesLookup.get(speciesRow.getGenusId());
        if (genusSpecies == null) {
            throw new TaxonomyException("No genus with specified genusId");
        }
        genusSpecies.add(speciesRow);
        ++this.speciesRows;
    }

    public String toString() {
        return "InMemory Taxonomy Database: " + this.genusIdLookup.size() + " genera" + " and " + this.speciesRows + " species";
    }

    @Override
    public boolean containsGenus(String genus) {
        return this.genusIdLookup.containsKey(genus);
    }

    @Override
    public List<String> findSimilarGenus(String genus, int maxSize) {
        if (this.containsGenus(genus)) {
            LOG.trace("Database contains genus={}", (Object)genus);
            return Collections.emptyList();
        }
        BestScore bestScore = new BestScore();
        return ((Stream)this.genusIdLookup.keySet().parallelStream().map(candidate -> new Suggestion<String>((String)candidate, this.similarityScore(genus, (String)candidate, 100))).filter(scored -> scored.getScore() >= 0.0f && scored.getScore() < 99.0f).sequential()).peek(scored -> bestScore.update(scored.getScore())).sorted(Comparator.comparing(Suggestion::getScore)).filter(scored -> (double)scored.getScore() <= (double)bestScore.getBestScore() * 1.5).peek(InMemoryTaxonomyDatabase::print).map(Suggestion::getSuggestion).distinct().limit(maxSize).collect(Collectors.toList());
    }

    public static <T> void print(Suggestion<T> suggestion) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Score={} suggestion={}", (Object)Float.valueOf(suggestion.getScore()), suggestion.getSuggestion());
        }
    }

    public static void print(Object suggestion) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(suggestion == null ? "NULL" : suggestion.getClass() + "=" + suggestion.toString());
        }
    }

    protected List<SpeciesRow> getAllGenusSpecies(String genus) {
        if (!this.genusIdLookup.containsKey(genus)) {
            return Collections.emptyList();
        }
        return this.genusIdLookup.get(genus).stream().map(genusId -> this.speciesLookup.get(genusId)).reduce(new ArrayList(1), (all, genusSpecies) -> {
            all.addAll(genusSpecies);
            return all;
        });
    }

    @Override
    public boolean containsSpecies(String genus, String species) {
        LOG.trace("Does database contain genus={} species={}", (Object)genus, (Object)species);
        if (!this.genusIdLookup.containsKey(genus)) {
            return false;
        }
        return this.getAllGenusSpecies(genus).stream().anyMatch(speciesRow -> species.equals(speciesRow.getSpeciesName()));
    }

    @Override
    public List<String> findSimilarSpecies(String genus, String species, int maxSize) {
        LOG.debug("Searching similar species for genus={} species={}", (Object)genus, (Object)species);
        if ("Unknown".equals(genus)) {
            return Collections.emptyList();
        }
        List<Long> genusId = this.genusIdLookup.get(genus);
        if (genusId == null) {
            throw new UnsupportedOperationException("Genus does not exist in database. Genus=" + genus);
        }
        BestScore bestScore = new BestScore();
        return this.getAllGenusSpecies(genus).stream().map(SpeciesRow::getSpeciesName).distinct().map(candidate -> new Suggestion<String>((String)candidate, this.similarityScore(species, (String)candidate, 5))).filter(scored -> scored.getScore() >= 0.0f && scored.getScore() < 4.0f).sorted(Comparator.comparing(Suggestion::getScore)).peek(scored -> bestScore.update(scored.getScore())).filter(scored -> (double)scored.getScore() <= (double)bestScore.getBestScore() * 1.5).peek(InMemoryTaxonomyDatabase::print).map(Suggestion::getSuggestion).distinct().limit(maxSize).collect(Collectors.toList());
    }

    private float similarityScore(String original, String candidate, int threshold) {
        return StringUtils.getLevenshteinDistance((CharSequence)original.toLowerCase(), (CharSequence)candidate.toLowerCase(), (int)threshold);
    }

    @Override
    public String getSpeciesAuthority(String genus, String species) {
        List<Long> genusId = this.genusIdLookup.get(genus);
        if (genusId == null) {
            return null;
        }
        return this.getAllGenusSpecies(genus).stream().filter(speciesRow -> species.equals(speciesRow.getSpeciesName())).peek(speciesRow -> LOG.trace("Species authority {}", (Object)speciesRow.getSpeciesAuthority())).findFirst().map(speciesRow -> speciesRow.getSpeciesAuthority()).orElse(null);
    }
}

