/*
 * Decompiled with CFR 0.152.
 */
package org.genesys2.gringlobal.taxonomy.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.genesys2.gringlobal.taxonomy.component.TaxonomyDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxonomyChecker {
    private static final Logger LOG = LoggerFactory.getLogger(TaxonomyChecker.class);
    private TaxonomyDatabase database;

    public void setTaxonomyDatabase(TaxonomyDatabase database) {
        this.database = database;
    }

    public List<String> suggestGenus(String genus, int maxSize) {
        if (StringUtils.isBlank((CharSequence)genus) || StringUtils.equals((CharSequence)"Unknown", (CharSequence)genus)) {
            return Arrays.asList("Unknown");
        }
        if (this.database.containsGenus(genus)) {
            LOG.debug("Database contains genus={}", (Object)genus);
            return Collections.emptyList();
        }
        LOG.debug("Database does not contain genus={}", (Object)genus);
        return this.database.findSimilarGenus(genus, maxSize);
    }

    public List<String> suggestSpecies(String genus, String species, int maxSize) {
        LOG.debug("Suggesting species for genus={} species={}", (Object)genus, (Object)species);
        if (this.database.containsSpecies(genus, species)) {
            return Collections.emptyList();
        }
        if (this.database.containsGenus(genus)) {
            LOG.debug("Database contains genus={}", (Object)genus);
            return this.database.findSimilarSpecies(genus, species, maxSize);
        }
        LOG.debug("Database does not contain genus={}", (Object)genus);
        ArrayList<String> suggestions = new ArrayList<String>(0);
        for (String suggestedGenus : this.suggestGenus(genus, 2)) {
            LOG.debug("Suggesting with suggested genus={}", (Object)suggestedGenus);
            suggestions.addAll(this.database.findSimilarSpecies(suggestedGenus, species, 2).stream().map(suggestion -> suggestedGenus.equalsIgnoreCase(genus) ? suggestion : "(" + suggestedGenus + ") " + suggestion).collect(Collectors.toList()));
        }
        return suggestions;
    }

    public String getSpeciesAuthority(String genus, String species) {
        if (!this.database.containsSpecies(genus, species)) {
            return null;
        }
        return this.database.getSpeciesAuthority(genus, species);
    }
}

