/*
 * Decompiled with CFR 0.152.
 */
package org.genesys2.gringlobal.taxonomy.component;

import com.opencsv.CSVParser;
import com.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.genesys2.gringlobal.taxonomy.model.GenusRow;
import org.genesys2.gringlobal.taxonomy.model.SpeciesRow;

public class TaxonomyReader {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static CSVReader openCsvReader(Reader reader, int startAt) {
        CSVReader csvReader = new CSVReader((Reader)new BufferedReader(reader), startAt, new CSVParser('\t', '\"', '\u0000', false, false, true){

            protected String[] parseLine(String nextLine, boolean multi) throws IOException {
                String[] res = super.parseLine(nextLine, multi);
                if (res != null) {
                    for (int i = 0; i < res.length; ++i) {
                        if (!"\\N".equals(res[i])) continue;
                        res[i] = null;
                    }
                }
                return res;
            }
        });
        return csvReader;
    }

    public static GenusRow toGenus(String[] row) throws ParseException {
        if (row == null || row.length == 0) {
            return null;
        }
        GenusRow genusRow = new GenusRow();
        genusRow.setGenusId(TaxonomyReader.toLong(row[0]));
        genusRow.setCurrentGenusId(TaxonomyReader.toLong(row[1]));
        genusRow.setFamilyId(TaxonomyReader.toLong(row[2]));
        genusRow.setQualifyingCode(row[3]);
        genusRow.setHybrid(TaxonomyReader.toBoolean(row[4]));
        genusRow.setGenusName(row[5]);
        genusRow.setGenusAuthority(row[6]);
        genusRow.setSubGenusName(row[7]);
        genusRow.setSectionName(row[8]);
        genusRow.setSubSectionName(row[9]);
        genusRow.setSeriesName(row[10]);
        genusRow.setSubSeriesName(row[11]);
        genusRow.setNote(row[12]);
        genusRow.setCreatedDate(TaxonomyReader.toDate(row[13]));
        genusRow.setCreatedById(TaxonomyReader.toLong(row[14]));
        genusRow.setModifiedDate(TaxonomyReader.toDate(row[15]));
        genusRow.setModifiedById(TaxonomyReader.toLong(row[16]));
        genusRow.setOwnedDate(TaxonomyReader.toDate(row[17]));
        genusRow.setOwnedById(TaxonomyReader.toLong(row[18]));
        return genusRow;
    }

    public static SpeciesRow toSpecies(String[] row) throws ParseException {
        if (row == null || row.length == 0) {
            return null;
        }
        SpeciesRow speciesRow = new SpeciesRow();
        speciesRow.setSpeciesId(TaxonomyReader.toLong(row[0]));
        speciesRow.setCurrentSpeciesId(TaxonomyReader.toLong(row[1]));
        speciesRow.setNomenNumber(TaxonomyReader.toLong(row[2]));
        speciesRow.setSpecificHybrid(TaxonomyReader.toBoolean(row[3]));
        speciesRow.setSpeciesName(row[4]);
        speciesRow.setSpeciesAuthority(row[5]);
        speciesRow.setSubspecificHybrid(TaxonomyReader.toBoolean(row[6]));
        speciesRow.setSubspeciesName(row[7]);
        speciesRow.setSubspeciesAuthority(row[8]);
        speciesRow.setVarietalHybrid(TaxonomyReader.toBoolean(row[9]));
        speciesRow.setVarietyName(row[10]);
        speciesRow.setVarietyAuthority(row[11]);
        speciesRow.setSubvarietalHybrid(TaxonomyReader.toBoolean(row[12]));
        speciesRow.setSubvarietyName(row[13]);
        speciesRow.setSubvarietyAuthority(row[14]);
        speciesRow.setFormaHybrid(TaxonomyReader.toBoolean(row[15]));
        speciesRow.setFormaRankType(row[16]);
        speciesRow.setFormaName(row[17]);
        speciesRow.setFormaAuthority(row[18]);
        speciesRow.setGenusId(TaxonomyReader.toLong(row[19]));
        speciesRow.setPrioritySite1(row[20]);
        speciesRow.setPrioritySite2(row[21]);
        speciesRow.setCurator1Id(TaxonomyReader.toLong(row[22]));
        speciesRow.setCurator2Id(TaxonomyReader.toLong(row[23]));
        speciesRow.setRestrictionCode(row[24]);
        speciesRow.setLifeFormCode(row[25]);
        speciesRow.setCommonFertilizationCode(row[26]);
        speciesRow.setNamePending(TaxonomyReader.toBoolean(row[27]));
        speciesRow.setSynonymCode(row[28]);
        speciesRow.setVerifierId(TaxonomyReader.toLong(row[29]));
        speciesRow.setNameVerifiedDate(TaxonomyReader.toDate(row[30]));
        speciesRow.setName(row[31]);
        speciesRow.setNameAuthority(row[32]);
        speciesRow.setProtologue(row[33]);
        speciesRow.setNote(row[34]);
        speciesRow.setSiteNote(row[35]);
        speciesRow.setAlternateName(row[36]);
        speciesRow.setCreatedDate(TaxonomyReader.toDate(row[37]));
        speciesRow.setCreatedById(row[38]);
        speciesRow.setModifiedDate(TaxonomyReader.toDate(row[39]));
        speciesRow.setModifiedById(row[40]);
        speciesRow.setOwnedDate(TaxonomyReader.toDate(row[41]));
        speciesRow.setOwnedById(row[42]);
        return speciesRow;
    }

    public static Date toDate(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        return sdf.parse(string);
    }

    private static Boolean toBoolean(String string) {
        if (string == null) {
            return null;
        }
        return "Y".equals(string);
    }

    private static Long toLong(String string) {
        if (string == null) {
            return null;
        }
        return Long.parseLong(string);
    }
}

