/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.taxonomy.checker;

import java.util.Arrays;
import org.apache.commons.text.similarity.LevenshteinDistance;

public class StringSimilarity {
    public static double diceCoefficientOptimized(String s, String t) {
        if (s == null || t == null) {
            return 0.0;
        }
        if (s.equals(t)) {
            return 1.0;
        }
        if (s.length() < 2 || t.length() < 2) {
            return 0.0;
        }
        int n = s.length() - 1;
        int[] sPairs = new int[n];
        for (int i = 0; i <= n; ++i) {
            if (i == 0) {
                sPairs[i] = s.charAt(i) << 16;
                continue;
            }
            if (i == n) {
                int n2 = i - 1;
                sPairs[n2] = sPairs[n2] | s.charAt(i);
                continue;
            }
            int n3 = i - 1;
            int n4 = sPairs[n3] | s.charAt(i);
            sPairs[n3] = n4;
            sPairs[i] = n4 << 16;
        }
        int m = t.length() - 1;
        int[] tPairs = new int[m];
        for (int i = 0; i <= m; ++i) {
            if (i == 0) {
                tPairs[i] = t.charAt(i) << 16;
                continue;
            }
            if (i == m) {
                int n5 = i - 1;
                tPairs[n5] = tPairs[n5] | t.charAt(i);
                continue;
            }
            int n6 = i - 1;
            int n7 = tPairs[n6] | t.charAt(i);
            tPairs[n6] = n7;
            tPairs[i] = n7 << 16;
        }
        Arrays.sort(sPairs);
        Arrays.sort(tPairs);
        int matches = 0;
        int i = 0;
        int j = 0;
        while (i < n && j < m) {
            if (sPairs[i] == tPairs[j]) {
                matches += 2;
                ++i;
                ++j;
                continue;
            }
            if (sPairs[i] < tPairs[j]) {
                ++i;
                continue;
            }
            ++j;
        }
        return (double)matches / (double)(n + m);
    }

    public static double getLevenshteinCoefficient(String a, String b) {
        return 1.0 - 1.0 * (double)LevenshteinDistance.getDefaultInstance().apply((CharSequence)a, (CharSequence)b).intValue() / (double)Math.max(a.length(), b.length());
    }
}

