/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.taxonomy.checker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.genesys.taxonomy.checker.TaxonomyDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxonomyChecker {
    private static final String UNKNOWN_GENUS = "Unknown";
    private static final String[] UNKNOWN_GENUS_ALT = new String[]{"Unknown", "Unidentified"};
    private static final String UNKNOWN_SPECIES = "sp.";
    private static final String[] UNKNOWN_SPECIES_ALT = new String[]{"sp.", "spp."};
    private static final Logger LOG = LoggerFactory.getLogger(TaxonomyChecker.class);
    private TaxonomyDatabase database;

    public void setTaxonomyDatabase(TaxonomyDatabase database) {
        this.database = database;
    }

    public List<String> suggestGenus(String genus, int maxSize) {
        if (StringUtils.isBlank((CharSequence)genus) || ArrayUtils.contains((Object[])UNKNOWN_GENUS_ALT, (Object)genus)) {
            return Arrays.asList(UNKNOWN_GENUS);
        }
        if (this.database.containsGenus(genus)) {
            LOG.trace("Database contains genus={}", (Object)genus);
            return Arrays.asList(genus);
        }
        LOG.debug("Database does not contain genus={}", (Object)genus);
        return this.database.findSimilarGenus(genus, maxSize);
    }

    public List<String> suggestSpecies(String genus, String species, int maxSize) {
        LOG.debug("Suggesting species for genus={} species={}", (Object)genus, (Object)species);
        if (StringUtils.isBlank((CharSequence)species)) {
            return Arrays.asList(UNKNOWN_SPECIES);
        }
        if (ArrayUtils.contains((Object[])UNKNOWN_SPECIES_ALT, (Object)species)) {
            return List.of(species);
        }
        if (ArrayUtils.contains((Object[])UNKNOWN_GENUS_ALT, (Object)genus)) {
            return Arrays.asList(UNKNOWN_SPECIES);
        }
        if (this.database.containsSpecies(genus, species)) {
            return Arrays.asList(species);
        }
        if (this.database.containsGenus(genus)) {
            LOG.debug("Database contains genus={}", (Object)genus);
            return this.database.findSimilarSpecies(genus, species, maxSize);
        }
        LOG.debug("Database does not contain genus={}", (Object)genus);
        ArrayList<String> suggestions = new ArrayList<String>(0);
        for (String suggestedGenus : this.suggestGenus(genus, 2)) {
            LOG.debug("Suggesting with suggested genus={}", (Object)suggestedGenus);
            suggestions.addAll(this.database.findSimilarSpecies(suggestedGenus, species, 2).stream().map(suggestion -> suggestedGenus.equalsIgnoreCase(genus) ? suggestion : "(" + suggestedGenus + ") " + suggestion).collect(Collectors.toList()));
        }
        return suggestions;
    }

    public String getSpeciesAuthority(String genus, String species) {
        if (!this.database.containsSpecies(genus, species)) {
            return null;
        }
        return this.database.getSpeciesAuthority(genus, species);
    }

    public List<String> suggestSubtaxa(String genus, String species, String subtaxa, int maxSize) {
        if (StringUtils.isBlank((CharSequence)subtaxa) || !this.database.containsSpecies(genus, species)) {
            return Collections.emptyList();
        }
        if (this.database.containsSubtaxa(genus, species, subtaxa)) {
            return Arrays.asList(subtaxa);
        }
        return this.database.findSimilarSubtaxa(genus, species, subtaxa, maxSize);
    }

    public String getSubtaxaAuthority(String genus, String species, String subtaxa) {
        if (!this.database.containsSubtaxa(genus, species, subtaxa)) {
            return null;
        }
        return this.database.getSubtaxaAuthority(genus, species, subtaxa);
    }

    public double similarityScore(String string1, String string2) {
        return this.database.similarityScore(string1, string2);
    }
}

