/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.taxonomy.checker;

import java.util.Arrays;

public class MostFrequentKChars {
    public static String getMostFrequentKHash(String string, int k) {
        return MostFrequentKChars.toHashString(MostFrequentKChars.calculateHash(string, k));
    }

    static int[] calculateHash(String string, int k) {
        char[] input = string.toCharArray();
        int[] occurrences = new int[string.length()];
        int[] hash = new int[2 * k];
        int maxOcc = 0;
        for (char c : input) {
            if (c >= '0' && c <= '9') continue;
            int n = string.indexOf(c);
            occurrences[n] = occurrences[n] + 1;
            int charOccurence = occurrences[n];
            if (charOccurence <= maxOcc) continue;
            maxOcc = charOccurence;
        }
        int limit = 0;
        int pos = 0;
        while (maxOcc > 0 && limit < k) {
            int nextOcc = 0;
            for (int i = 0; i < occurrences.length; ++i) {
                if (occurrences[i] == maxOcc) {
                    hash[pos++] = input[i];
                    hash[pos++] = occurrences[i];
                    if (++limit < k) continue;
                    return hash;
                }
                if (occurrences[i] >= maxOcc || occurrences[i] <= nextOcc) continue;
                nextOcc = occurrences[i];
            }
            maxOcc = nextOcc;
        }
        return hash;
    }

    public static int getMostFreqKSimilarity(String hash1, String hash2) {
        return MostFrequentKChars.getMostFreqKSimilarity(MostFrequentKChars.decodeHash(hash1), MostFrequentKChars.decodeHash(hash2));
    }

    public static int getMostFreqKSimilarity(int[] hash1, int[] hash2) {
        int similarity = 0;
        for (int i = 0; i < hash1.length; ++i) {
            char c = (char)hash1[i++];
            int freq1 = hash1[i];
            int freq2 = MostFrequentKChars.findFrequency(hash2, c);
            if (freq2 < 0) continue;
            similarity += Math.min(freq1, freq2);
        }
        return similarity;
    }

    public static int mostFreqKSDF(String inputStr1, String inputStr2, int K, int maxDistance) {
        return maxDistance - MostFrequentKChars.getMostFreqKSimilarity(MostFrequentKChars.calculateHash(inputStr1, K), MostFrequentKChars.calculateHash(inputStr2, K));
    }

    public static double mostFreqKSDF(String inputStr1, String inputStr2, int K) {
        int[] hash1 = MostFrequentKChars.calculateHash(inputStr1, K);
        int[] hash2 = MostFrequentKChars.calculateHash(inputStr2, K);
        return 1.0 * (double)MostFrequentKChars.getMostFreqKSimilarity(hash1, hash2) / Math.max(MostFrequentKChars.getFrequencySum(hash1), MostFrequentKChars.getFrequencySum(hash2));
    }

    static double getFrequencySum(int[] hash) {
        double sum = 0.0;
        for (int i = 1; i < hash.length; i += 2) {
            int freq = hash[i];
            sum += (double)freq;
        }
        return sum;
    }

    private static int findFrequency(int[] hash, char c) {
        for (int i = 0; i < hash.length; ++i) {
            char c2;
            if (c != (c2 = (char)hash[i++])) continue;
            return hash[i];
        }
        return -1;
    }

    static int[] decodeHash(String hash1) {
        int[] h = new int[hash1.length()];
        int pos = 0;
        for (int i = 0; i < hash1.length(); ++i) {
            char c;
            int endIndex;
            h[pos++] = hash1.charAt(i);
            for (endIndex = i + 1; endIndex < hash1.length() && (c = hash1.charAt(endIndex)) >= '0' && c <= '9'; ++endIndex) {
            }
            h[pos++] = Integer.parseInt(hash1.substring(i + 1, endIndex));
            i = endIndex - 1;
        }
        return Arrays.copyOf(h, pos);
    }

    public static String toHashString(int[] h1) {
        char c;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < h1.length && (c = (char)h1[i++]) != '\u0000'; ++i) {
            int freq = h1[i];
            sb.append(c).append(freq);
        }
        return sb.toString();
    }
}

