/*
 * Copyright 2016 Global Crop Diversity Trust
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.genesys.taxonomy.checker;

/**
 * The Class Suggestion.
 *
 * @param <T> the generic type
 */
public class Suggestion<T> {

	/** The suggestion. */
	private T suggestion;

	/** The score. */
	private double score;

	/**
	 * Instantiates a new suggestion.
	 *
	 * @param suggestion the suggestion
	 * @param score the score
	 */
	Suggestion(T suggestion, double score) {
		this.suggestion = suggestion;
		this.score = score;
	}

	/**
	 * Gets the score.
	 *
	 * @return the score
	 */
	public double getScore() {
		return score;
	}

	/**
	 * Update the score
	 * 
	 * @param newScore obviously
	 */
	public void setScore(double newScore) {
		this.score = newScore;
	}

	/**
	 * Gets the suggestion.
	 *
	 * @return the suggestion
	 */
	public T getSuggestion() {
		return suggestion;
	}

	@Override
	public String toString() {
		return "score=" + score + " suggestion=" + suggestion;
	}
}
