/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.taxonomy.checker;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.genesys.taxonomy.checker.InMemoryTaxonomyDatabase;
import org.genesys.taxonomy.gringlobal.model.IGrinSpecies;

public class CachingInMemoryTaxonomyDatabase
extends InMemoryTaxonomyDatabase {
    private final Cache<String, List<IGrinSpecies>> cacheGenusSpecies = CacheBuilder.newBuilder().maximumSize(100L).build();
    private final Cache<String, List<String>> cacheGenusSuggestions = CacheBuilder.newBuilder().maximumSize(100L).build();
    private final Cache<String, List<String>> cacheSpeciesSuggestions = CacheBuilder.newBuilder().maximumSize(100L).build();

    @Override
    protected List<IGrinSpecies> getAllGenusSpecies(String genus) {
        try {
            return (List)this.cacheGenusSpecies.get((Object)genus, () -> CachingInMemoryTaxonomyDatabase.super.getAllGenusSpecies(genus));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> findSimilarGenus(String genus, int maxSize) {
        try {
            return (List)this.cacheGenusSuggestions.get((Object)(genus + "-" + maxSize), () -> CachingInMemoryTaxonomyDatabase.super.findSimilarGenus(genus, maxSize));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> findSimilarSpecies(String genus, String species, int maxSize) {
        try {
            return (List)this.cacheSpeciesSuggestions.get((Object)(genus + "-" + species + "-" + maxSize), () -> CachingInMemoryTaxonomyDatabase.super.findSimilarSpecies(genus, species, maxSize));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

