/*
 * Copyright 2016 Global Crop Diversity Trust
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.genesys.taxonomy.checker;

/**
 * BestScore helps keeping track with best scores during streaming operations.
 */
public class BestScore {
	
	/** The best score. */
	private double bestScore = Double.MIN_VALUE;

	/**
	 * Gets the best score.
	 *
	 * @return the best score
	 */
	public double getBestScore() {
		return bestScore;
	}

	/**
	 * Update.
	 *
	 * @param score the score
	 */
	public void update(double score) {
		if (score > bestScore) {
			// System.err.println("Updating best prev=" + bestScore + " now=" + score);
			bestScore = score;
		}
	}
}
