/*
 * Decompiled with CFR 0.152.
 */
package org.genesys2.transifex.client;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Locale;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.genesys2.transifex.client.TransifexException;
import org.genesys2.transifex.client.TransifexService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Service
public class TransifexServiceImpl
implements TransifexService,
InitializingBean {
    private static final Logger LOG = Logger.getLogger(TransifexServiceImpl.class);
    private static final String TRANSIFEX_API_URL = "https://www.transifex.com/api/2";
    @Value(value="${transifex.project}")
    private String projectSlug;
    @Value(value="${transifex.username}")
    private String trasifexUserName;
    @Value(value="${transifex.password}")
    private String transifexPassord;
    @Value(value="${transifex.content.template}")
    private String contentTemplate;
    private RestTemplate template = new RestTemplate();
    private String transifexProjectUrl;

    public void afterPropertiesSet() throws Exception {
        this.transifexProjectUrl = TRANSIFEX_API_URL.concat("/project/").concat(this.projectSlug);
        LOG.info((Object)("Transifex project URL: " + this.transifexProjectUrl));
    }

    @Override
    public void testCredentials() throws TransifexException {
        HttpHeaders headers = this.basicAuthentication();
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.template.exchange(this.transifexProjectUrl + "/?details", HttpMethod.GET, request, String.class, new Object[0]);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Transifex connection okay! HTTP status code=" + response.getStatusCode()));
            }
        }
        catch (HttpClientErrorException e) {
            throw new TransifexException("Transifex credentials are not valid.", e);
        }
    }

    protected HttpHeaders basicAuthentication() {
        HttpHeaders headers = new HttpHeaders();
        String trasifexCreds = this.trasifexUserName + ":" + this.transifexPassord;
        byte[] transifexCredsBytes = trasifexCreds.getBytes();
        byte[] base64CredsBytes = Base64.encodeBase64((byte[])transifexCredsBytes);
        String base64Creds = new String(base64CredsBytes);
        headers.add("Authorization", "Basic " + base64Creds);
        return headers;
    }

    @Override
    public boolean resourceExists(String slug) {
        ResponseEntity response;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking for resource " + slug));
        }
        HttpHeaders headers = this.basicAuthentication();
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            response = this.template.exchange(this.transifexProjectUrl + "/resource/{slug}", HttpMethod.GET, request, String.class, new Object[]{slug});
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(response.getStatusCode() + " " + (String)response.getBody()));
            }
        }
        catch (HttpClientErrorException e) {
            return false;
        }
        return response.getStatusCode().value() == HttpStatus.OK.value();
    }

    @Override
    public boolean deleteResource(String slug) throws TransifexException {
        HttpHeaders headers = this.basicAuthentication();
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.template.exchange(this.transifexProjectUrl + "/resource/{slug}", HttpMethod.DELETE, request, String.class, new Object[]{slug});
            return response.getStatusCode().value() == 204;
        }
        catch (HttpClientErrorException e) {
            throw new TransifexException(e.getMessage(), e);
        }
    }

    @Override
    public String getTranslatedResource(String slug, Locale locale) throws TransifexException {
        HttpHeaders headers = this.basicAuthentication();
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.template.exchange(this.transifexProjectUrl + "/resource/{slug}/translation/{language}", HttpMethod.GET, request, String.class, new Object[]{slug, locale.getLanguage()});
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Response code=" + response.getStatusCode()));
            }
            return (String)response.getBody();
        }
        catch (HttpClientErrorException | ResourceAccessException e) {
            throw new TransifexException("Error fetching translated resource", e);
        }
    }

    @Override
    public String downloadTranslatedResource(String slug, Locale locale) throws TransifexException {
        HttpHeaders headers = this.basicAuthentication();
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.template.exchange(this.transifexProjectUrl + "/resource/{slug}/translation/{language}?file", HttpMethod.GET, request, byte[].class, new Object[]{slug, locale.getLanguage()});
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Response code=" + response.getStatusCode()));
                LOG.debug((Object)("Response ct=" + response.getHeaders().getContentType()));
            }
            return new String((byte[])response.getBody(), Charset.forName("UTF-8"));
        }
        catch (HttpClientErrorException e) {
            throw new TransifexException("Error fetching translated resource", e);
        }
    }

    @Override
    public void createXhtmlResource(String slug, String title, String content) throws IOException {
        HttpHeaders headers = this.basicAuthentication();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"slug", (Object)slug);
        map.add((Object)"name", (Object)title);
        map.add((Object)"i18n_type", (Object)"XHTML");
        File tempFile = File.createTempFile(slug, ".xhtml");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));){
            LOG.debug((Object)content);
            String xhtmlContent = String.format(this.contentTemplate, title, content);
            IOUtils.write((String)xhtmlContent, (Writer)writer);
            writer.flush();
            FileSystemResource resource = new FileSystemResource(tempFile);
            map.add((Object)"content", (Object)resource);
            HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
            ResponseEntity response = this.template.postForEntity(this.transifexProjectUrl + "/resources/", (Object)request, Object.class, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Response: " + response.getStatusCode()));
            }
        }
        catch (HttpClientErrorException e) {
            LOG.error((Object)e.getMessage());
            LOG.error((Object)e.getResponseBodyAsString());
            throw e;
        }
        finally {
            tempFile.delete();
        }
    }

    @Override
    public void updateXhtmlResource(String slug, String title, String content) throws IOException {
        if (!this.resourceExists(slug)) {
            this.createXhtmlResource(slug, title, content);
            return;
        }
        LOG.info((Object)("Updating Transifex resource " + slug));
        HttpHeaders headers = this.basicAuthentication();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        File tempFile = File.createTempFile(slug, ".xhtml");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));){
            LOG.debug((Object)content);
            String xhtmlContent = String.format(this.contentTemplate, title, content);
            IOUtils.write((String)xhtmlContent, (Writer)writer);
            writer.flush();
            FileSystemResource resource = new FileSystemResource(tempFile);
            map.add((Object)"content", (Object)resource);
            HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
            this.template.put(this.transifexProjectUrl + "/resource/{slug}/content/", (Object)request, new Object[]{slug});
        }
        catch (HttpClientErrorException e) {
            LOG.error((Object)e.getMessage());
            LOG.error((Object)e.getResponseBodyAsString());
            throw e;
        }
        finally {
            tempFile.delete();
        }
    }

    public void createPropertiesXmlResource(String slug, String title, File file) throws IOException {
        HttpHeaders headers = this.basicAuthentication();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"slug", (Object)slug);
        map.add((Object)"name", (Object)title);
        map.add((Object)"i18n_type", (Object)"PROPERTIESXML");
        try {
            FileSystemResource resource = new FileSystemResource(file);
            map.add((Object)"content", (Object)resource);
            HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
            ResponseEntity response = this.template.postForEntity(this.transifexProjectUrl + "/resources/", (Object)request, Object.class, new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Response: " + response.getStatusCode()));
            }
        }
        catch (HttpClientErrorException e) {
            LOG.error((Object)e.getMessage());
            LOG.error((Object)e.getResponseBodyAsString());
            throw e;
        }
    }

    @Override
    public void updatePropertiesXmlResource(String slug, String title, File file) throws IOException {
        if (!this.resourceExists(slug)) {
            this.createPropertiesXmlResource(slug, title, file);
            return;
        }
        LOG.info((Object)("Updating Transifex resource " + slug));
        HttpHeaders headers = this.basicAuthentication();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        try {
            FileSystemResource resource = new FileSystemResource(file);
            map.add((Object)"content", (Object)resource);
            HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
            this.template.put(this.transifexProjectUrl + "/resource/{slug}/content/", (Object)request, new Object[]{slug});
        }
        catch (HttpClientErrorException e) {
            LOG.error((Object)e.getMessage());
            LOG.error((Object)e.getResponseBodyAsString());
            throw e;
        }
    }
}

