/**
 * Copyright 2015 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/


package org.genesys.worldclim;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public abstract class ZipUtils {

	public static Set<String> listHeaders(File zipFile) throws ZipException,
			IOException {

		ZipFile file = null;
		try {
			file = new ZipFile(zipFile);
			return listHeaders(file);
		} finally {
			file.close();
		}
	}

	public static Set<String> listHeaders(ZipFile zipFile) {
		Set<String> headers = new HashSet<String>();
		Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();

		while (zipEntries.hasMoreElements()) {
			ZipEntry zipEntry = zipEntries.nextElement();
			if (zipEntry.getName().endsWith(".hdr")) {
				headers.add(zipEntry.getName());
			}
		}

		return headers;
	}
}
