/**
 * Copyright 2015 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/

package org.genesys.worldclim;


public final class WorldClimUtil {
	private static final int NCOLS = 43200;

	// private static final int NROWS = 18000;
	// private static final double XDIM = 0.008333333333333333d;
	// private static final double YDIM = 0.008333333333333333d;

	/**
	 * Converts WGS84 longitude, latitude to 30s tile index
	 * 
	 * @param longitude
	 * @param latitude
	 * @return -1 for invalid lat/lng or tile index for 30s tiles
	 */
	public static final Long getTileIndex(int factor, Number longitude,
			Number latitude) {
		if (longitude == null || latitude == null)
			return null;

		if (longitude.doubleValue() < -180 || longitude.doubleValue() > 180)
			return null;
		if (latitude.doubleValue() < -90 || latitude.doubleValue() > 90)
			return null;

		double res = 1d / 120d;
		long colnr = Math.round((longitude.doubleValue() + 180) / res / factor);
		long rownr = Math.round((90 - latitude.doubleValue()) / res / factor);
		// System.err.println("> " + longitude + ", " + latitude);
		// System.err.println("= " + colnr + ", " + rownr);

		return (long) (rownr * NCOLS / factor + colnr);
	}
}
