/**
 * Copyright 2015 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/

package org.genesys.worldclim.grid.generic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileChannel.MapMode;

public class GenericGridFile {

	private String name;
	private File headerFile;
	private File dataFile;

	public GenericGridFile(File directory, String name) {
		this.name = name;
		this.headerFile = new File(directory, name + ".hdr");
		this.dataFile = new File(directory, name + ".bil");
	}

	public void close() throws IOException {

	}

	/**
	 * Read generic grid header data from zip entry
	 * 
	 * @return
	 * @throws IOException
	 */
	public Header readHeader() throws IOException {
		FileInputStream headerStream = new FileInputStream(headerFile);
		GenericGridHeaderReader gghr = null;
		try {
			gghr = new GenericGridHeaderReader(headerStream);
			Header header = gghr.readHeader();
			header.setName(name);
			return header;
		} finally {
			gghr.close();
		}
	}

	public FileInputStream getDataFileStream() throws FileNotFoundException {
		return new FileInputStream(dataFile);
	}

	public MappedByteBuffer mapDataBuffer() throws IOException {
		FileChannel dataChannel = null;
		try {
			dataChannel = getDataFileStream().getChannel();
			
			MappedByteBuffer x = dataChannel.map(MapMode.READ_ONLY, 0,
					dataChannel.size());
			x.order(ByteOrder.LITTLE_ENDIAN);

			return x;
		} finally {
			dataChannel.close();
		}
	}

	public File getHeaderFile() {
		return this.headerFile;
	}
	
	public File getDataFile() {
		return dataFile;
	}

}
