/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.worldclim;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.genesys.worldclim.grid.generic.GenericGridFile;
import org.genesys.worldclim.grid.generic.GenericGridZipFile;

public class WorldClimDownload {
    public static String WORLDCLIM_ORG_FILEBASE = "http://biogeo.ucdavis.edu/data/climate/worldclim/1_4/grid/cur/";
    protected final File worldClimDir;
    protected final String variableName;

    public WorldClimDownload(File worldClimDir, String variableName) {
        this.worldClimDir = worldClimDir;
        this.variableName = variableName;
    }

    public static String getFileName(String variableName) throws FileNotFoundException {
        if ("alt".equalsIgnoreCase(variableName)) {
            return "alt_2-5m_bil.zip";
        }
        if (variableName.matches("prec\\d{1,2}")) {
            return "prec_2-5m_bil.zip";
        }
        if (variableName.matches("tmax\\d{1,2}")) {
            return "tmax_2-5m_bil.zip";
        }
        if (variableName.matches("tmin\\d{1,2}")) {
            return "tmin_2-5m_bil.zip";
        }
        if (variableName.matches("tmean\\d{1,2}")) {
            return "tmean_2-5m_bil.zip";
        }
        if (variableName.matches("bio\\d{1,2}")) {
            return "bio_2-5m_bil.zip";
        }
        throw new FileNotFoundException("No worldclim file for " + variableName);
    }

    public boolean haveData() {
        GenericGridFile ggf = new GenericGridFile(this.worldClimDir, this.variableName);
        return ggf.getHeaderFile().exists() && ggf.getDataFile().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> downloadAndExtract() throws IOException {
        System.out.println("Downloading for " + this.variableName);
        File tempFile = this.download(WorldClimDownload.getFileName(this.variableName));
        try {
            List<File> files = GenericGridZipFile.unzip(tempFile, this.worldClimDir);
            for (File file : files) {
                System.out.println("Extracted {}" + file.getCanonicalPath());
            }
            List<File> list = files;
            return list;
        }
        finally {
            tempFile.delete();
        }
    }

    private File download(String fileName) throws IOException {
        BufferedInputStream istream = null;
        BufferedOutputStream ostream = null;
        File tempFile = File.createTempFile("worldclim", ".zip");
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet httpget = new HttpGet(WORLDCLIM_ORG_FILEBASE + fileName);
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpget);
            HttpEntity entity = response.getEntity();
            System.out.println(entity.getContentType() + " " + entity.getContentLength());
            istream = new BufferedInputStream(entity.getContent());
            ostream = new BufferedOutputStream(new FileOutputStream(tempFile));
            System.out.println("Downloading " + fileName + " " + entity.getContentLength());
            IOUtils.copy((InputStream)istream, (OutputStream)ostream);
            ((OutputStream)ostream).flush();
            System.out.println("Retrieved " + fileName);
        }
        catch (ClientProtocolException e) {
            try {
                System.out.println(e.getMessage());
                e.printStackTrace();
                tempFile.delete();
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(istream);
                IOUtils.closeQuietly(ostream);
                IOUtils.closeQuietly((Closeable)httpclient);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)istream);
        IOUtils.closeQuietly((OutputStream)ostream);
        IOUtils.closeQuietly((Closeable)httpclient);
        return tempFile;
    }
}

