/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.worldclim;

public final class WorldClimUtil {
    public static final Long getWorldclim25Tile(Number longitude, Number latitude) {
        if (longitude == null || latitude == null) {
            return null;
        }
        int columns = 8640;
        int rows = 4320;
        if (longitude.doubleValue() < -180.0 || longitude.doubleValue() > 180.0) {
            return null;
        }
        if (latitude.doubleValue() < -90.0 || latitude.doubleValue() > 90.0) {
            return null;
        }
        long ncol = Math.round(8639.0 * (longitude.doubleValue() + 180.0) / 360.0) % 8640L;
        long nrow = Math.round(4319.0 * (latitude.doubleValue() + 90.0) / 180.0) % 4320L;
        return nrow * 8640L + ncol;
    }

    public static final Long tileIndexToDataIndex(Long tileIndex) {
        int columns = 8640;
        int rows = 4320;
        int bilRows = 3600;
        if (tileIndex == null) {
            return null;
        }
        long rcol = tileIndex % 8640L;
        long rrow = (int)(tileIndex / 8640L) % 4320;
        if (4320L - rrow - 1L > 3600L) {
            return null;
        }
        return (4320L - rrow - 1L) * 8640L + rcol;
    }

    public static float getFactor(String variableName) {
        float factor = 1.0f;
        if (variableName.matches("(bio)(1|2|5|6|7|8|9|10|11)")) {
            factor = 0.1f;
        } else if (variableName.matches("(bio)(3|4)")) {
            factor = 0.01f;
        } else if (variableName.matches("(tmean|tmax|tmin)\\d{1,2}")) {
            factor = 0.1f;
        }
        return factor;
    }

    public static double[] reverseWorldclim25Tile(Long tileIndex) {
        if (tileIndex == null) {
            return null;
        }
        int columns = 8640;
        int rows = 4320;
        double longitude = -180.0 + 0.041666666666666664 * (double)(tileIndex % 8640L) + 0.020833333333333332;
        double latitude = -90.0 + 0.041666666666666664 * (double)((int)(tileIndex / 8640L)) + 0.020833333333333332;
        return new double[]{latitude, longitude};
    }
}

