/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.worldclim;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public abstract class ZipUtils {
    public static Set<String> listHeaders(File zipFile) throws ZipException, IOException {
        try (ZipFile file = null;){
            file = new ZipFile(zipFile);
            Set<String> set = ZipUtils.listHeaders(file);
            return set;
        }
    }

    public static Set<String> listHeaders(ZipFile zipFile) {
        HashSet<String> headers = new HashSet<String>();
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            if (!zipEntry.getName().endsWith(".hdr")) continue;
            headers.add(zipEntry.getName());
        }
        return headers;
    }
}

