/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.worldclim.grid.generic;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.genesys.worldclim.grid.generic.Header;

public class GenericGridDataReader
implements Closeable {
    private InputStream bil;
    private Header header;
    private byte[] readBuffer;
    private ByteBuffer byteBuffer;

    public GenericGridDataReader(InputStream bil, Header header) {
        this.bil = bil;
        this.header = header;
        this.readBuffer = new byte[header.getBandRowBytes()];
        this.byteBuffer = ByteBuffer.allocate(header.getBandRowBytes());
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void close() throws IOException {
        this.byteBuffer.clear();
        this.byteBuffer = null;
        this.readBuffer = null;
        this.bil.close();
    }

    public Short[] readBandData() throws IOException {
        Short[] band = new Short[this.header.getColumns()];
        this.byteBuffer.clear();
        this.bil.read(this.readBuffer);
        this.byteBuffer.put(this.readBuffer);
        for (int i = 0; i < band.length; ++i) {
            band[i] = this.byteBuffer.getShort(i * 2);
            if (band[i].shortValue() != this.header.getNoDataValue()) continue;
            band[i] = null;
        }
        this.bil.skip(this.header.getBandGapBytes());
        return band;
    }
}

