/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.worldclim.grid.generic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.genesys.worldclim.grid.generic.GenericGridHeaderReader;
import org.genesys.worldclim.grid.generic.Header;

public class GenericGridFile {
    private String name;
    private File headerFile;
    private File dataFile;

    public GenericGridFile(File directory, String name) {
        this.name = name;
        this.headerFile = new File(directory, name + ".hdr");
        this.dataFile = new File(directory, name + ".bil");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Header readHeader() throws IOException {
        FileInputStream headerStream = new FileInputStream(this.headerFile);
        try (GenericGridHeaderReader gghr = null;){
            gghr = new GenericGridHeaderReader(headerStream);
            Header header = gghr.readHeader();
            header.setName(this.name);
            Header header2 = header;
            return header2;
        }
    }

    public FileInputStream getDataFileStream() throws FileNotFoundException {
        return new FileInputStream(this.dataFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedByteBuffer mapDataBuffer() throws IOException {
        try (FileChannel dataChannel = null;){
            dataChannel = this.getDataFileStream().getChannel();
            MappedByteBuffer x = dataChannel.map(FileChannel.MapMode.READ_ONLY, 0L, dataChannel.size());
            x.order(ByteOrder.LITTLE_ENDIAN);
            MappedByteBuffer mappedByteBuffer = x;
            return mappedByteBuffer;
        }
    }

    public File getHeaderFile() {
        return this.headerFile;
    }

    public File getDataFile() {
        return this.dataFile;
    }
}

