/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.worldclim.grid.generic;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.genesys.worldclim.grid.generic.Header;

public class GenericGridHeaderReader
implements Closeable {
    private InputStream source;

    public GenericGridHeaderReader(InputStream is) {
        this.source = is;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    public Header readHeader() throws IOException {
        Header header = new Header();
        BufferedReader br = new BufferedReader(new InputStreamReader(this.source));
        String line = null;
        HashMap<String, String> attrs = null;
        boolean foundAttrs = false;
        while ((line = br.readLine()) != null) {
            if (line.length() == 0) {
                if (foundAttrs) continue;
                foundAttrs = true;
                attrs = new HashMap<String, String>();
                header.setAttributes(attrs);
                continue;
            }
            String[] l = line.split("\\s+", 2);
            if (l.length != 2) continue;
            if (foundAttrs) {
                attrs.put(l[0].trim(), l[1].trim());
                continue;
            }
            this.setHeader(header, l[0].trim(), l[1].trim());
        }
        return header;
    }

    private void setHeader(Header header, String key, String value) throws IOException {
        if (!"BYTEORDER".equals(key)) {
            if ("PIXELTYPE".equals(key)) {
                if (!value.equals("SIGNEDINT")) {
                    throw new IOException("Unsupported .bil PIXELTYPE " + value);
                }
            } else if ("SKIPBYTES".equals(key)) {
                if (!value.equals("0")) {
                    throw new IOException("Unsupported .bil SKIPBYTES " + value);
                }
            } else if (!"LAYOUT".equals(key)) {
                if ("NROWS".equals(key)) {
                    header.setRows(Integer.parseInt(value));
                } else if ("NCOLS".equals(key)) {
                    header.setColumns(Integer.parseInt(value));
                } else if ("NBANDS".equals(key)) {
                    header.setBands(Integer.parseInt(value));
                } else if ("NBITS".equals(key)) {
                    header.setBits(Integer.parseInt(value));
                } else if ("BANDROWBYTES".equals(key)) {
                    header.setBandRowBytes(Integer.parseInt(value));
                } else if ("TOTALROWBYTES".equals(key)) {
                    header.setTotalRowBytes(Integer.parseInt(value));
                } else if ("BANDGAPBYTES".equals(key)) {
                    header.setBandGapBytes(Integer.parseInt(value));
                } else if ("NODATA".equals(key)) {
                    header.setNoDataValue(Integer.parseInt(value));
                } else if ("ULXMAP".equals(key)) {
                    header.setUlXMap(Double.parseDouble(value));
                } else if ("ULYMAP".equals(key)) {
                    header.setUlYMap(Double.parseDouble(value));
                } else if ("XDIM".equals(key)) {
                    header.setxDim(Double.parseDouble(value));
                } else if ("YDIM".equals(key)) {
                    header.setyDim(Double.parseDouble(value));
                } else {
                    throw new IOException("Unknown header " + key);
                }
            }
        }
    }
}

