/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.worldclim.grid.generic;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.genesys.worldclim.ZipUtils;
import org.genesys.worldclim.grid.generic.GenericGridDataReader;
import org.genesys.worldclim.grid.generic.GenericGridHeaderReader;
import org.genesys.worldclim.grid.generic.Header;

public class GenericGridZipFile
implements Closeable {
    private ZipFile zipFile;
    private Set<String> headers;

    public GenericGridZipFile(ZipFile zipFile, Set<String> headers) {
        this.zipFile = zipFile;
        this.headers = headers;
    }

    public GenericGridZipFile(ZipFile zipFile) {
        this.zipFile = zipFile;
        this.headers = ZipUtils.listHeaders(zipFile);
    }

    public static GenericGridZipFile open(File file) throws ZipException, IOException {
        ZipFile zipFile = new ZipFile(file);
        Set<String> headers = ZipUtils.listHeaders(zipFile);
        return new GenericGridZipFile(zipFile, headers);
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
        this.zipFile = null;
        this.headers = null;
    }

    public Set<String> getHeaderFileNames() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Header readHeader(String headerFileName) throws IOException {
        ZipEntry headerEntry = this.zipFile.getEntry(headerFileName);
        if (headerEntry == null) {
            return null;
        }
        try (GenericGridHeaderReader gghr = null;){
            gghr = new GenericGridHeaderReader(this.zipFile.getInputStream(headerEntry));
            Header header = gghr.readHeader();
            header.setName(headerFileName.substring(0, headerFileName.length() - 4));
            Header header2 = header;
            return header2;
        }
    }

    public GenericGridDataReader getReader(Header header) throws IOException {
        String dataFileName = header.getName() + ".bil";
        ZipEntry headerEntry = this.zipFile.getEntry(dataFileName);
        if (headerEntry == null) {
            throw new IOException("Data file not found " + dataFileName);
        }
        return new GenericGridDataReader(this.zipFile.getInputStream(headerEntry), header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> unzip(File zipArchive, File destination) throws IOException {
        if (!destination.isDirectory()) {
            throw new IOException("Destination must be a directory");
        }
        if (!destination.canWrite()) {
            throw new IOException("Cannot write to destination directory");
        }
        ZipFile zipFile = new ZipFile(zipArchive);
        ArrayList<File> files = new ArrayList<File>();
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String name = zipEntry.getName();
            File destFile = new File(destination, name);
            BufferedOutputStream fos = null;
            BufferedInputStream fis = null;
            try {
                fos = new BufferedOutputStream(new FileOutputStream(destFile));
                fis = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                IOUtils.copy((InputStream)fis, (OutputStream)fos);
                fos.flush();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
            IOUtils.closeQuietly((OutputStream)fos);
            files.add(destFile);
        }
        zipFile.close();
        return files;
    }
}

