/*
 * Decompiled with CFR 0.152.
 */
package org.geojsf.controller.facade;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import net.sf.ahtutils.controller.facade.UtilsFacadeBean;
import net.sf.ahtutils.exception.ejb.UtilsConstraintViolationException;
import net.sf.ahtutils.exception.ejb.UtilsLockingException;
import net.sf.ahtutils.interfaces.model.graphic.UtilsGraphic;
import net.sf.ahtutils.interfaces.model.status.UtilsDescription;
import net.sf.ahtutils.interfaces.model.status.UtilsLang;
import net.sf.ahtutils.interfaces.model.status.UtilsStatus;
import net.sf.ahtutils.model.interfaces.with.EjbWithId;
import org.geojsf.interfaces.facade.GeoJsfFacade;
import org.geojsf.interfaces.model.core.GeoJsfCategory;
import org.geojsf.interfaces.model.core.GeoJsfLayer;
import org.geojsf.interfaces.model.core.GeoJsfMap;
import org.geojsf.interfaces.model.core.GeoJsfService;
import org.geojsf.interfaces.model.core.GeoJsfView;
import org.geojsf.interfaces.model.meta.GeoJsfDataSource;
import org.geojsf.interfaces.model.meta.GeoJsfViewPort;
import org.geojsf.interfaces.model.sld.GeoJsfSld;
import org.geojsf.interfaces.model.sld.GeoJsfSldRule;
import org.geojsf.interfaces.model.sld.GeoJsfSldTemplate;
import org.geojsf.interfaces.model.with.EjbWithSldRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoJsfFacadeBean<L extends UtilsLang, D extends UtilsDescription, G extends UtilsGraphic<L, D, G, GT, GS>, GT extends UtilsStatus<GT, L, D>, GS extends UtilsStatus<GS, L, D>, CATEGORY extends GeoJsfCategory<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SERVICE extends GeoJsfService<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, LAYER extends GeoJsfLayer<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, MAP extends GeoJsfMap<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, VIEW extends GeoJsfView<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, VP extends GeoJsfViewPort<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, DS extends GeoJsfDataSource<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SLDTEMPLATE extends GeoJsfSldTemplate<L, D, SLDTEMPLATE, SLDTYPE>, SLDTYPE extends UtilsStatus<SLDTYPE, L, D>, SLD extends GeoJsfSld<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, RULE extends GeoJsfSldRule<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>>
extends UtilsFacadeBean
implements GeoJsfFacade<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> {
    static final Logger logger = LoggerFactory.getLogger(GeoJsfFacadeBean.class);

    public GeoJsfFacadeBean(EntityManager em) {
        super(em);
    }

    public MAP load(Class<MAP> cView, MAP map) {
        map = (GeoJsfMap)this.em.find(cView, (Object)map.getId());
        map.getViews().size();
        if (map.getViewPort() != null) {
            map.getViewPort().getId();
        }
        return map;
    }

    public CATEGORY load(Class<CATEGORY> cCategory, CATEGORY category) {
        category = (GeoJsfCategory)this.em.find(cCategory, (Object)category.getId());
        category.getLayer().size();
        return category;
    }

    public SERVICE load(Class<SERVICE> cService, SERVICE service) {
        service = (GeoJsfService)this.em.find(cService, (Object)service.getId());
        service.getLayer().size();
        return service;
    }

    public LAYER load(Class<LAYER> cLayer, LAYER layer) {
        if ((layer = (GeoJsfLayer)this.em.find(cLayer, (Object)layer.getId())).getViewPort() != null) {
            layer.getViewPort().getId();
        }
        return layer;
    }

    public SLD load(Class<SLD> cSld, SLD sld) {
        sld = (GeoJsfSld)this.em.find(cSld, (Object)sld.getId());
        for (GeoJsfSldRule r : sld.getRules()) {
            if (r.getGraphic() == null) continue;
            r.getGraphic().getId();
        }
        sld.getRules().size();
        return sld;
    }

    public DS load(Class<DS> cDs, DS ds) {
        ds = (GeoJsfDataSource)this.em.find(cDs, (Object)ds.getId());
        ds.getLayers().size();
        return ds;
    }

    public RULE load(Class<RULE> cRule, RULE rule) {
        rule = (GeoJsfSldRule)this.em.find(cRule, (Object)rule.getId());
        rule.getGraphic().getId();
        return rule;
    }

    public void rm(Class<VIEW> cView, VIEW view) {
        view = (GeoJsfView)this.em.find(cView, (Object)view.getId());
        view.getMap().getViews().remove(view);
        this.em.remove(view);
    }

    public void rm(Class<LAYER> cLayer, LAYER layer) {
        layer = (GeoJsfLayer)this.em.find(cLayer, (Object)layer.getId());
        layer.getCategory().getLayer().remove(layer);
        layer.getService().getLayer().remove(layer);
        this.em.remove(layer);
    }

    public List<DS> fDataSources(Class<MAP> cMap, Class<DS> cDs, MAP map) {
        map = (GeoJsfMap)this.find(cMap, (EjbWithId)map);
        ArrayList<GeoJsfDataSource> tmp = new ArrayList<GeoJsfDataSource>();
        HashSet<GeoJsfLayer> layers = new HashSet<GeoJsfLayer>();
        for (GeoJsfView view : map.getViews()) {
            layers.add(view.getLayer());
            for (GeoJsfDataSource ds : view.getLayer().getSources()) {
                if (tmp.contains(ds)) continue;
                tmp.add(ds);
            }
        }
        ArrayList<GeoJsfDataSource> result = new ArrayList<GeoJsfDataSource>();
        for (GeoJsfDataSource ds : tmp) {
            logger.info("Adding ds " + ds.toString());
            try {
                ds = (GeoJsfDataSource)this.find(cDs, (EjbWithId)ds);
                GeoJsfDataSource dsAdd = (GeoJsfDataSource)cDs.newInstance();
                dsAdd.setId(ds.getId());
                dsAdd.setDescription(ds.getDescription());
                dsAdd.setName(ds.getName());
                for (GeoJsfLayer l : ds.getLayers()) {
                    logger.info("Testing layer " + l.toString());
                    if (!layers.contains(l)) continue;
                    logger.info("\tAdding layer " + l.toString());
                    dsAdd.getLayers().add(l);
                }
                result.add(dsAdd);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public <W extends EjbWithSldRules<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>> RULE save(Class<W> cW, W entity, RULE rule) throws UtilsLockingException, UtilsConstraintViolationException {
        entity = (EjbWithSldRules)this.find(cW, (EjbWithId)entity);
        rule = (GeoJsfSldRule)this.saveProtected((EjbWithId)rule);
        if (!entity.getRules().contains(rule)) {
            entity.getRules().add(rule);
            this.saveProtected((EjbWithId)entity);
        }
        return rule;
    }

    public <W extends EjbWithSldRules<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>> void rm(Class<W> cW, W entity, RULE rule) throws UtilsConstraintViolationException, UtilsLockingException {
        if ((entity = (EjbWithSldRules)this.find(cW, (EjbWithId)entity)).getRules().contains(rule)) {
            entity.getRules().remove(rule);
            this.saveProtected((EjbWithId)entity);
        }
        this.rmProtected(rule);
    }

    public List<SLD> fGlobalSlds(Class<SLD> cSld) {
        CriteriaBuilder cB = this.em.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = cB.createQuery(cSld);
        Root fromType = criteriaQuery.from(cSld);
        Path pGlobal = fromType.get("globalManaged");
        CriteriaQuery select = criteriaQuery.select((Selection)fromType);
        select.where((Expression)cB.equal((Expression)pGlobal, (Object)true));
        return this.em.createQuery(select).getResultList();
    }
}

