/*
 * Decompiled with CFR 0.152.
 */
package org.geojsf.controller.util;

import net.sf.ahtutils.exception.ejb.UtilsConstraintViolationException;
import net.sf.ahtutils.interfaces.model.graphic.UtilsGraphic;
import net.sf.ahtutils.interfaces.model.status.UtilsDescription;
import net.sf.ahtutils.interfaces.model.status.UtilsLang;
import net.sf.ahtutils.interfaces.model.status.UtilsStatus;
import org.geojsf.factory.ejb.EjbGeoCategoryFactory;
import org.geojsf.factory.ejb.EjbGeoLayerFactory;
import org.geojsf.factory.ejb.EjbGeoMapFactory;
import org.geojsf.factory.ejb.EjbGeoServiceFactory;
import org.geojsf.factory.ejb.EjbGeoViewFactory;
import org.geojsf.interfaces.model.core.GeoJsfCategory;
import org.geojsf.interfaces.model.core.GeoJsfLayer;
import org.geojsf.interfaces.model.core.GeoJsfMap;
import org.geojsf.interfaces.model.core.GeoJsfService;
import org.geojsf.interfaces.model.core.GeoJsfView;
import org.geojsf.interfaces.model.meta.GeoJsfDataSource;
import org.geojsf.interfaces.model.meta.GeoJsfViewPort;
import org.geojsf.interfaces.model.sld.GeoJsfSld;
import org.geojsf.interfaces.model.sld.GeoJsfSldRule;
import org.geojsf.interfaces.model.sld.GeoJsfSldTemplate;

public class DummyViewFactory<L extends UtilsLang, D extends UtilsDescription, G extends UtilsGraphic<L, D, G, GT, GS>, GT extends UtilsStatus<GT, L, D>, GS extends UtilsStatus<GS, L, D>, CATEGORY extends GeoJsfCategory<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SERVICE extends GeoJsfService<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, LAYER extends GeoJsfLayer<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, MAP extends GeoJsfMap<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, VIEW extends GeoJsfView<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, VP extends GeoJsfViewPort<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, DS extends GeoJsfDataSource<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SLDTEMPLATE extends GeoJsfSldTemplate<L, D, SLDTEMPLATE, SLDTYPE>, SLDTYPE extends UtilsStatus<SLDTYPE, L, D>, SLD extends GeoJsfSld<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, RULE extends GeoJsfSldRule<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>> {
    private EjbGeoCategoryFactory<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> fCategory;
    private EjbGeoServiceFactory<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> fService;
    private EjbGeoLayerFactory<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> fLayer;
    private EjbGeoMapFactory<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> fMap;
    private EjbGeoViewFactory<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> fView;
    public SERVICE serviceOsm;
    public SERVICE serviceAht;
    private CATEGORY category;
    private LAYER layerOsmBasic;
    private LAYER layerAhtRoads;
    private LAYER layerAhtStreams;
    private LAYER layerAhtRestricted;
    private MAP map;
    final Class<L> clLang;
    final Class<D> clDescription;
    final Class<CATEGORY> cCategory;
    final Class<SERVICE> clService;
    final Class<LAYER> clLayer;
    final Class<MAP> clMap;
    final Class<VIEW> clView;
    private final String[] langs = new String[]{"en", "de"};

    public SERVICE getServiceOsm() {
        return this.serviceOsm;
    }

    public SERVICE getServiceAht() {
        return this.serviceAht;
    }

    public MAP getMap() {
        return this.map;
    }

    public static <L extends UtilsLang, D extends UtilsDescription, G extends UtilsGraphic<L, D, G, GT, GS>, GT extends UtilsStatus<GT, L, D>, GS extends UtilsStatus<GS, L, D>, CATEGORY extends GeoJsfCategory<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SERVICE extends GeoJsfService<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, LAYER extends GeoJsfLayer<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, MAP extends GeoJsfMap<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, VIEW extends GeoJsfView<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, VP extends GeoJsfViewPort<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, DS extends GeoJsfDataSource<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SLDTYPE extends UtilsStatus<SLDTYPE, L, D>, SLDTEMPLATE extends GeoJsfSldTemplate<L, D, SLDTEMPLATE, SLDTYPE>, SLD extends GeoJsfSld<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, RULE extends GeoJsfSldRule<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>> DummyViewFactory<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> factory(Class<L> clLang, Class<D> clDescription, Class<CATEGORY> cCategory, Class<SERVICE> clService, Class<LAYER> clLayer, Class<MAP> clMap, Class<VIEW> clView) {
        return new DummyViewFactory<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>(clLang, clDescription, cCategory, clService, clLayer, clMap, clView);
    }

    public DummyViewFactory(Class<L> clLang, Class<D> clDescription, Class<CATEGORY> cCategory, Class<SERVICE> clService, Class<LAYER> clLayer, Class<MAP> clMap, Class<VIEW> clView) {
        this.clLang = clLang;
        this.clDescription = clDescription;
        this.cCategory = cCategory;
        this.clService = clService;
        this.clLayer = clLayer;
        this.clMap = clMap;
        this.clView = clView;
        this.fCategory = EjbGeoCategoryFactory.factory(cCategory);
        this.fService = EjbGeoServiceFactory.factory(clService);
        this.fLayer = EjbGeoLayerFactory.factory(clLang, clLayer);
        this.fMap = EjbGeoMapFactory.factory(clLang, clMap);
        this.fView = EjbGeoViewFactory.factory(clView);
        try {
            this.initServices();
            this.initCategory();
            this.initLayer();
            this.initViews();
        }
        catch (UtilsConstraintViolationException e) {
            e.printStackTrace();
        }
    }

    private void initCategory() throws UtilsConstraintViolationException {
        if (this.category == null) {
            this.category = this.fCategory.build("cat");
            this.serviceOsm.setId(0L);
        }
    }

    private void initServices() throws UtilsConstraintViolationException {
        if (this.serviceOsm == null) {
            this.serviceOsm = this.fService.build("osm", "http://vmap0.tiles.osgeo.org/wms/vmap0");
            this.serviceOsm.setId(0L);
        }
        if (this.serviceAht == null) {
            this.serviceAht = this.fService.build("aht", "https://www.aht-group.com/geoserver/sf/wms");
            this.serviceAht.setId(1L);
        }
    }

    private void initLayer() throws UtilsConstraintViolationException {
        this.layerOsmBasic = this.fLayer.build("basic", this.serviceOsm, this.category, this.langs);
        this.layerOsmBasic.setId(1L);
        this.layerAhtRoads = this.fLayer.build("roads", this.serviceAht, this.category, this.langs);
        this.layerAhtRoads.setId(2L);
        this.layerAhtStreams = this.fLayer.build("streams", this.serviceAht, this.category, this.langs);
        this.layerAhtStreams.setId(3L);
        this.layerAhtRestricted = this.fLayer.build("restricted", this.serviceAht, this.category, this.langs);
        this.layerAhtRestricted.setId(4L);
    }

    private void initViews() throws UtilsConstraintViolationException {
        this.map = this.fMap.create("defaultMap", this.langs);
        this.map.setId(1L);
        this.map.getViews().add(this.fView.create(this.map, this.layerAhtRoads, 1, true, true));
        this.map.getViews().add(this.fView.create(this.map, this.layerAhtStreams, 2, true, true));
        this.map.getViews().add(this.fView.create(this.map, this.layerAhtRestricted, 3, true, true));
        this.map.getViews().add(this.fView.create(this.map, this.layerOsmBasic, 4, true, true));
    }
}

