/*
 * Decompiled with CFR 0.152.
 */
package org.geojsf.util.db.init;

import net.sf.ahtutils.db.ejb.AhtDbEjbUpdater;
import net.sf.ahtutils.exception.ejb.UtilsConstraintViolationException;
import net.sf.ahtutils.exception.ejb.UtilsLockingException;
import net.sf.ahtutils.exception.ejb.UtilsNotFoundException;
import net.sf.ahtutils.exception.processing.UtilsConfigurationException;
import net.sf.ahtutils.factory.ejb.status.EjbDescriptionFactory;
import net.sf.ahtutils.factory.ejb.status.EjbLangFactory;
import net.sf.ahtutils.interfaces.facade.UtilsFacade;
import net.sf.ahtutils.interfaces.model.graphic.UtilsGraphic;
import net.sf.ahtutils.interfaces.model.status.UtilsDescription;
import net.sf.ahtutils.interfaces.model.status.UtilsLang;
import net.sf.ahtutils.interfaces.model.status.UtilsStatus;
import net.sf.ahtutils.model.interfaces.with.EjbWithDescription;
import net.sf.ahtutils.model.interfaces.with.EjbWithLang;
import org.geojsf.interfaces.model.core.GeoJsfCategory;
import org.geojsf.interfaces.model.core.GeoJsfLayer;
import org.geojsf.interfaces.model.core.GeoJsfMap;
import org.geojsf.interfaces.model.core.GeoJsfService;
import org.geojsf.interfaces.model.core.GeoJsfView;
import org.geojsf.interfaces.model.meta.GeoJsfDataSource;
import org.geojsf.interfaces.model.meta.GeoJsfViewPort;
import org.geojsf.interfaces.model.sld.GeoJsfSld;
import org.geojsf.interfaces.model.sld.GeoJsfSldRule;
import org.geojsf.interfaces.model.sld.GeoJsfSldTemplate;
import org.geojsf.model.xml.geojsf.Category;
import org.geojsf.model.xml.geojsf.Repository;
import org.geojsf.model.xml.geojsf.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbCategoryInit<L extends UtilsLang, D extends UtilsDescription, G extends UtilsGraphic<L, D, G, GT, GS>, GT extends UtilsStatus<GT, L, D>, GS extends UtilsStatus<GS, L, D>, CATEGORY extends GeoJsfCategory<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SERVICE extends GeoJsfService<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, LAYER extends GeoJsfLayer<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, MAP extends GeoJsfMap<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, VIEW extends GeoJsfView<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, VP extends GeoJsfViewPort<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, DS extends GeoJsfDataSource<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SLDTEMPLATE extends GeoJsfSldTemplate<L, D, SLDTEMPLATE, SLDTYPE>, SLDTYPE extends UtilsStatus<SLDTYPE, L, D>, SLD extends GeoJsfSld<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, RULE extends GeoJsfSldRule<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>> {
    static final Logger logger = LoggerFactory.getLogger(DbCategoryInit.class);
    private final Class<CATEGORY> cCategory;
    private UtilsFacade fSecurity;
    private EjbLangFactory<L> ejbLangFactory;
    private EjbDescriptionFactory<D> ejbDescriptionFactory;

    public DbCategoryInit(Class<L> cL, Class<D> cD, Class<CATEGORY> cCategory, UtilsFacade fAcl) {
        this.cCategory = cCategory;
        this.fSecurity = fAcl;
        this.ejbLangFactory = EjbLangFactory.createFactory(cL);
        this.ejbDescriptionFactory = EjbDescriptionFactory.createFactory(cD);
    }

    public static <L extends UtilsLang, D extends UtilsDescription, G extends UtilsGraphic<L, D, G, GT, GS>, GT extends UtilsStatus<GT, L, D>, GS extends UtilsStatus<GS, L, D>, CATEGORY extends GeoJsfCategory<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SERVICE extends GeoJsfService<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, LAYER extends GeoJsfLayer<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, MAP extends GeoJsfMap<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, VIEW extends GeoJsfView<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, VP extends GeoJsfViewPort<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, DS extends GeoJsfDataSource<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SLDTYPE extends UtilsStatus<SLDTYPE, L, D>, SLDTEMPLATE extends GeoJsfSldTemplate<L, D, SLDTEMPLATE, SLDTYPE>, SLD extends GeoJsfSld<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, RULE extends GeoJsfSldRule<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>> DbCategoryInit<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> factory(Class<L> cL, Class<D> cD, Class<CATEGORY> cCategory, UtilsFacade fAcl) {
        return new DbCategoryInit<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>(cL, cD, cCategory, fAcl);
    }

    public void iuServices(Repository categories) throws UtilsConfigurationException {
        logger.debug("i/u " + Repository.class.getSimpleName() + " with " + categories.getService().size() + " " + Service.class.getSimpleName());
        AhtDbEjbUpdater ejbUpdater = AhtDbEjbUpdater.createFactory(this.cCategory);
        ejbUpdater.dbEjbs(this.fSecurity.all(this.cCategory));
        for (Category category : categories.getCategory()) {
            GeoJsfCategory ejb;
            ejbUpdater.actualAdd(category.getCode());
            try {
                ejb = (GeoJsfCategory)this.fSecurity.fByCode(this.cCategory, category.getCode());
                this.ejbLangFactory.rmLang(this.fSecurity, (EjbWithLang)ejb);
                this.ejbDescriptionFactory.rmDescription(this.fSecurity, (EjbWithDescription)ejb);
            }
            catch (UtilsNotFoundException e) {
                try {
                    ejb = (GeoJsfCategory)this.cCategory.newInstance();
                    ejb.setCode(category.getCode());
                    ejb = (GeoJsfCategory)this.fSecurity.persist((Object)ejb);
                }
                catch (InstantiationException e2) {
                    throw new UtilsConfigurationException(e2.getMessage());
                }
                catch (IllegalAccessException e2) {
                    throw new UtilsConfigurationException(e2.getMessage());
                }
                catch (UtilsConstraintViolationException e2) {
                    throw new UtilsConfigurationException(e2.getMessage());
                }
            }
            try {
                ejb.setName(this.ejbLangFactory.getLangMap(category.getLangs()));
                ejb.setDescription(this.ejbDescriptionFactory.create(category.getDescriptions()));
                ejb = (GeoJsfCategory)this.fSecurity.update((Object)ejb);
            }
            catch (UtilsConstraintViolationException e) {
                logger.error("", (Throwable)e);
            }
            catch (UtilsLockingException e) {
                logger.error("", (Throwable)e);
            }
        }
        ejbUpdater.remove(this.fSecurity);
        logger.trace("initUpdateUsecaseCategories finished");
    }
}

