/*
 * Decompiled with CFR 0.152.
 */
package org.geojsf.util.db.init;

import net.sf.ahtutils.db.ejb.AhtDbEjbUpdater;
import net.sf.ahtutils.exception.ejb.UtilsConstraintViolationException;
import net.sf.ahtutils.exception.ejb.UtilsLockingException;
import net.sf.ahtutils.exception.ejb.UtilsNotFoundException;
import net.sf.ahtutils.exception.processing.UtilsConfigurationException;
import net.sf.ahtutils.factory.ejb.status.EjbDescriptionFactory;
import net.sf.ahtutils.factory.ejb.status.EjbLangFactory;
import net.sf.ahtutils.interfaces.facade.UtilsFacade;
import net.sf.ahtutils.interfaces.model.graphic.UtilsGraphic;
import net.sf.ahtutils.interfaces.model.status.UtilsDescription;
import net.sf.ahtutils.interfaces.model.status.UtilsLang;
import net.sf.ahtutils.interfaces.model.status.UtilsStatus;
import net.sf.ahtutils.model.interfaces.with.EjbWithDescription;
import net.sf.ahtutils.model.interfaces.with.EjbWithLang;
import org.geojsf.factory.ejb.EjbGeoLayerFactory;
import org.geojsf.interfaces.facade.GeoJsfFacade;
import org.geojsf.interfaces.model.core.GeoJsfCategory;
import org.geojsf.interfaces.model.core.GeoJsfLayer;
import org.geojsf.interfaces.model.core.GeoJsfMap;
import org.geojsf.interfaces.model.core.GeoJsfService;
import org.geojsf.interfaces.model.core.GeoJsfView;
import org.geojsf.interfaces.model.meta.GeoJsfDataSource;
import org.geojsf.interfaces.model.meta.GeoJsfViewPort;
import org.geojsf.interfaces.model.sld.GeoJsfSld;
import org.geojsf.interfaces.model.sld.GeoJsfSldRule;
import org.geojsf.interfaces.model.sld.GeoJsfSldTemplate;
import org.geojsf.model.xml.geojsf.Layer;
import org.geojsf.model.xml.geojsf.Layers;
import org.geojsf.util.db.init.DbViewPortInit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbLayerInit<L extends UtilsLang, D extends UtilsDescription, G extends UtilsGraphic<L, D, G, GT, GS>, GT extends UtilsStatus<GT, L, D>, GS extends UtilsStatus<GS, L, D>, CATEGORY extends GeoJsfCategory<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SERVICE extends GeoJsfService<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, LAYER extends GeoJsfLayer<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, MAP extends GeoJsfMap<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, VIEW extends GeoJsfView<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, VP extends GeoJsfViewPort<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, DS extends GeoJsfDataSource<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SLDTEMPLATE extends GeoJsfSldTemplate<L, D, SLDTEMPLATE, SLDTYPE>, SLDTYPE extends UtilsStatus<SLDTYPE, L, D>, SLD extends GeoJsfSld<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, RULE extends GeoJsfSldRule<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>> {
    static final Logger logger = LoggerFactory.getLogger(DbLayerInit.class);
    private final Class<CATEGORY> cCategory;
    private final Class<SERVICE> cService;
    private final Class<LAYER> cLayer;
    private UtilsFacade fUtils;
    private GeoJsfFacade<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> fGeo;
    private EjbLangFactory<L> efLang;
    private EjbDescriptionFactory<D> efDescription;
    private EjbGeoLayerFactory<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> ejbLayerFactory;
    private DbViewPortInit<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> dbVpInit;

    public DbLayerInit(Class<L> cL, Class<D> cD, Class<CATEGORY> cCategory, Class<SERVICE> cService, Class<LAYER> cLayer, Class<VP> cVp, UtilsFacade fUtils, GeoJsfFacade<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> fGeo) {
        this.cCategory = cCategory;
        this.cService = cService;
        this.cLayer = cLayer;
        this.fUtils = fUtils;
        this.fGeo = fGeo;
        this.efLang = EjbLangFactory.createFactory(cL);
        this.efDescription = EjbDescriptionFactory.createFactory(cD);
        this.ejbLayerFactory = EjbGeoLayerFactory.factory(cL, cLayer);
        this.dbVpInit = DbViewPortInit.factory(cVp, fUtils);
    }

    public static <L extends UtilsLang, D extends UtilsDescription, G extends UtilsGraphic<L, D, G, GT, GS>, GT extends UtilsStatus<GT, L, D>, GS extends UtilsStatus<GS, L, D>, CATEGORY extends GeoJsfCategory<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SERVICE extends GeoJsfService<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, LAYER extends GeoJsfLayer<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, MAP extends GeoJsfMap<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, VIEW extends GeoJsfView<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, VP extends GeoJsfViewPort<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, DS extends GeoJsfDataSource<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SLD extends GeoJsfSld<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, RULE extends GeoJsfSldRule<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SLDTYPE extends UtilsStatus<SLDTYPE, L, D>, SLDTEMPLATE extends GeoJsfSldTemplate<L, D, SLDTEMPLATE, SLDTYPE>> DbLayerInit<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> factory(Class<L> cL, Class<D> cD, Class<CATEGORY> cCategory, Class<SERVICE> cService, Class<LAYER> cLayer, Class<VP> cVp, UtilsFacade fUtils, GeoJsfFacade<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> fGeo) {
        return new DbLayerInit<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>(cL, cD, cCategory, cService, cLayer, cVp, fUtils, fGeo);
    }

    public void iuLayers(Layers layers, String[] langKeys) throws UtilsConfigurationException {
        logger.debug("i/u " + Layers.class.getSimpleName() + " with " + layers.getLayer().size() + " " + Layer.class.getSimpleName());
        AhtDbEjbUpdater updateLayer = AhtDbEjbUpdater.createFactory(this.cLayer);
        updateLayer.dbEjbs(this.fUtils.all(this.cLayer));
        for (Layer layer : layers.getLayer()) {
            GeoJsfLayer ejb;
            GeoJsfCategory category;
            GeoJsfService service;
            updateLayer.actualAdd(layer.getCode());
            try {
                service = (GeoJsfService)this.fUtils.fByCode(this.cService, layer.getService().getCode());
                category = (GeoJsfCategory)this.fUtils.fByCode(this.cCategory, layer.getCategory().getCode());
            }
            catch (UtilsNotFoundException e1) {
                throw new UtilsConfigurationException(e1.getMessage());
            }
            try {
                ejb = (GeoJsfLayer)this.fUtils.fByCode(this.cLayer, layer.getCode());
                this.efLang.rmLang(this.fUtils, (EjbWithLang)ejb);
                this.efDescription.rmDescription(this.fUtils, (EjbWithDescription)ejb);
            }
            catch (UtilsNotFoundException e) {
                try {
                    ejb = this.ejbLayerFactory.build(layer.getCode(), service, category, langKeys);
                    ejb = (GeoJsfLayer)this.fUtils.persist((Object)ejb);
                }
                catch (UtilsConstraintViolationException e2) {
                    throw new UtilsConfigurationException(e2.getMessage());
                }
            }
            try {
                ejb.setName(this.efLang.getLangMap(layer.getLangs()));
                ejb.setDescription(this.efDescription.create(layer.getDescriptions()));
                boolean layerSql = false;
                if (layer.isSetSql()) {
                    layerSql = layer.isSql();
                }
                ejb.setSqlLayer(Boolean.valueOf(layerSql));
                ejb.setTemporalLayer(layer.isTemporal());
                ejb.setService((GeoJsfService)this.fUtils.fByCode(this.cService, layer.getService().getCode()));
                ejb = (GeoJsfLayer)this.fUtils.update((Object)ejb);
                if (!layer.isSetViewPort()) continue;
                ejb = this.fGeo.load(this.cLayer, ejb);
                this.dbVpInit.iuViewPort(ejb, layer.getViewPort());
            }
            catch (UtilsConstraintViolationException e) {
                logger.error("", (Throwable)e);
            }
            catch (UtilsLockingException e) {
                logger.error("", (Throwable)e);
            }
            catch (UtilsNotFoundException e) {
                logger.error("", (Throwable)e);
            }
        }
        updateLayer.remove(this.fUtils);
        logger.trace("initUpdateUsecaseCategories finished");
    }
}

