/*
 * Decompiled with CFR 0.152.
 */
package org.geojsf.util.db.init;

import net.sf.ahtutils.exception.ejb.UtilsConstraintViolationException;
import net.sf.ahtutils.exception.ejb.UtilsLockingException;
import net.sf.ahtutils.exception.ejb.UtilsNotFoundException;
import net.sf.ahtutils.exception.processing.UtilsConfigurationException;
import net.sf.ahtutils.factory.ejb.status.EjbDescriptionFactory;
import net.sf.ahtutils.factory.ejb.status.EjbLangFactory;
import net.sf.ahtutils.factory.xml.status.XmlTypeFactory;
import net.sf.ahtutils.interfaces.facade.UtilsFacade;
import net.sf.ahtutils.interfaces.model.graphic.UtilsGraphic;
import net.sf.ahtutils.interfaces.model.status.UtilsDescription;
import net.sf.ahtutils.interfaces.model.status.UtilsLang;
import net.sf.ahtutils.interfaces.model.status.UtilsStatus;
import net.sf.ahtutils.model.interfaces.with.EjbWithDescription;
import net.sf.ahtutils.model.interfaces.with.EjbWithLang;
import net.sf.ahtutils.monitor.DataUpdateTracker;
import net.sf.ahtutils.web.rest.AbstractUtilsRest;
import net.sf.ahtutils.xml.aht.Aht;
import net.sf.ahtutils.xml.sync.DataUpdate;
import org.geojsf.factory.ejb.sld.EjbGeoSldTemplateFactory;
import org.geojsf.interfaces.facade.GeoJsfFacade;
import org.geojsf.interfaces.model.core.GeoJsfCategory;
import org.geojsf.interfaces.model.core.GeoJsfLayer;
import org.geojsf.interfaces.model.core.GeoJsfMap;
import org.geojsf.interfaces.model.core.GeoJsfService;
import org.geojsf.interfaces.model.core.GeoJsfView;
import org.geojsf.interfaces.model.meta.GeoJsfDataSource;
import org.geojsf.interfaces.model.meta.GeoJsfViewPort;
import org.geojsf.interfaces.model.sld.GeoJsfSld;
import org.geojsf.interfaces.model.sld.GeoJsfSldRule;
import org.geojsf.interfaces.model.sld.GeoJsfSldTemplate;
import org.geojsf.interfaces.rest.db.GeoJsfDatabaseImportRest;
import org.geojsf.model.xml.geojsf.Layers;
import org.geojsf.model.xml.geojsf.Maps;
import org.geojsf.model.xml.geojsf.Repository;
import org.geojsf.model.xml.geojsf.SldTemplate;
import org.geojsf.util.db.init.DbCategoryInit;
import org.geojsf.util.db.init.DbLayerInit;
import org.geojsf.util.db.init.DbMapInit;
import org.geojsf.util.db.init.DbServiceInit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoJsfDbInit<L extends UtilsLang, D extends UtilsDescription, G extends UtilsGraphic<L, D, G, GT, GS>, GT extends UtilsStatus<GT, L, D>, GS extends UtilsStatus<GS, L, D>, CATEGORY extends GeoJsfCategory<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SERVICE extends GeoJsfService<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, LAYER extends GeoJsfLayer<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, MAP extends GeoJsfMap<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, VIEW extends GeoJsfView<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, VP extends GeoJsfViewPort<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, DS extends GeoJsfDataSource<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SLDTEMPLATE extends GeoJsfSldTemplate<L, D, SLDTEMPLATE, SLDTYPE>, SLDTYPE extends UtilsStatus<SLDTYPE, L, D>, SLD extends GeoJsfSld<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, RULE extends GeoJsfSldRule<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>>
extends AbstractUtilsRest<L, D>
implements GeoJsfDatabaseImportRest {
    static final Logger logger = LoggerFactory.getLogger(GeoJsfDbInit.class);
    private final Class<SERVICE> cService;
    private final Class<CATEGORY> cCategory;
    private final Class<LAYER> cLayer;
    private final Class<MAP> cMap;
    private final Class<VIEW> cView;
    private final Class<VP> cVp;
    private final Class<SLDTYPE> cSldType;
    private final Class<SLDTEMPLATE> cSldTemplate;
    private UtilsFacade fSecurity;
    private GeoJsfFacade<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> fGeo;
    private String[] langKeys;
    private EjbLangFactory<L> ejbLangFactory;
    private EjbDescriptionFactory<D> ejbDescriptionFactory;
    private EjbGeoSldTemplateFactory<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> efSldTemplate;

    public GeoJsfDbInit(UtilsFacade fUtils, String[] langKeys, GeoJsfFacade<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> fGeo, Class<L> cLang, Class<D> cDescription, Class<SERVICE> cService, Class<CATEGORY> cCategory, Class<LAYER> cLayer, Class<MAP> cMap, Class<VIEW> cView, Class<VP> cVp, Class<SLDTYPE> cSldType, Class<SLDTEMPLATE> cSldTemplate) {
        super(fUtils, langKeys, cLang, cDescription);
        this.cService = cService;
        this.cCategory = cCategory;
        this.cLayer = cLayer;
        this.cMap = cMap;
        this.cView = cView;
        this.cVp = cVp;
        this.cSldType = cSldType;
        this.cSldTemplate = cSldTemplate;
        this.fSecurity = fUtils;
        this.fGeo = fGeo;
        this.langKeys = langKeys;
        this.ejbLangFactory = EjbLangFactory.createFactory(cLang);
        this.ejbDescriptionFactory = EjbDescriptionFactory.createFactory(cDescription);
        this.efSldTemplate = EjbGeoSldTemplateFactory.factory(cSldTemplate);
    }

    public static <L extends UtilsLang, D extends UtilsDescription, G extends UtilsGraphic<L, D, G, GT, GS>, GT extends UtilsStatus<GT, L, D>, GS extends UtilsStatus<GS, L, D>, CATEGORY extends GeoJsfCategory<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SERVICE extends GeoJsfService<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, LAYER extends GeoJsfLayer<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, MAP extends GeoJsfMap<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, VIEW extends GeoJsfView<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, VP extends GeoJsfViewPort<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, DS extends GeoJsfDataSource<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SLD extends GeoJsfSld<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, RULE extends GeoJsfSldRule<L, D, G, GT, GS, SLDTEMPLATE, SLDTYPE, SLD, RULE>, SLDTYPE extends UtilsStatus<SLDTYPE, L, D>, SLDTEMPLATE extends GeoJsfSldTemplate<L, D, SLDTEMPLATE, SLDTYPE>> GeoJsfDbInit<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> factory(UtilsFacade fUtils, GeoJsfFacade<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> fGeo, String[] langKeys, Class<L> cL, Class<D> cD, Class<SERVICE> cService, Class<CATEGORY> cCategory, Class<LAYER> cLayer, Class<MAP> cMap, Class<VIEW> cView, Class<VP> cVp, Class<SLDTYPE> cSldType, Class<SLDTEMPLATE> cSldTemplate) {
        return new GeoJsfDbInit<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE>(fUtils, langKeys, fGeo, cL, cD, cService, cCategory, cLayer, cMap, cView, cVp, cSldType, cSldTemplate);
    }

    public DataUpdate importGeoJsfServices(Repository repository) {
        DbServiceInit serviceInit = DbServiceInit.factory(this.cL, this.cD, this.cService, this.fSecurity);
        try {
            serviceInit.iuServices(repository);
        }
        catch (UtilsConfigurationException e) {
            e.printStackTrace();
        }
        return new DataUpdate();
    }

    public DataUpdate importGeoJsfCategories(Repository categories) {
        DbCategoryInit geoCategoryDbInit = DbCategoryInit.factory(this.cL, this.cD, this.cCategory, this.fSecurity);
        try {
            geoCategoryDbInit.iuServices(categories);
        }
        catch (UtilsConfigurationException e) {
            e.printStackTrace();
        }
        return new DataUpdate();
    }

    public DataUpdate importGeoJsfLayers(Layers layers) {
        DbLayerInit<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> layerInit = DbLayerInit.factory(this.cL, this.cD, this.cCategory, this.cService, this.cLayer, this.cVp, this.fSecurity, this.fGeo);
        try {
            layerInit.iuLayers(layers, this.langKeys);
        }
        catch (UtilsConfigurationException e) {
            e.printStackTrace();
        }
        return new DataUpdate();
    }

    public DataUpdate importGeoJsfMaps(Maps maps) {
        DbMapInit<L, D, G, GT, GS, CATEGORY, SERVICE, LAYER, MAP, VIEW, VP, DS, SLDTEMPLATE, SLDTYPE, SLD, RULE> viewInit = DbMapInit.factory(this.cL, this.cD, this.cLayer, this.cMap, this.cView, this.cVp, this.fSecurity, this.fGeo);
        try {
            viewInit.iuMaps(maps);
        }
        catch (UtilsConfigurationException e) {
            e.printStackTrace();
        }
        return new DataUpdate();
    }

    public DataUpdate importGeoJsfSldTypes(Aht types) {
        return super.importStatus(this.cSldType, null, types);
    }

    public DataUpdate importGeoJsfSldTemplates(Repository templates) {
        DataUpdateTracker dut = new DataUpdateTracker(true);
        dut.setType(XmlTypeFactory.build((String)this.cSldTemplate.getName(), (String)"DB Import"));
        for (SldTemplate xTemplate : templates.getSldTemplate()) {
            GeoJsfSldTemplate eTemplate = null;
            try {
                eTemplate = (GeoJsfSldTemplate)this.fSecurity.fByCode(this.cSldTemplate, xTemplate.getCode());
                this.ejbLangFactory.rmLang(this.fSecurity, (EjbWithLang)eTemplate);
                this.ejbDescriptionFactory.rmDescription(this.fSecurity, (EjbWithDescription)eTemplate);
            }
            catch (UtilsNotFoundException e) {
                try {
                    UtilsStatus type = (UtilsStatus)this.fSecurity.fByCode(this.cSldType, xTemplate.getType().getCode());
                    eTemplate = this.efSldTemplate.build(type, xTemplate.getCode());
                    eTemplate = (GeoJsfSldTemplate)this.fSecurity.persist((Object)eTemplate);
                }
                catch (UtilsConstraintViolationException e1) {
                    dut.fail((Throwable)e1, true);
                }
                catch (UtilsNotFoundException e1) {
                    dut.fail((Throwable)e1, true);
                }
            }
            if (eTemplate == null || eTemplate.getId() <= 0L) continue;
            try {
                eTemplate.setName(this.ejbLangFactory.getLangMap(xTemplate.getLangs()));
                eTemplate.setDescription(this.ejbDescriptionFactory.create(xTemplate.getDescriptions()));
                eTemplate = (GeoJsfSldTemplate)this.fSecurity.update((Object)eTemplate);
                dut.success();
            }
            catch (UtilsConstraintViolationException e) {
                dut.fail((Throwable)e, true);
            }
            catch (UtilsLockingException e) {
                dut.fail((Throwable)e, true);
            }
        }
        return dut.toDataUpdate();
    }
}

